; Contribution to Hugi-compo #8
; Mikael Klasson (Fluff)
; fluff@geocities.com
; http://octacom.net/fluff
;
; 189 bytes
;
; Assemble directly to .COM with NASM
;
[BITS 16]
[ORG 100h]
_100h:
	call	_read		; read first char in msg

	mov	ah,6		; output function#

	mov	bl,101010b	; BOM

	cmp	al,'_'          ; check read char
	jne	encode		; first char of BOM? (invalid text symbol)

;-------------------------------------
; decode: A space is output before the character when BL & 1 = 1
; '_' and '.' are valid symbol characters
; '/' and ' ' are valid separators
; CR and LF must be ignored
decode:
	mov	bh,1
declop:
	sub	al,'.'+1        ; convert char to a bit
	adc	bh,bh		;  and insert it
	jmp	short pushread	; read new char
reread:
	js	_ret		; end of input?
 
	sub	al,0eh		; calc space toggle	 _  .	/ SP  CR LF
	jb	pushread	; CR or LF		51 20, 21 12, ff fc
	jpo	declop		; '_' or '.'             o  o   e  e

	xchg	al,bh
	mov	di,codes
	mov	cl,60+43	; NEWLINE is encoded later than the rest
	repne	scasb		; next-to-last code is NEWLINE
	jcxz	nextcode	; reaching last one means no output (BOM)

	shr	bl,1		; output a space?
	jnc	nospacing
	mov	dl,' '
	int	21h
nospacing:

	db	08dh,055h	; lea dx,[di-codes+26h]
	db	_100h-codes+26h ; (jeez, wonderful syntax)

	mov	bl,bh		; activate new space toggle

	loop	putc		; not NEWLINE?

	db	101110b 	; cs:	(table data for NEWLINE)

	mov	dl,13
	int	21h		; output CR
	mov	dl,10
putc:
	int	21h		; output decoded char or LF

nextcode:
	mov	bh,1		; set leftmost code bit
pushread:
	push	word reread

;------------------------------------
; Reads a byte from the input stream
; AL = byte read
_read:
	pusha
	mov	ah,3fh
	xor	bx,bx
	mov	cl,1
	mov	dx,bp		; 09xxh at init; writing to [bp] is ok
	int	21h
	dec	ax

codes:
db	1100001b		; apostrophe (encoded as a popa instruction)

;--- 4 bytes gap
_moval:
	mov	al,[bp+0]
_ret:
	ret

db	1001100b
db	1011110b
db	1101010b
db	101101b

db	100000b
db	110000b
db	111000b
db	111100b
db	111110b
db	111111b
db	101111b
db	100111b
db	100011b
db	100001b

db	1000111b
db	1010101b

;--- 3 bytes gap
encode:
	call	put	; output BOM
db	1110011b	; jae xx, this relies on CF being 0 after int 21h/6
;--- 1 byte gap
db	noread-encode-5 ; jump to noread

db	110b
db	10111b
db	10101b
db	1011b
db	11b
db	11101b
db	1001b
db	11111b
db	111b
db	11000b
db	1010b
db	11011b
db	100b
db	101b
db	1000b
db	11001b
db	10010b
db	1101b
db	1111b
db	10b
db	1110b
db	11110b
db	1100b
db	10110b
db	10100b
db	10011b

;--- 5 bytes gap
enclop:
	inc	cx		; change slash/space indicator
nochange:
	call	_read

db	0b3h			; mov bl,xx (one wasted byte)
db	1101101b		; '`' last normal table data

; encode: A slash is output before the code when CX != 0, a space otherwise

	mov	bl,110101b	; EOM
	js	slash

noread:
	cmp	al,60h		; is it a literal?
	jbe	normal
	sub	al,20h		; make uppercase
normal:
	mov	bl,al

	db	08ah,058h	; mov bl,[codes+bx+si-127h]
	db	codes-_100h-27h

	cmp	bl,0b1h
	je	enclop		; 0b1h is the code at space's location
	ja	nochange	; 0fbh is the code at LF's location

	push	word enclop

	mov	dl,' '
	jcxz	space		; output space or slash?
slash:
	mov	dl,'/'
space:
	int	21h

put:				; outputs morse code encoded in BL
	bsr	cx,bx		; get number of bits in code

putlop:
	dec	cx
	js	_moval
	bt	bx,cx		; '_' or '.'?
	mov	dl,'.'          ; also table data for NEWLINE
	jc	intlop
	mov	dl,'_'
intlop:
	int	21h
	jmp	short putlop

end
