; Slightly modified version of Ruud's  "TEST.ASM" screen capture code.
;
; Changes by TAD:
;	- palette buffer used to avoid possible overwrite of following code
;	- checks for INT 16h functions 00h, 01h, 10h and 11h
;	- returns a fake key-press (spacebar) and ZF=0
;	- "One-shot" operation (ie. it disables itself after 1st capture)
;	- creates the raw 64768 file called "ENTRY.RAW" instead of "TEST.RAW"

	.model	tiny
	.386
	
	.code
begin:	org	100h
start:	mov	sp,(Top-begin+20fh) and 0fff0h
	mov	bx,(Top-begin+50fh)/16
	mov	ah,4ah
	int	21h	;Resize req mem

	mov	byte ptr disable,0
	
	mov	ax,cs
	mov	wcs1,ax
	mov	wcs2,ax
	mov	wcs3,ax
	mov	ax,3516h
	int	21h	;Get vector 10h
	mov	word ptr dOrg16,bx
	mov	word ptr dOrg16+2,es
	mov	dx,offset cs:int16
	mov	ax,2516h
	int	21h	;New vector 10h
	mov	dx,offset ds:bFname
	push	ds
	pop	es
	mov	bx,offset ds:xEpb
	mov	ax,4b00h
	int	21h	;execute entry.com

	lds	dx,cs:dOrg16
	mov	ax,2516h
	int	21h	;Restore vector 10h
	mov	ah,4ch
	int	21h	;Exit

; Modified INT 16h wedge
;	- now checks for functions 01h, 10h and 11h
;	- returns a fake key press and ZF=0
;	- disables after 1st capture.
int16:
	cmp	cs:[disable],0
	jnz	short go16		; ignore if disabled

	cmp	ah,0
	jz	short grab		; function 00 ?
	cmp	ah,1
	jz	short grab		; function 01 ?
	cmp	ah,10h
	jz	short grab		; function 10h ?
	cmp	ah,11h
	jz	short grab		; function 11h ?
	jmp	short	go16	;>> No flat line
grab:
	mov	cs:[disable],1		; stop any further captures

	pusha
	push	ds
	push	es
	push	cs
	pop	es
	push	cs
	pop	ds
	lea	dx,palettebuffer
	xor	bx,bx
	mov	cx,100h
	mov	ax,1017h
	int	10h
	xor	cx,cx
	mov	ah,3ch
	mov	dx,offset bOname
	int	21h
	xchg	ax,bx
	lea	dx,palettebuffer
	mov	cx,300h
	mov	ah,40h
	int	21h
	mov	dx,0a000h
	mov	ds,dx
	xor	dx,dx
	mov	cx,0fa00h
	mov	ah,40h
	int	21h
	mov	ah,3eh
	int	21h
	pop	es
	pop	ds

	mov	bp,sp
	and	byte ptr [bp+16+4],0BFh	; make ZF=0 (functions 01 and 11h)
	popa
	mov	ax,3920h		; fake key = spacebar
	iret

go16:	db	0eah	;Don't mess with interrupt
dOrg16	dd	?

palettebuffer	db	768 dup (?)	; safe area for palette

disable	db	?			; disable flag

bFname	Db	'ENTRY.COM',0
bOname	Db	'ENTRY.RAW',0
xEpb	Dw	0	;Inherit env
	Dw	80h
wcs1	Dw	?
	Dw	5ch
wcs2	Dw	?
	Dw	6ch
wcs3	Dw	?
	Dw	$-xEpb


Top	Label	Byte

	end	start

