// =========================================================================
//  RAWPack -- Hugi Compo example program, by Jibz '99
//
//  Please note:
//    Because the image data is 64000 bytes and the buffer is 4096 bytes,
//    and 8 divides both of these, the tag-bytes will always be okey (ie.
//    no problems with overlaps between the blocks) .. ;)
// =========================================================================

#include <string.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <conio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>

// Possible errors
enum { IN_ERR = 1, SIZE_ERR, OUT_ERR };

#define BUFFERSIZE 4096

unsigned char inbuffer[BUFFERSIZE];
unsigned char outbuffer[BUFFERSIZE * 2];

// Global variables used
int infile = -1, outfile = -1;

unsigned int inpos, outpos;
unsigned int tagpos, bitcount;

// The depacker
const unsigned char depacker[] = {
   0xFC, 0x0E, 0x1F, 0xB8, 0x13, 0x00, 0xCD, 0x10, 0xBA, 0xC8,
   0x03, 0x31, 0xC0, 0xEE, 0x42, 0xBE, 0x4D, 0x01, 0xB9, 0x00,
   0x03, 0xAC, 0xEE, 0xE2, 0xFC, 0xB8, 0x00, 0xA0, 0x8E, 0xC0,
   0x31, 0xFF, 0xB6, 0x01, 0x81, 0xFF, 0x00, 0xFA, 0x73, 0x0B,
   0x31, 0xC0, 0xE8, 0x14, 0x00, 0x73, 0x01, 0xAC, 0xAA, 0xEB,
   0xEF, 0x31, 0xC0, 0xCD, 0x16, 0xB8, 0x03, 0x00, 0xCD, 0x10,
   0xB8, 0x00, 0x4C, 0xCD, 0x21, 0xFE, 0xCE, 0x75, 0x05, 0x8A,
   0x14, 0x46, 0xB6, 0x08, 0x00, 0xD2, 0xC3
};
const unsigned int depacker_size = 77;

// The shower
const unsigned char shower[] = {
   0xFC, 0x0E, 0x1F, 0xB8, 0x13, 0x00, 0xCD, 0x10, 0xBA, 0xC8,
   0x03, 0x31, 0xC0, 0xEE, 0x42, 0xBE, 0x33, 0x01, 0xB9, 0x00,
   0x03, 0xAC, 0xEE, 0xE2, 0xFC, 0xB8, 0x00, 0xA0, 0x8E, 0xC0,
   0x31, 0xFF, 0xB9, 0x00, 0xFA, 0xF3, 0xA4, 0x31, 0xC0, 0xCD,
   0x16, 0xB8, 0x03, 0x00, 0xCD, 0x10, 0xB8, 0x00, 0x4C, 0xCD,
   0x21
};
const unsigned int shower_size = 51;

// =========================================================================
//  FUNCTIONS
// =========================================================================

void advancetagbyte(int bit)
{
   // If current tagbyte is full, get a new one
   if (bitcount == 8)
   {
      bitcount = 0;
      tagpos = outpos++;
   }

   // Shift in bit
   if (bit)
   {
      outbuffer[tagpos] = (outbuffer[tagpos] << 1) + 1;
      bitcount++;
   } else {
      outbuffer[tagpos] <<= 1;
      bitcount++;
   }
}

// Some I/O error handler :)
void myerror(int n)
{
   // Print out error information
   printf("\n\n\007ERR: ");
   switch (n)
   {
      case IN_ERR    : printf("Unable to open input-file!\n"); break;
      case SIZE_ERR  : printf("File has wrong size (not 64768 bytes)!\n"); break;
      case OUT_ERR   : printf("Unable to open output-file!\n"); break;
      default        : printf("An unknown error occured!\n");
   }

   // Free memory and close files
   if (infile != -1) close(infile);
   if (outfile != -1) close(outfile);
   remove("ENTRY.COM");

   // Exit with errorlevel = error no.
   exit(n);
}

// =========================================================================
//  MAIN
// =========================================================================

int main(int argc, char *argv[])
{
   unsigned int size;

   // Write syntax if not correct number of parameters
   if (argc != 2)
   {
      printf("\nSyntax:   RAWPACK <input file>\n\n");
      exit(1);
   }

   // Open input file
   printf(" Opening file\n");
   if ((infile = open(argv[1], O_RDONLY | O_BINARY)) == -1) myerror(IN_ERR);
   lseek(infile, 0, SEEK_SET);

   // Get file size and check it
   if (filelength(infile) != 64768) myerror(SIZE_ERR);

   // Create output file
   if ((outfile = open("ENTRY.COM", O_WRONLY | O_CREAT | O_BINARY | O_TRUNC, S_IREAD | S_IWRITE)) == -1) myerror(OUT_ERR);
   lseek(outfile, 0, SEEK_SET);

   // Write depacker to output file
   write(outfile, depacker, depacker_size);

   // Copy pallette data to output file
   read(infile, inbuffer, 768);
   write(outfile, inbuffer, 768);

   // Read and compress image data from input file to output file
   printf(" Packing ... ");
   bitcount = 8;

   while (size = read(infile, inbuffer, BUFFERSIZE))
   {
      outpos = 0;

      for (inpos = 0; inpos < size; inpos++)
      {
         if (inbuffer[inpos])
         {
           advancetagbyte(1);
           outbuffer[outpos++] = inbuffer[inpos];
         } else {
           advancetagbyte(0);
         }
      }

      write(outfile, outbuffer, outpos);
   }
   printf("Done!\n");

   // If packed file is larger than just showing, do that instead
   if (filelength(outfile) > 64768 + shower_size)
   {
      printf("  - Unable to compress the image, so I'll just show it ;)\n");

      if (outfile != -1) close(outfile);

      // Re-create output file
      if ((outfile = open("ENTRY.COM", O_WRONLY | O_CREAT | O_BINARY | O_TRUNC, S_IREAD | S_IWRITE)) == -1) myerror(OUT_ERR);
      lseek(outfile, 0, SEEK_SET);

      // Write shower to output file
      write(outfile, shower, shower_size);

      // Copy pallette data to output file
      lseek(infile, 0, SEEK_SET);
      read(infile, inbuffer, 768);
      write(outfile, inbuffer, 768);

      // Copy image data
      while (size = read(infile, inbuffer, BUFFERSIZE))
      {
         write(outfile, inbuffer, size);
      }
   }

   // Close in and out files
   printf(" Closing files\n");
   if (infile != -1) close(infile);
   if (outfile != -1) close(outfile);

   // We're happy :)
   return (0);
}
// =========================================================================
//  END
// =========================================================================
