;
;
;                                 RAWCHK
;
;                            RGB compare version
;                    Picture-Checker for the Hugi compo 7 
;                                by TAD 1999
;			   Additional code by Ruud
;
;
;
;   It checks the file length (must be 64768) and the R,G,B values of pixels
;   so it allows for remapping of the image and palette while still checking
;           that the actual picture remains identical to the eye.
;
; Displays the 1st image, waits for a key and then displays the differences
;		in WHITE and the correct pixels in DARK green.

;Changes : Made it a .com file, works a little clearer with segs
;          (actually also did this because I don't own TASM, could not
;          compile the original file, now it works with TASM and MASM
;          Now needs cmdline parameters, compares par1 against par2 this
;          allows the entry to contain multiple images
;

; TAD:	- Now displays the hex pixel address of the 1st error
;	- changed RGB compare
;	- added 'outhex4' routine

; TAD:  - Now displays pixel and RGB values of the 1st error


;
; Compile:
;               TASM rawchk
;               TLINK /t rawchk
;

imagesize        equ       64768

INT_VIDEO        equ       <int 10h>
INT_KEYB         equ       <int 16h>
INT_DOS          equ       <int 21h>

                 .model    tiny
                 .286

                 .data
errorcount       dw        ?
err1staddr	dw	?

greenwhite	db	0,32,0		; green = okay
		db	63,63,63	; white = error


titletxt         db        13,10,"TAD's RGB compare program. "
		 db	         "Additional code by Ruud."
                 db        '$'

infotxt          db        13,10
                 db        13,10,"RGB compare results:-"
                 db        13,10,'Compared "',80h,'" against "',82h,'".'
                 db        13,10
infopoke         db        '00000 error(s) found.'
                 db        13,10
                 db        '$'

err1sttxt	db	'  address     pixel R  G  B      pixel R  G  B',13,10
		db	'[A000:'
err1stoffs	db	'0000] =  '
err1strgb1	db	'00 (xx xx xx)  <>  '
err1strgb2	db	'00 (xx xx xx)',13,10,'$'

errortxt         db        13,10,'**Error** $'

CantLoadRaw      db        "Can't load ",'"',80h,'"'," image",13,10,'$'
CantLoadEntry    db        "Can't load ",'"',82h,'"'," image",13,10,'$'
tCmdLineErr      db        "Use : RAWCHK source.raw dest.raw",13,10,'$'
tMemError        db        "Not enough memory to compare files ",13,10,'$'

                 .data?
wRawName         dw        1 dup (?)
wEntryName       dw        1 dup (?)
wRawSeg          dw        1 dup (?)
wEntrySeg        dw        1 dup (?)

bTxtBuff         db        100h dup (?)
                 dw        800 dup (?)
stacktop         equ       $

                 .code

                 ORG       100h

Start:           mov       ax,offset stacktop
                 add       ax,0fh
                 and       ax,0fff0h
                 mov       sp,ax

                 mov       dx,cs                ;We aren't optimizing
                 shr       ax,4
                 add       ax,dx
                 mov       wRawSeg,ax
                 add       ax,1000h
                 mov       wEntrySeg,ax
                 add       ax,1000h
                 sub       ax,dx
                 xchg      ax,bx
                 mov       ah,4ah
                 int       21h
                 lea       dx,tMemError
                 jc        reporterror

                 lea       dx,titletxt
                 call      DosShow
                 lea       dx,tCmdLineErr
                 
                 ;Command line parsing
                 
                 cld
                 mov       si,80h
                 lodsb
                 cbw
                 xchg      ax,cx
                 jcxz      reporterror

                 call      GetNsp               ;Start of first name
                 jc        reporterror
                 mov       wRawName,bx
                 call      GetSp                ;End of first name
                 jc        reporterror
                 mov       byte ptr [bx],0      ;Terminate first name
                 call      GetNsp               ;Start of first name
                 jc        reporterror
                 mov       wEntryName,bx
                 call      GetSp                ;End of first name
                 jc        reporterror
                 mov       byte ptr [bx],0      ;Terminate first name
                 
                 ;; load original raw image ;;

ok0:             mov       dx,wRawName
                 mov       di,wRawSeg
                 call      loadimage
                 lea       dx,CantLoadRaw
                 jnc short ok1

reporterror:     push      dx
                 lea       dx,errortxt
                 call      DosShow
                 pop       dx
                 call      DosShow
                 mov       ax,4C01h
                 INT_DOS                        ; quit error 1


ok1:             ;; load entry image ;;

                 mov       dx,wEntryName
                 mov       di,wEntrySeg
                 call      loadimage
                 lea       dx,CantLoadEntry
                 jc        reporterror

;
;
; Display original image and wait for a key press
;
;

		mov	ax,0013h
		INT_VIDEO

		mov	ds,wRawSeg
		sub	si,si

		mov	al,0
		mov	cx,768
		call	setcolours	; set palette

		mov	ax,0A000h
		mov	es,ax
		sub	di,di
		mov	cx,64000
		rep	movsb		; copy image to VGA memory

		mov	ah,0
		INT_KEYB


;
;
; Now compare and display differencies between the "HUGI.RAW" and "ENTRY.RAW"
;  this version simply counts the number of RGB differencies.
;
;

		push	cs
		pop	ds
		lea	si,greenwhite
		mov	al,1
		mov	cx,6
		call	setcolours	; set colours 1 and 2



                 ;; now count differences between raw & entry images ;;

                 sub       cx,cx                ; incorrect pixel count = 0

                 sub       di,di
compare:
                 ;; get raw R,G,B value for 1 pixel ;;

                 mov       ax,cs:wRawSeg
                 mov       ds,ax                ; [DS:0000] --> raw image

                 mov       al,[di+768]          ; get raw pixel
                 mov       ah,3
                 mul       ah                   ; AX = pixel * 3
                 mov       si,ax
                 lodsw
                 mov       bx,ax                ; BL = Red, BH = Green
                 lodsb
                 mov       dl,al                ; DL = Blue

                 ;; compare R,G,B values against ENTRY.RAW pixel ;;

                 mov       ax,cs:wEntrySeg
                 mov       ds,ax                ; [DS:0000] --> entry image

                 mov       al,[di+768]          ; get entry pixel
                 mov       ah,3
                 mul       ah
                 mov       si,ax
                 lodsw
                 sub       bx,ax
                 lodsb
                 sub       dl,al

                 ;; hide matching R,G,B pixel by plotting colour 0 ;;

		mov	al,1		; colour 1 = green
		mov	dh,0
		or	bx,dx		; is RGB correct ?
		jz	short correct

		test	cx,cx
		jnz	short err2nd
		mov	bp,di		; keep address of 1st error
err2nd:
		inc	cx		; count number of errors
		mov	al,2		; colour 2 = white
correct:
		stosb
                 cmp       di,64000
                 jnz       short compare        ; compare all 64000 pixels

                 push      cs
                 pop       ds
                 push      cs
                 pop       es
                 
		mov	[err1staddr],bp
		mov       [errorcount],cx

		;; wait for a key press ;;

		mov	ah,00h
		INT_KEYB

		mov	ax,0003h
		INT_VIDEO

		lea	dx,titletxt
		mov	ah,9
		INT_DOS

                 lea       di,infopoke
                 mov       ax,[errorcount]
                 call      outdec5

                 lea       dx,infotxt
                 call      DosShow


                 ;; back to DOS... ;;

                 mov       cx,[errorcount]
                 jcxz      allokay		; no errors ?

		;; display 1st pixel error ;;

		lea	di,err1strgb1
                mov	ax,cs:wRawSeg
		call	outpixrgb

		lea	di,err1strgb2
		mov	ax,cs:wEntrySeg
		call	outpixrgb

		lea	di,err1stoffs
		mov	ax,[err1staddr]
		call	outhex4
		lea	dx,err1sttxt
		mov	ah,9
		INT_DOS				; display addr of 1st error

                 mov       ax,4C02h
                 INT_DOS                        ; quit error 2 (errors found)

allokay:
                 mov       ax,4C00h
                 INT_DOS                        ; quit error 0

;
; Output(AX) as 4 digit hex into [ES:DI]
;
outhex4:
	push	ax
	mov	al,ah
	call	outhex2
	pop	ax
outhex2:
	aam	16
	cmp	al,10
	sbb	al,69h
	das
	xchg	ah,al
	cmp	al,10
	sbb	al,69h
	das
	stosw
	ret

;
; Output Pixel and RGB into[ES:DI] from seg(AX) 
;
outpixrgb:
	mov	si,[err1staddr]
	push	ds
	mov	ds,ax
	mov	al,[si+768]
	call	outhex2
	inc	di
	inc	di
	mov	al,3
	mul	byte ptr [si+768]
	xchg	ax,si
	lodsb
	call	outhex2
	inc	di
	lodsb
	call	outhex2
	inc	di
	lodsb
	call	outhex2
	pop	ds
	ret

;
; Output(AX) as 5 digit decimal into [DS:DI]
;
outdec5:
                 mov       cl,0
                 mov       bx,10000
                 call      divdecimal
                 mov       bx,1000
                 call      divdecimal
                 mov       bx,100
                 call      divdecimal
                 mov       bx,10
                 call      divdecimal
                 add       al,'0'
                 stosb
                 ret
divdecimal:
                 mov       byte ptr [di],' '
                 sub       dx,dx
                 div       bx
                 or        cl,al
                 jz        short divzero
                 add       al,'0'
                 mov       [di],al
divzero:
                 inc       di
                 xchg      ax,dx
                 ret

;
; Set colours[DS:SI] bytes(CX) start colour(AL)
;
setcolours:
	mov	dx,3C8h
	out	dx,al
	inc	dx
colorlp:
	lodsb
	out	dx,al
	loop	colorlp
	ret


;
; Load image[DS:DX] into[DI:0000]
;

loadimage:       mov       ax,3D00h
                 INT_DOS
                 jc short loaderror
                 xchg      ax,bx
                 push      ds
                 mov       ds,di
                 sub       dx,dx
                 mov       cx,(imagesize+1)     ; try to load (imagesize + 1)
                 mov       ah,3Fh
                 INT_DOS
                 pop       ds
                 jc        short loaderror
                 cmp       ax,imagesize
                 jnz       short loaderror      ; MUST only load imagesize !!
                 mov       ah,3Eh
                 INT_DOS
loaderror:
                 ret

GetNsp:          mov       bx,si
                 lodsb
                 cmp       al,' '
                 ja        Gns0
                 loop      GetNsp
                 stc
Gns0:            ret

GetSp:           mov       bx,si
                 lodsb
                 cmp       al,21h
                 jb        Gsp0
                 loop      GetSp
Gsp0:            cmc
                 ret

;*** Needed for cmdline parameters, 80h replaces first name, 82h second

DosShow:         pusha
                 push      es
                 push      ds
                 mov       di,offset bTxtBuff

                 mov       si,cs
                 mov       ds,si
                 mov       es,si
                 mov       si,dx
                 mov       dx,di

Ds0:             lodsb
                 or        al,al
                 jns       Ds2
                 push      si
                 and       ax,2
                 xchg      si,ax
                 mov       si,[si+wRawName]
                 db        0a8h
Ds1:             stosb
                 lodsb
                 or        al,al
                 jnz       Ds1
                 pop       si
                 db        0a8h
Ds2:             stosb
                 cmp       al,'$'
                 jnz       Ds0

                 mov       ah,9
                 INT_DOS

                 pop       ds
                 pop       es
                 popa
                 ret

                 END       Start


