;
;                                                                             
;        M A I N   M O D U L E   O F   T H E   E N T R Y   P R O G R A M      
;                                                                             
;

;DO NOT BELEIVE COMMENTS UNCONDITIONALLY! THEY CONTAIN MORE ERRORS THAN THE CODE


; CODE and DATA segments 


        assume  ds:_TEXT,cs:_TEXT
_TEXT   segment

letwar =  8192
intar  =  letwar                ;array 8000 bytes
halval =  intar                 ;array 8000 bytes
palval =  intar                 ;array 8000 bytes
counts =  intar+8000            ;array 8000 bytes
values =  counts+3000           ;array 8000 bytes
vvectx =  values+3000           ;array 5000 bytes
vvecty =  vvectx+3000           ;array 5000 bytes
palet  =  vvecty+3000           ;array 1000 bytes
bordxy =  palet +1000           ;array 3000 words
vectors=  bordxy+3000           ;array 5000 bytes
htree  =  vectors+5000          ;array 512 bytes
clen1  =  htree+512             ;word
clen2  =  clen1+2               ;word
clen3  =  clen2+2               ;word
clenp  =  clen3+8               ;word allow clen's to grow up to clen6
rootsav=  clen1                 ;word
bordend=  clenp+2               ;word
bordxyp=  bordend+2             ;word
dst    =  bordxyp+2             ;word
aux    =  dst+2                 ;word
opt_len=  aux+2                 ;word
itm_wid=  opt_len+2             ;byte
vect   =  itm_wid               ;byte
opt_wid=  itm_wid+1             ;byte
oldvec =  opt_wid+1             ;byte

haloxy =  0                     ;array 8192 words
measur =  haloxy+2*8192         ;array 8192 words
anchor =  measur+2*8192         ;array 8192 words

                          org     100h
bkp     macro
        int     3
        endm

mof     macro   r,t
        mov     r,offset t
        endm

inc2    macro   arg
        inc     arg
        inc     arg
        endm

dec2    macro   arg
        dec     arg
        dec     arg
        endm

ds_cs   macro
        push    cs
        pop     ds
        endm

es_cs   macro
        push    cs
        pop     es
        endm

clr     macro   reg
        xor     reg,reg
        endm

ww      macro
        clr     ah
        int     16h
        endm

ex      macro
        jmp     extdos
        endm

; CODE start point 

                externdef entry_start:near
                externdef entry_end:near
                externdef cycles:byte


check = 0                       ;to check differences

        entry_start:
                mov     ax,13h
                int     10h

                mov     ax,cs
                add     ax,1000h
                mov     ds:[aux],ax     ;
                add     ax,1000h
                mov     ds:[dst],ax

; Zero dst segment

                mov     es,ax
                mov     cx,8000h
                clr     ax
                clr     di
                rep     stosw

; Zero graphic memory

                mov     es,gramem
                mov     cx,64000
                rep     stosb
                es_cs

; Decode and set the palette 

                        mof     si,sqzdat
                        mof     di,palval
                        call    unpack_dif ;get length from stream
                        push    si      ;save ptr to next squeezed data
                        mof     si,palval
                        mof     di,palet
                        push    di      ;save to reuse in BIOS call

        nxt_col:        push    di
                        mov     cx,231  ;count of values
        @@:             movsb           ;copy next byte
                        inc2    di      ;skip next two colors
                        loop    @b      ;
                        pop     di
                        inc     di
                        cmp     di,offset palet+3
                        jnz     nxt_col

; Move the last 7 colors 25 position forwards (224 -> 249)

                        mof     si,palet+3*224
                        mof     di,palet+3*249
                        mov     cl,3*7
                        rep     movsb


if check
                        mov     ds:[palet+3*240],7fh  ;red collor just for the check
endif
                        pop     dx      ;- palette table
                        inc     ch      ;cx = 100h
                        clr     bx
                        mov     ax,1012h;set the
                        int     10h     ;palette
                        pop     si      ;ptr to next squeezed data

;                       jmp     lll


; UPPER LETTERS 


; Decode the cycles
                        mof     di,vectors
                        call    unpack_rpt
                        mof     bp,cycles
                        mof     vectp,vectors


; Decode and display the upper letters 


        dcd:            push    si
                        call    getbound0
                        pop     si
                        mov     di,intar
                        call    unpack_rpt
                        call    filars
                        dec     Hletc           ;any more letters
                        jnz     dcd             ;nz, no

; Decompres the transient area

                        push    si
                        call    getbound0       ;get external transient area bound
                        pop     si
                        mov     ax,ds:[bordxyp]
                        mov     ds:[bordend],ax
                        mov     di,intar
                        call    unpack_huf0
                        call    filars

; Decompress and output the halo

                        push    si
                        call    getbound        ;get external halo area bound
                        call    gethalo         ;get the halo xy array
                        pop     si

                        mov     di,halval
                        push    di
                        call    unpack_rpt
                        pop     di
                        clr     si

                oh:     mov     es,ds:[aux]
                        mov     bx,es:[si]
                        inc2    si
                        mov     al,[di]
                        cmp     al,14           ;color 16 was coded by 14
                        jne     @f
                        inc2    al              ;restore it
                @@:     inc     di
                        mov     es,ds:[dst]
                        mov     es:[bx],al
                        loop    oh

; Copy dst to gramem

                extdos: mov     es,gramem
                        mov     ds,ds:[dst]
                        mov     byte ptr ds:[37*256+196],14 ;the single color 14 point
                        mov     di,320*9+43
                        clr     si
                @@:     mov     cx,256
                        rep     movsb
                        add     di,320-256
                        cmp     di,320*145+43
                        jne     @b
                        ds_cs

        lll:            call    low_letters

if check
                        es_cs
                        mof     dx,hfil
                        mov     ax,3d00h        ;get a file handle code al = read/write attrib
                        int     21h             ;open the file
                        mov     bx,ax
                        mov     ds,ds:dst
                        clr     dx
                        mov     cx,3*256
                        mov     ah,3fh
                        int     21h             ;read data from file
                        clr     dx
                        mov     cx,64000
                        mov     ah,3fh
                        int     21h             ;read data from file
                        mov     ah,3eh
                        int     21h             ;close the file

; Paint differences in red
                        clr     di
                        mov     di,320*145
                        mov     cx,55*320
                        mov     es,cs:[gramem]
                ckn:    mov     al,[di]
                        cmp     es:[di],al
                        je      @f
                        mov     al,240
                @@:     stosb
                        loop    ckn
                        es_cs
                        ds_cs
                        jmp     @f
                        hfil    db      'hugi.raw',0
                @@:
endif

                        clr     ah
                        int     16H
                        mov     ax,3
                        int     10h
                        ret

                        vvc     dw 0            ;count of vertical vectors
                        vvp     dw 0            ;pointer to vertical vectors
                        Hletc   db 4
                        cycles  db 27,14,0,102,46,0,189,39,157,81,0
                                db 216,8,209,39,0,27,13,160,80,213,7,0
                                db 25,7,160,74,211,1,0
                                                ;contains cycle roots
                        vectp   dw ?            ;pointer to current cycle


; Sort the halo points 

        gethalo:
                clr     bx              ;start from 1st point in mir
                clr     di              ;index in haloxy, anchors, measures

        nxtpnt: inc     bx              ;point x,y
                jnz     @f              ;nz - more points to check
                ret

        @@:     call    ckin            ;point in our area?
                jz      nxtpnt          ;z - no
                mov     es,ds:[dst]     ;
                cmp     byte ptr es:[bx],0;point is in the core or transient?
                jnz     nxtpnt          ;nz - yes


; Process a halo point 
; Found a neighbour - get its distance to core and its anchor.
; Range it accordingly.
;


; Get distance and anchor 
; Find a point from the border which is closest to a selected one and is
; closest to the beginning of border (its index is called an anchor)
; On entry:bx = selected point;
; On exit: dx = distance of [bx] to anchor point;
;          bp - 2 = anchor.
;

                push    di
                mov     si,bordxy       ;
                push    si
                mov     dx,-1           ;distance estimate = max

        lc0:    lodsw                   ;ax = next point from border
                call    getsqd          ;get the square of the distance

; Compare and replace distance if smaller

                cmp     di,dx           ;that point closer to selected?
                ja      lc2             ;a - no
                je      @f              ;e - need anchor check
                mov     dx,di           ;replace best distance
                jmp     lc1             ;replace the anchor also

; Compare and replace anchor if smaller

        @@:     cmp     si,bp           ;new point is closer to border start
                jae     lc2             ;ae - no, do not replace anchor
        lc1:    mov     bp,si           ;replace anchor
        lc2:    cmp     si,ds:[bordend] ;reached the border end?
                jnz     lc0             ;ne - not yet


; Compute euristic measure 


                pop     si              ;si - bordxy
                push    bp

                dec2    bp

                sub     bp,si
                mov     cx,ds:[clen1]
                cmp     bp,cx
                jb      @f
                sub     bp,cx
                add     si,cx
                mov     cx,ds:[clen2]
                cmp     bp,cx
                jb      @f
                sub     bp,cx
                add     si,cx
                mov     cx,ds:[clen3]

        @@:     dec2    bp
                jns     @f
                add     bp,cx
        @@:     call    getsqd0

                add     bp,4
                cmp     bp,cx
                jb      @f
                sub     bp,cx
        @@:     call    getsqd0

                pop     bp
                pop     di

                mov     ds,ds:[aux]

                mov     [di],bx         ;enrol it
                mov     measur[di],dx   ;along with the distance
                mov     anchor[di],bp   ;and the anchor

; Find the exact location of the current point in haloxy 

                mov     si,di
                inc2    di

; Move left the [bx] point: measure decreasing, anchors decreasing
; Use bubble method

                or      si,si
                jz      lc3             ;z - only the bubble in array

; At that place [si] - bubble position in haloxy
; bx = bubble x,y, dx = bubble measure, bp = bubble anchor

        @@:     cmp     measur-2[si],dx ;reached points that are bigger than bubble?
                jb      lc3             ;b - yes, stop bubbling
                ja      swap            ;a - no, move bubble left
                cmp     anchor-2[si],bp ;left point has a smaller anchor?
                jbe     lc3             ;b - yes, points to the left are bigger than bubble
        swap:   mov     ax,bx
                xchg    ax,[si-2]       ;move the bubble
                mov     [si],ax         ;left
                mov     ax,dx
                xchg    ax,measur-2[si] ;swap the
                mov     measur[si],ax   ;distance
                mov     ax,bp
                xchg    ax,anchor-2[si] ;swap the
                mov     anchor[si],ax   ;anchor
                dec2    si              ;points to bubble
                jnz     @b              ;check the left point if any
        lc3:    ds_cs

; Loop control

        lc4:    jmp     nxtpnt

; Compute the square of euclidian distance
; di = sqr(|ax-bx|)
;

        getsqd0:
                mov     ax,ds:[si+bp]
                call    getsqd
                shr     di,1
                add     dx,di
                ret

        getsqd: push    ax
                sub     al,bl           ;x difference
                imul    al              ;sqr(x difference)
                mov     di,ax           ;remember
                pop     ax
                mov     al,ah
                sub     al,bh           ;y difference
                imul    al              ;sqr(y difference)
                add     di,ax           ;di = sqr(distance)
                ret


; Unpack and get a bound 
;xxx

        getbound0:      mov     ds:[clenp],clen1
                        mov     ds:[bordxyp],bordxy
        getbound:       call    extvec          ;get a cycle and its vertical vectors
                        cmp     byte ptr[bp],0  ;last cycle?
                        jnz     getbound        ;nz - no
                        inc     bp              ;skip the 0
                        ret

; Unpack and get vector arrays 
; On entry: si - start of packed 2-vecs;
;           di - index into vvectx and vvecty arrays;
; On exit:  vvectx and vvecty are filled;
;           di - after the last data item in vvectx and vvecty;
;           si - after the last byte of 2-vectors;
;           cx = length of border;
;           vvc is increased by count of vertical vectors;
;
; bl = -1, 0, 1
; bh = -1, 0, 1
; Possible values of bx: (1,0),(-1,0),(0,-1),(0,1)
; the coding values are
;        00 - repeat the last vector twice
;        10 - repeat the last vector
;        01 - rotate and change dir
;        11 - rotate and keep dir
; The first vector is never encoded. It is defaulted to bx = 1.
;
                extvec: mov     cx,ds:[bordxyp] ;get to compute increase
                        mov     si,ds:[vectp]
                        mov     di,ds:[vvp]  ;where to write vertical vectors
                        mov     ax,[bp] ;get this cycle root
                        inc2    bp      ;- next cycle
                        mov     dx,ax   ;set root
                        push    di      ;save pointer
                        mov     bx,1    ;default start vector

                extnxt: push    ax      ;save root
                        lodsb           ;get next vector
                        ror     al,1    ;that vector is rotated?
                        jnc     @f      ;nc - no
                        xchg    bh,bl   ;rotate vector
                        shr     al,1    ;precise the direction
                        jnc     @f      ;z, keep the same direction
                        neg     bl      ;reverse the
                        neg     bh      ;direction
                @@:
                        call    storv
                        pop     ax      ;get root
                        cmp     dx,ax   ;closed?
                        jne     extnxt  ;

                        pop     ax      ;- start of vertical vectors for that cycle
                        sub     ax,di   ;cx = - count
                        sub     ds:[vvc],ax  ;increase vvc by vector count
                        mov     ds:[vvp],di  ;update the pointer also
                        sub     cx,ds:[bordxyp]
                        add     ds:[bordxyp],cx;update bordxy pointer
                                        ;cx = length of border * 2
                        mov     ds:[vectp],si
                        mov     bx,ds:[clenp]
                        mov     [bx],cx
                        add     ds:[clenp],2
                        ret

; bx  0, 1        0, 0
; bx  0,-1       -1,-1
; bx  1, 0        0,-1
; bx -1, 0       -1, 0

        storv:          mov     ax,dx   ;dx is the start of the current vector
                        or      bl,bl
                        jg      @skp
                        js      @f
                        or      bh,bh
                        jg      @dal
                        inc     al
                @@:     dec     ah
                @dal:   dec     al
                @skp:
                        push    bx
                        mov     bx,cx
                        cmp     ax,[bx-2]       ;already enrolled?
                        je      @f              ;e, yes
                        mov     [bx],ax         ;enrol square
                        inc2    cx              ;maintain length of border
                @@:     pop     bx

                        add     dh,bh
                        add     dl,bl
                        mov     ax,dx

; Check and store vertical vectors
                        or      bh,bh   ;vertical vector?
                        jz      @sv     ;z - yes
                        mov     vvectx[di],al   ;remember x of vertical vector
                                        ;ah = start vertex
                        js      @f      ;s - up vector
                        dec     ah      ;ah = end vertex of down vector
                @@:     mov     vvecty[di],ah ;
                        inc     di      ;
                @sv:    ret



; Generate the area 
; By a snake move
; locate a point within area.
; remember its value
; On entry: vvectx and vvecty are set;
;           vvc = count of vertical vectors
; On exit:  intar array is filled
;           cx = size of the array
;

; On entry: bx = point x,y

                ckin:   push    di
                        mov     di,vvecty
                        es_cs
                        mov     cx,ds:[vvc]
                        mov     al,bh
                        xor     dl,dl
                cin0:   repne   scasb   ;locate vectors crossing that line
                        jne     cin1    ;ne - no such vectors
                        cmp     vvectx-vvecty-1[di],bl
                        ja      @f
                        not     dl      ;keep in/out counter
                @@:     or      cx,cx
                        jnz     cin0
                cin1:   or      dl,dl   ;nz - within area
                        pop     di
                        ret


                filars: push    si
                        push    bp
                        mov     dh,1
                        clr     bx
                        mov     bp,143
                        mov     si,intar

                f1:     call    ckin
                        jz      @f
                        mov     es,ds:[dst]
                        cmp     byte ptr es:[bx],0
                        jne     @f
                        lodsb
                        mov     es:[bx],al
;                       mov     byte ptr es:[bx],249
                @@:     add     bl,dh
                        jnz     f1
                        inc     bh
                        neg     dh
                        jns     @f
                        dec     bl
                @@:     dec     bp
                        jnz     f1
                        pop     bp
                        pop     si
                        ret

;uuu
; Unpack an array of frequently repeated data 
; On entry: si - array of squeezed data;
;           di - where to store the unpacked data;
; On exit:  cx = size of the unpacked data array;
;           si - just after squeezed data;
;
; The format of the input array is as follows:
;  0     count of data items
;  2     Huffman block of squeezed counts
;  2+n   Huffman block of squeezed values
;

        unpack_rpt:     push    di      ;save raw data start

; Unsqueeze the counts
                        mof     di,counts
                        call    unpack_huf0 ;get the data count from stream

; Unsqueeze the values. They are differentially encoded if ch > 6

                        mof     di,values
                        call    unpack_huf;
                        cmp     ch,6
                        jbe     @f      ;be - no
                        mof     di,values
                        call    diff_to_val

; Unfold data
         @@:            pop     di      ;- raw data start
                        push    si      ;- next squeezed data
                        push    di      ;save start of raw data
                        mof     si,values
                        mov     dx,cx   ;count of data groups
                        xor     cx,cx   ;clear ch

        @@:             mov     cl,counts-values[si] ;get next
                        lodsb           ;get next value
                        rep     stosb   ;unfold the data
                        dec     dx      ;more data to unfold?
                        jnz     @b      ;nz - yes
                        pop     cx      ;= start of raw data
                        sub     cx,di
                        neg     cx      ;= count of raw data
                        pop     si      ;- next squeezed data
                        ret


; Unpack a differentially coded array 
; On entry: si - array of squeezed differences;
;           di - where to store the raw data;
;           cx = data count;
; On exit:  cx = raw data count;
;           si - after the sqeezed data;
;           di - after the raw data.
;
        unpack_dif:     push    di              ;save destination start
                        call    unpack_huf0     ;get the data count from stream
                        pop     di              ;- destination

; Recover data from differences
; On entry: di - the array of differences
;           cx = data count
; 0th data item is assumed 0 - thus the 1st diff is actually the 1st value.

        diff_to_val:    clr     al              ;0th data item
                        push    cx              ;save data count

        @@:             add     al,[di]
                        stosb
                        loop    @b
                        pop     cx              ;= data count
                        ret


; Decode a Huffman block 
; ddd
; On entry: si - a Huffman block;
;           di - where to store decoded data;
; On exit:  di - after the decoded data;
;           cx = count of data bytes.
;
        unpack_huf0:    lodsw           ;get data count from stream
                        mov     cx,ax   ;better use

; cx = count of squeezed data bytes;
        unpack_huf:     push    bp
                        push    cx      ;save data count
                        push    cx      ;twice
                        lodsb           ;get
                        clr     ah      ;Huffman table length in ax
                        mov     cx,ax   ;= table length
                        mof     bp,htree;once forever

; Extract the Huffman tree (convert bits to bytes)

                        push    di      ;save data destination
                        push    cx      ;save table length
                        shl     cx,1    ;
                        dec     cx      ;cx = 2*length-1
                        mov     di,bp   ;- htree start
                        mov     dl,80h  ;initialize a bit counter

        ext:            clr     al      ;assume next bit is 0
                        call    getbit  ;is it 0?
                        jnc     @f      ;nc - yes
                        not     al      ;0ff for 1 bit
        @@:             stosb           ;store as a byte
                        loop    ext     ;until done
                        or      dl,dl   ;just increased?
                        js      @f      ;s - yes
                        inc     si      ;- the table start

        @@:             pop     cx      ;= table length
                        pop     di      ;- data destination
                        pop     ax      ;= data count
                        push    si      ;- table start
                        add     si,cx   ;skip the table
                        mov     cx,ax   ;cx = data count
                        mov     dl,80h  ;initialize a bit counter

; Decode the data. Find a code word, get and store the corresponding value.

        hdebyt:         mov     bx,bp   ;bx - tree start
                        pop     ax      ;- table start
                        push    ax      ;save back

        gb:             call    getbit  ;get next bit from stream
                        jnc     ckl     ;0 - move along left branch

; Skip left subtree
                        clr     dh      ;when = 0 again left subtree is skipped
        @@:             inc     dh      ;move along left branch
        sl:             inc     bx      ;- next node
                        sar     byte ptr[bx],1
                        jnc     @b      ;nc - nonleaf
                        inc     ax      ;- next in table
                        dec     dh      ;move along right branch
                        jnz     sl      ;nz - more nodes to skip

        ckl:            inc     bx      ;- next node
                        sar     byte ptr [bx],1 ;on leaf (end of decoding)?
                        jnc     gb      ;nc - no

                        xchg    si,ax
                        movsb           ;store next data byte value
                        mov     si,ax   ;restore pointer to Huffman block
                        loop    hdebyt  ;loop for the next byte

                        pop     ax      ;clean up the stack
                        or      dl,dl   ;just increased?
                        js      @f      ;s - yes
                        inc     si      ;- after the block
        @@:             pop     cx      ;= data count
                        pop     bp
                        ret


; Extract next bit into C flag

        getbit:         shr     byte ptr [si],1  ;
                        pushf           ;save C
                        ror     dl,1    ;need to move to the next byte?
                        jnc     @f      ;ne no
                        inc     si      ;pass on the next byte
        @@:             popf            ;get data bit in C flag
                        ret


;lll

; LOWER LETTERS 
;
; Lower letters are compressed in one of the worst ways.
;
;
                lolet   db      des_t-des_beg
                        db      des_o-des_beg
                        db      des_o-des_beg
                        db      des_emp-des_beg
                        db      des_c-des_beg
                        db      des_o-des_beg
                        db      des_o-des_beg
                        db      des_l-des_beg
                        db      des_emp-des_beg
                        db      des_f-des_beg
                        db      des_o-des_beg
                        db      des_r-des_beg
                        db      des_emp-des_beg
                        db      des_s-des_beg
                        db      des_c-des_beg
                        db      des_h-des_beg
                        db      des_o-des_beg
                        db      des_o-des_beg
                        db      des_l-des_beg

                cnt     db      19
                xpos    dw      20
                horz    db      1
                gramem  dw      0a000h

                low_letters:
                        mof     si,lolet
                        mov     di,153*320+8

                nxtlet:
                        push    si              ;save pointer to letters
                        push    di              ;save pointer to graphics
                        es_cs                   ;normal
                        mof     di,letwar
                        push    di              ;save to reuse
                        push    di              ;twice
                        mov     cx,256*36       ;size of the letter area
                        clr     al
                        rep     stosb           ;clear the work area
                        pop     bx              ;bx - letwar for all
                        lodsb                   ;get relative pointer
                        clr     ah
                        mov     si,ax           ;- relative letter decriptor
                        add     si,offset des_beg ;- absolute letter descriptor
                        call    assemlet        ;assemble the proper letter

; Copy the letter work area to the graphic memory

                        mov     es,gramem
                        pop     si              ;si - letwar
                        pop     di              ;- graphic memory
                        mov     dl,36           ;number of lines
                @@:     mov     cx,16           ;line width
                        rep     movsb           ;copy next line
                        add     di,320-16
                        add     si,256-16
                        dec     dl              ;all copied?
                        jnz     @b              ;nz - not yet
                        pop     si
                        inc     si              ;- next
                        sub     di,36*320-16    ;- next root
                        dec     cnt
                        jnz     nxtlet
                        ret


; Dispatch table to executing routines

                execs   dw      upvault
                        dw      dnvault
                        dw      upvault1
                        dw      dnvault1
                        dw      fill_let
                        dw      lupcor
                        dw      oglare
                        dw      scglar
                        dw      endofl

; Opcodes for dispatching

uvault = 0      +1
dvault = 8      +1
uvalt1 = 16     +1
dvalt1 = 24     +1
fillet = 32     +1
glarlu = 40     +1
glare1 = 48     +1
glare2 = 56     +1
endlet = 64     +1



; On entry: si - letter descriptor

                assemlet:
                nxtopc: es_cs
                        mov     di,bx   ;better use
                        cld
                        lodsb           ;get opcode
                        shr     al,1    ;a vector?
                        jnc     vector  ;nc - yes
                        mov     byte ptr ds:[vect],0
                        shr     al,1    ;parameterless command?
                        jc      @f      ;c, no
                        clr     ah
                        mov     di,ax   ;
                        push    si
                        call    word ptr execs[di];
                        pop     si
                        jmp     nxtopc
                endofl: pop     ax      ;remove return address
                        pop     si      ;it was pushed
                        ret             ;to previous caller

; Set point command

                @@:     mov     ah,al   ;this is the y coordinate
                        lodsb           ;get x and color
                        mov     dh,al
                        .386
                        sar     dh,4    ;the color
                        .8086
                        jz      gotoxy  ;0th color is gotoxy
                        and     al,0fh  ;x coordinate
                        push    bx
                        mov     bx,ax   ;bx - singular point
                        mov     letwar[bx],dh ;set point color
                        pop     bx
                        jmp     nxtopc
                gotoxy: mof     bx,letwar
                        add     bx,ax
                        mov     byte ptr ds:[vect],0 ;previous wasn't vector?
                        jmp     nxtopc

                vector: mov     dl,-1
                        cmp     al,70   ;a move? (values = 35+x)
                        jbe     @f      ;be, no
                        sub     al,70   ;compute move length
                        mov     es,ds:[dst] ;store outside
                        clr     dl
                @@:     mov     cl,al
                        mov     al,251
                        sar     byte ptr ds:[vect],1 ;previous was vector?
                        jns     @f      ;ne - no
                        inc     al      ;corners are always = 252
                @@:     neg     horz    ;rotate 90 grads
                        jns     vert    ;ns - vertical vector
; Horizontal vector
                        shr     cl,1    ;get sign of rotation
                        jc      c_rg    ;C - go right
                c_lf:   std
                c_rg:   stosb           ;corner
                        sar     byte ptr ds:[vect],1 ;previous was vector?
                        jns     @f      ;ne - no
                        dec     al      ;usual
                @@:     rep     stosb
                        push    di
                        stosb
                        pop     di
                        jmp     nxtop

; Vertical vector

                vert:   shr     cl,1    ;get sign of rotation
                        jnc     c_up    ;NC - go up
                c_dn:   mov     bx,255
                        jmp     @f
                c_up:   mov     bx,-257
                @@:     stosb
                        sar     byte ptr ds:[vect],1 ;previous was vector?
                        jns     @f      ;ne - no
                        dec     al
                @@:     add     di,bx
                        stosb
                        loop    @b
                        add     di,bx
                        push    di
                        stosb
                        pop     di
                nxtop:  mov     bx,di
                        mov     byte ptr ds:[vect],dl
                        jmp     nxtopc



; Vaulted letters 
;



; 251 vault

        vault0  db      251
                dw      0000011111000000b
                dw      0001100000110000b
                dw      0010000000001000b
                dw      0100000100000100b
                dw      0100000000000100b
                dw      1000000000000010b

; 253 vault

        vault1  db      253
                dw      0000100000100000b
                dw      0010010001001000b
                dw      0101000000010100b
                dw      0010001010001000b
                dw      1000000100000010b
                dw      0100000000000000b
        vaultend = $


                upvault:mov     bp,1111111111111110b
                        jmp     uvl

                dnvault1:mov    bp,1111111100000000b
                        jmp     @f
                dnvault:mov     bp,1111111111111110b
                @@:     mov     di,0ff00h       ;constant for up move
                        add     bx,5*256        ;- the bottom left
                        jmp     outvault

                upvault1:mov    bp,0000000111111110b
                uvl:    mov     di,00100h       ;constant for down move


; On entry: bx = vault root
; On exit:  bx = vault rightmost point

                outvault:
                        mof     si,vault0
                nxtvalt:push    bx              ;vault root
                        mov     dl,6            ;vault heigth
                        lodsb
                        mov     dh,al           ;get vault color
                nxtvl:  lodsw
                        push    bx              ;save current y
                        mov     cx,bp           ;which points to take
                nvv:    shl     cx,1            ;display value?
                        jnc     @f              ;nc - no
                        or      ah,ah           ;MSB set?
                        jns     @f
                        mov     [bx],dh         ;set color
                @@:     inc     bx
                        sal     ax,1            ;keep bits shifting
                        or      cx,cx           ;more bits to output
                        jnz     nvv
                        pop     bx              ;get previous y position
                        add     bx,di           ;up or down move
                        dec     dl              ;one layer more
                        jnz     nxtvl           ;nz - more layers
                        mov     ds:[rootsav],bx ;save it
                        pop     bx              ;initial root
                        cmp     si,vaultend
                        jb      nxtvalt
                        mov     bx,ds:[rootsav] ;get it
                        add     bl,14           ;- the vault rightmost point
                        mov     horz,-1         ;allways set to vertical
                        ret

; Draw a blick on left upper corner , on entry bx -> root

                lupcor: mov     word ptr[bx],0faf9h  ;
                        dec     word ptr[bx+256]     ;
                        dec     word ptr[bx+512]     ;
                        ret

                oglare: mof     ax,des_gl1
                        jmp     @f

                scglar: mof     ax,des_gl2
                @@:     push    si
                        push    bx
                        mov     si,ax
                        call    assemlet
                        pop     bx
                        pop     si
                        ret



; Letter filling 
; On entry: di -> letter root
; The intensity array is (taken negative)
; 0123456789012345678901234567890123456
; 0012345677777654321000000000000001234
;
                filar   db -1,-2,-3,-4,-5,-6,-7,-7,-7,-7,-7,-6,-5,-4,-3,-2,-1

                fill_let:
                        xor     al,al
                        mof     di,letwar+512
; Fill upper part
                        mov     dx,1101h        ;upper part is 17 lines
                        call    fill_let1
; Fill lower part
                        add     di,12*256
                        mov     dx,400h         ;lower part is 4 lines
                                                ;fall down
                fill_let1:
                        mov     bx,offset filar
                nxtlin: mov     ah,[bx]         ;get line color in ah
                        mov     cl,15           ;actually cx = 15
                        push    di              ;save pointer to start of line

                locno0: repe    scasb           ;look for a nonzero
                        jcxz    eofl            ;cxz - reached the right border
                loc0:   repne   scasb           ;look for a zero (outside letter)
                        jcxz    eofl            ;cxz - reached the end
                        push    di              ;check
                        push    cx              ;if any
                        repe    scasb           ;points
                        pop     cx              ;on the
                        pop     di              ;right
                        je      eofl            ;e - no
                        or      dl,dl           ;doing upper?
                        jnz     @f              ;nz - yes, skip position
                        dec     di              ;in lower overwrite the 0
                        inc     cx

                @@:     mov     [di],ah
                        inc     di
                        cmp     [di],al         ;next is zero?
                        loope   @b              ;replace it if yes
                        jcxz    eofl            ;skip if finished BTW

; Crossed the border
                        cmp     [di+1],al       ;next is zero?
                        jne     loc0            ;ne - no, locate a zero
                        inc     di
                        loop    locno0

                eofl:   inc     bx              ;- next in filar
                        pop     di
                        add     di,256
                        dec     dh
                        jnz     nxtlin
                        ret


; Letters descriptions 

                des_beg = $
; H description
                des_h   db      4*5+2
                        db      4*15+2
                        db      4*1+2
                        db      4*15
                        db      4*5+2
                        db      4*34+2
                        db      4*5
                        db      4*15
                        db      4*1
                        db      4*15+2
                        db      4*5
                        db      4*34
                        db      glarlu  ;left upper corner glare
                        db      4*(35+7)+2   ;move x
                        db      glarlu  ;left upper corner glare
                        db      4*16+3   ;
                        db      10100111b
                        db      4*16+3   ;
                        db      10011000b
                        db      4*15+3   ;
                        db      10101000b
                        db      4*14+3   ;
                        db      10101000b
                        db      fillet  ;fill the letter
                        db      endlet  ;

; F description
                des_f   db      54
                        db      10
                        db      28
                        db      48+2
                        db      16+2
                        db      10
                        db      16
                        db      62
                        db      20
                        db      136
                        db      glarlu  ;left upper corner glare
                        db      fillet  ;fill the letter
                        db      endlet

; T description
                des_t   db      4*13+2
                        db      4*2+2
                        db      4*3
                        db      4*31+2
                        db      4*5
                        db      4*31
                        db      4*3
                        db      4*2
                        db      glarlu  ;left upper corner glare
                        db      fillet  ;fill the letter
                        db      endlet

; L description
                des_l   db      20+2
                        db      124+2
                        db      28+2
                        db      10
                        db      52
                        db      136
                        db      glarlu  ;left upper corner glare
                        db      fillet  ;fill the letter
                        db      endlet

; O description
               des_o    db      uvault  ;up vault
                        db      4*23+2  ;draw right external
                        db      4*(35+13);move left
                        db      dvault  ;down vault
                        db      4*(35+24);move up
                        db      4*(35+5) ;move left
                        db      4*26+2  ;right internal
                        db      4*(35+1);on the left internal
                        db      4*26
                        db      4*(35+5)+2
                        db      4*6+3
                        db      0
                        db      4*23+2
                        db      fillet  ;fill the letter
                        db      glare1
                        db      endlet

;C description
                des_c   db      uvault  ;up vault
                        db      4*2+2
                        db      4*5
                        db      4*4
                        db      4*(35+1)
                        db      4*26+2
                        db      4*(35+1)+2
                        db      4*4
                        db      4*5+2
                        db      4*3+2
                        db      4*(35+13)
                        db      dvault  ;down vault
                        db      4*6+3   ;goto 0,6
                        db      0
                        db      4*23+2
                        db      fillet  ;fill the letter
                        db      4*26+3  ;goto 8,26
                        db      8
                        db      glarlu  ;left upper corner glare
                        db      glare2
                        db      4*31+3   ;
                        db      10101000b
                        db      endlet

; S description

                des_s   db      uvault  ;up vault
                        db      4*2+2
                        db      4*5
                        db      4*4
                        db      4*(35+1)
                        db      4*11+2
                        db      4*(35+5)
                        db      uvalt1
                        db      4*7+2
                        db      4*(35+13)
                        db      dvault
                        db      4*(35+22)
                        db      4*(35+13)
                        db      4*7+2
                        db      dvalt1
                        db      4*(35+6)+2
                        db      4*(35+5)
                        db      4*10+2
                        db      4*(35+1)
                        db      4*5
                        db      4*5
                        db      4*4+2
                        db      4*25+3   ;goto 0,6
                        db      0
                        db      glarlu
                        db      fillet
                        db      glare2
                        db      4*14+3   ;
                        db      11010010b
                        db      4*21+3   ;
                        db      11011101b
                        db      4*30+3   ;
                        db      11011101b
                        db      4*31+3   ;
                        db      10101000b
                        db      endlet
;ddd
; R description

                des_r   db      uvalt1
                        db      4*8+2
                        db      4*(35+1)
                        db      4*(35+4)+2
                        db      4*(35+1)+2
                        db      4*14+2
                        db      4*5
                        db      4*15
                        db      4*1
                        db      4*15+2
                        db      4*5
                        db      4*34
                        db      4*5+2
                        db      4*(35+3)+2
                        db      4*(35+1)+2
                        db      4*11+2
                        db      4*1
                        db      4*12
                        db      4*0+3   ;goto 0,0
                        db      0
                        db      glarlu
                        db      4*16+3   ;
                        db      10100110b
                        db      4*16+3   ;
                        db      10010111b
                        db      4*15+3   ;
                        db      10011000b
                        db      4*14+3   ;
                        db      10101000b
                        db      4*13+3   ;
                        db      10101000b
                        db      4*15+3   ;
                        db      11010111b

; The concave part
                        db      4*16+3
                        db      11011110b
                        db      4*16+3
                        db      10111101b
                        db      4*17+3
                        db      10111100b
                        db      4*17+3
                        db      11011101b
                        db      4*18+3
                        db      10111100b
                        db      4*18+3
                        db      11011101b
                        db      4*19+3
                        db      11011100b
                        db      4*19+3
                        db      10111101b
                        db      4*19+3
                        db      11011110b
                        db      4*20+3
                        db      11011101b

                        db      4*3+3
                        db      11000110b
                        db      4*20+3
                        db      11010111b
                        db      4*19+3
                        db      11011000b
                        db      fillet  ;fill the letter
                        db      4*16+3   ;
                        db      11011000b
                        db      4*16+3   ;
                        db      11011001b
                        db      endlet

                des_gl1 db      4*29+3
                        db      10101000b
                des_gl2 db      4*31+3
                        db      10100110b
                        db      4*32+3
                        db      10010111b
                        db      4*31+3
                        db      10011000b
                        db      4*30+3
                        db      10101000b
                        db      4*5+3
                        db      11010010b

                        db      4*6+3
                        db      10100000b
                        db      4*5+3
                        db      10100000b
                        db      4*4+3
                        db      10100001b
                        db      4*3+3
                        db      10100001b
                        db      4*2+3
                        db      10010010b
                        db      4*1+3
                        db      10100011b
                        db      4*1+3
                        db      10100100b
                des_emp db      endlet

                sqzdat label byte
                entry_end:
;               include basedata.inc
;               include trandata.inc
;               include halodata.inc

_TEXT ends
                        end     entry_start

; Unpack and get a cycle and its vertical vectors 
; On entry: si - start of packed 2-vecs;
;           di - index into vvectx and vvecty arrays;
; On exit:  vvectx and vvecty are filled;
;           di - after the last data item in vvectx and vvecty;
;           si - after the last byte of 2-vectors;
;           vvc is increased by cx;
;
; bl = -1, 0, 1
; bh = -1, 0, 1
; Possible values of bx: (1,0),(-1,0),(0,-1),(0,1)
; the coding values are
;        00 - repeat the last vector twice
;        10 - repeat the last vector
;        01 - rotate and change dir
;        11 - rotate and keep dir
; The first vector is never encoded. It is defaulted to bx = 1.
;
                extvec: push    ds:[bordxyp] ;save to compute increase
                        mov     di,ds:[vecpt];start from the beginning
                        lodsw           ;get count of 2-vectors in the path
                        mov     cx,ax   ;
                        lodsw           ;get root
                        mov     bp,ax   ;set root
                        mov     dx,201h ;preset count of vectors in a byte
                        push    di
                        mov     bx,1    ;default start vector

                extnxt: dec     dl      ;more in that byte?
                        jnz     @f      ;nz - yes
                        lodsb           ;get next 4 2-vectors
                        mov     dl,4    ;vectors in a byte
                @@:     test    al,3    ;iteration?
                        jnz     @f      ;nz - no
                        or      al,dh   ;set previous vector change in bits 0,1
                        call    finc    ;process the last change once more
                        .386
                        rol     al,2    ;set previous vector change in bits 0,1
                        .8086
                @@:     call    finc
                        loop    extnxt

                        pop     cx
                        sub     cx,di   ;cx = - count
                        sub     ds:[vvc],cx  ;increase vvc by vector count
                        mov     ds:[vecpt],di
                        pop     cx      ;= initial bordxyp
                        sub     cx,ds:[bordxyp]
                        neg     cx      ;cx = length of borderxy * 2
                        mov     bx,ds:[clenp]
                        mov     [bx],cx
                        add     ds:[clenp],2
                        ret

                finc:   mov     dh,al   ;remember
                        and     dh,3    ;the last vector
                        ror     al,1    ;that vector is rotated?
                        jnc     @f      ;nc - no
                        xchg    bh,bl   ;rotate vector
                        test    al,1    ;precise the direction
                        jz      @f      ;z, keep the same direction
                        neg     bl      ;reverse
                        neg     bh      ;direction
                @@:     ror     al,1    ;keep bits shifting


                                        ;fix the last vector

; bx  0, 1        0, 0
; bx  0,-1       -1,-1
; bx  1, 0        0,-1
; bx -1, 0       -1, 0

                        push    ax
                        mov     ax,bp

                        or      bl,bl
                        jg      @skp
                        js      @f
                        or      bh,bh
                        jg      @del
                        inc     al
                @@:     dec     ah
                @del:   dec     al
                @skp:   mov     es,ds:[dst]

                        xchg    si,ax
                        push    bx
                        mov     bx,ds:[bordxyp]
                        cmp     si,[bx-2]       ;already enrolled?
                        je      @f              ;e, yes
                        mov     [bx],si         ;enrol square
                        add     word ptr ds:[bordxyp],2
                @@:     pop     bx
                        mov     si,ax

                        mov     ax,bp
                        add     ah,bh
                        add     al,bl
                        mov     bp,ax   ;bp = x,y of the vector end
                        or      bh,bh   ;vertical vector?
                        jz      @fv     ;z - no
                        mov     vvectx[di],al   ;remember x of vertical vector
                                        ;ah = start vertex
                        js      @f      ;s - up vector
                        dec     ah      ;ah = end vertex of down vector
                @@:     mov     vvecty[di],ah ;

                        inc     di      ;
                @fv:    pop     ax
                        ret
