;
;   Stefan's Entry for Hugi Size Coding Competition #7 - Image Compression
;
;   Second Version: LZ decoder. Gives 9664 bytes with sample image.
;   Expects AH=0,BX=0 on startup.
;
;   Have fun,
;     Stefan <Streu@gmx.de>
;


                MODEL   TINY
                CODESEG
                ORG     100h
		P386

Start:          mov     al,13h
                int     10h

                mov     si,offset Headers
                cld
;=== Iterate through headers ===
HeaderLoop:	lodsw			; size
		dec	ax
		jz	Ende
		xchg	ax,dx
		lodsw			; offset
		push	si
		xchg	si,ax
;--- decode a DX bytes chunk from offset SI ---
		mov	di,offset Buffer
DecodeLoop:	lodsb
		mov	ah,al
		cmp	al,nColors	; 0..nColors-1 = take verbatim
		jc	SingleByte	; nColors+1 .. 255 = high byte of
		lodsb			;   a negative number (offset)
		jnz	NoTriplet	; nColors = three identical pixels
		stosb
		stosb
		dec	dx
		dec	dx
		jmp	SingleByte
NoTriplet:	xchg	ax,bp		; BP = offset
		lodsb			; AL = length
		push	si
		lea	si,[di+bp]	; SI -> backreference
		xchg	ax,cx
		mov	ch,0		; CX = length
		sub	dx,cx		; -> done CX bytes (sets ZF if done)
		rep movsb
		lodsb
		pop	si
SingleByte:	stosb
		dec	dx
Done:		jnz	DecodeLoop
		pop	si
;=== Display Buffer ===
		lodsw			; offset
		xchg	di,ax
		lodsb			; height
		xchg	dx,ax
		lodsw			; width
		xchg	cx,ax
		push	si
		push	0A000h
		pop	es
		mov	si,offset Buffer
;--- copy ---
CopyLoop:	push	di cx
		rep movsb
		pop	cx di
		add	di,320
		dec	dl
		jnz	CopyLoop

		push	ds
		pop	es
		pop	si
		jmp	HeaderLoop

;--- now load palette ---
Ende:           mov	dx,3C8h		; ax = 0 here
		outsb
		inc	dx
		mov	cx,nColors*3	; bx is still 0 from program start
PalLoop1:	mov	al,2
PalLoop:	bt	[si],bx		; get bit
		inc	bx
		adc	al,al		; put bit
		jns	PalLoop
		out	dx,al
		loop	PalLoop1

		int     16h		; ah still zero
                mov     ax,3		; this instruction could be omitted
					; if the `single keypress' is
					; guaranteed to be [Alt-Num3]  ;-)
                int     10h
                ret

;=== Headers ===
; each header is
;   dw size+1, code_offset
;   dw offset_in_vram
;   db width
;   dw height
; or a single 1 to mark end of headers, followed by encoded palette
; (encoded as 6 bits per entry)
Headers:        INCLUDE entryh.asm

;=== LZ data ===
; 0..ncolors-1  encode themselves
; X,Y,Z         encodes a backreference of Z+1 bytes, lies backwards
;               256*(X-ncolors)+Y bytes
                INCLUDE entryd.asm

Buffer:

                END     Start
