{

Hugi size coding competition #7
Entry by GreenGhost

Submission 5; size: 7884 bytes

}

Program Hugi7;

{$D-,L-,R-,S-,A+,B-,E-,F-,G+,I+,N+,O-,P-,Q-,T+,V+,X+,Y-}
{$M 65520,0,260000}

Uses
  CodeMake;

Type
  TColor=Record
    Case Boolean of
      False:(R,G,B:Byte);
      True :(All:Array[0..2] of Char);
  End;
  TPalette=Array[Byte] of TColor;

Type
  TFlags=Array[Byte] of Boolean;
  TTrans=Array[Byte] of Byte;

  PImage=^TImage;
  TImage=Object
    Palette:TPalette;
    Picture:Array[0..63999] of Byte;
    PalSize:Word;
    PicStart,PicSize:Word;
    Procedure Load(Const FileName:String);
    Procedure SetSize;
    Procedure MakePalette(Var F:TCode);
    Procedure MakePicture(Var F:TCode; Var Commands:Word);
    {Procedure Unpack(Var F:TCode; Commands:Word);}
  End;

Procedure TImage.Load(Const FileName:String);
Var
  F:File;
Begin
  Assign(F,FileName);
  Reset(F,1);
  BlockRead(F,Palette,SizeOf(Palette));
  BlockRead(F,Picture,SizeOf(Picture));
  Close(F);
End;

Procedure TImage.SetSize;
Begin
  PicStart:=0;
  While Picture[PicStart]=0 do Inc(PicStart);
  PicSize:=64000;
  While Picture[Pred(PicSize)]=0 do Dec(PicSize);
End;

Procedure TImage.MakePalette(Var F:TCode);
Var
  Used:TFlags;
  Trans:TTrans;
  NewPal:TPalette;
  Colors:Word;

  Procedure MatchPalette;
  Var
    Color,Ptr:Word;
  Begin
    FillChar(Used,256,False);
    For Ptr:=0 to 63999 do Used[Picture[Ptr]]:=True;
    Trans[0]:=0;
    NewPal[0]:=Palette[0];
    PalSize:=1;
    For Color:=1 to 255 do If Used[Color] Then Begin
      Ptr:=0;
      While (Ptr<Color) and (Palette[Ptr].All<>Palette[Color].All) do Inc(Ptr);
      If Ptr=Color Then Begin
        Trans[Color]:=PalSize;
        NewPal[PalSize]:=Palette[Color];
        Inc(PalSize);
      End Else Begin
        Trans[Color]:=Ptr;
      End;
    End;
    Palette:=NewPal;
    For Ptr:=0 to 63999 do Picture[Ptr]:=Trans[Picture[Ptr]];
  End;

  Procedure AddColor(Color:Word);
  Begin
    Used[Color]:=True;
    NewPal[Colors]:=Palette[Color];
    Trans[Color]:=Colors;
    Inc(Colors);
  End;

  Procedure BitPack;

    Function Range(Value,Min,Max:Integer):Boolean;
    Begin
      Range:=(Value>=Min) and (Value<=Max);
    End;

    Function BitSize(D1,D2,D3:Integer):Byte;
    Begin
      If Range(D1,0,1) and Range(D2,0,1) and Range(D3,0,1) Then Begin
        BitSize:=1;
      End Else Begin
        If Range(D1,-1,2) and Range(D2,-1,2) and Range(D3,-1,2) Then Begin
          BitSize:=2;
        End Else Begin
          If Range(D1,-4,3) and Range(D2,-4,3) and Range(D3,-4,3) Then Begin
            BitSize:=3;
          End Else Begin
            If Range(D1,-8,7) and Range(D2,-8,7) and Range(D3,-8,7) Then Begin
              BitSize:=4;
            End Else Begin
              BitSize:=6;
            End;
          End;
        End;
      End;
    End;

  Var
    Red,Green,Blue,D1,D2,D3:Integer;
    Size,BestSize:Byte;
    Cnt,Color:Word;
    BestColor:Byte;
  Begin
    With Palette[1] do Begin
      Red:=R;
      Green:=G;
      Blue:=B;
    End;
    AddColor(1);
    F.AddData(15,4);
    F.AddData(Red,6);
    F.AddData(Green,6);
    F.AddData(Blue,6);
    For Cnt:=1 to PalSize-2 do Begin
      BestSize:=8;
      For Color:=0 to PalSize-1 do If not Used[Color] Then Begin
        With Palette[Color] do Size:=BitSize(R-Red,G-Green,B-Blue);
        If Size<BestSize Then Begin
          BestSize:=Size;
          BestColor:=Color;
        End;
      End;
      AddColor(BestColor);
      With Palette[BestColor] do Begin
        D1:=R-Red;
        D2:=G-Green;
        D3:=B-Blue;
        Red:=R;
        Green:=G;
        Blue:=B;
      End;
      Case BestSize of
        1:Begin
          F.AddData(6,3);
          F.AddData(D1,1);
          F.AddData(D2,1);
          F.AddData(D3,1);
        End;
        2:Begin
          F.AddData(0,1);
          F.AddData(D1+1,2);
          F.AddData(D2+1,2);
          F.AddData(D3+1,2);
        End;
        3:Begin
          F.AddData(2,2);
          F.AddData(D1+4,3);
          F.AddData(D2+4,3);
          F.AddData(D3+4,3);
        End;
        4:Begin
          F.AddData(14,4);
          F.AddData(D1+9,4);
          F.AddData(D2+9,4);
          F.AddData(D3+9,4);
        End;
      Else
        F.AddData(15,4);
        F.AddData(Red,6);
        F.AddData(Green,6);
        F.AddData(Blue,6);
      End;
    End;
{
  -1..2   126    0     rr gg bb
  -4..3    50    10    rrr ggg bbb
  0..1     12    110   r g b
  -9..6    12    1110  rrrr gggg bbbb
  0..63     9    1111  rrrrrr gggggg bbbbbb
}
    F.AddCodeAbs($BF,'bss',0);      { mov di,bss         ;data pointer  }
    F.AddCodeWord($BD,210);         { mov bp,210         ;color counter }
    F.AddLabel('nextpal');          { nextpal:                          }
    F.AddCall('testbit');           {   call testbit                    }
    F.AddCodeWord($BB,$0102);       {   mov bx,$0102     ;2 bits, -1..2 }
    F.AddJump($74,'change');        {   jz change                       }
    F.AddCall('testbit');           {   call testbit                    }
    F.AddCodeWord($BB,$0403);       {   mov bx,$0403     ;3 bits, -4..3 }
    F.AddJump($74,'change');        {   jz change                       }
    F.AddCall('testbit');           {   call testbit                    }
    F.AddCodeWord($BB,$0001);       {   mov,bx,$0001     ;1 bit, 0..1   }
    F.AddJump($74,'change');        {   jz change                       }
    F.AddCall('testbit');           {   call testbit                    }
    F.AddCodeWord($BB,$0904);       {   mov bx,$0904     ;4 bits, -9..6 }
    F.AddJump($74,'change');        {   jz change                       }
    F.AddCode1($57);                {   push di                         }
    F.AddCode2($B1,3);              {   mov cl,3                        }
    F.AddLabel('next6');            {   next6:                          }
    F.AddCode2($B0,6);              {     mov al,6       ;get color     }
    F.AddCall('getbits');           {     call getbits                  }
    F.AddCode1($AA);                {     stosb          ;store         }
    F.AddJump($E2,'next6');         {   loop next6                      }
    F.AddCode1($5F);                {   pop di                          }
    F.AddJump($EB,'storebits');     {   jmp storebits                   }
    F.AddLabel('change');           {   change:                         }
    F.AddCode1($57);                {     push di                       }
    F.AddCode2($B1,3);              {     mov cl,3                      }
    F.AddLabel('nextchange');       {     nextchange:                   }
    F.AddCode2($88,$D8);            {       mov al,bl    ;get red add   }
    F.AddCall('getbits');           {       call getbits                }
    F.AddCode2($28,$F8);            {       sub al,bh    ;adjust range  }
    F.AddCode2($00,$05);            {       add [di],al  ;change red    }
    F.AddCode1($47);                {       inc di                      }
    F.AddJump($E2,'nextchange');    {     loop nextchange               }
    F.AddCode1($5F);                {     pop di                        }
    F.AddLabel('storebits');        {   storebits:                      }
    F.AddCode1($52);                {   push dx                         }
    F.AddCodeWord($BA,$03C9);       {   mov dx,$03C9     ;color reg     }
    F.AddCode2($8A,$05);            {   mov al,[di]      ;get red       }
    F.AddCode1($EE);                {   out dx,al        ;output        }
    F.AddCode3($8A,$45,1);          {   mov al,[di+1]    ;get green     }
    F.AddCode1($EE);                {   out dx,al        ;output        }
    F.AddCode3($8A,$45,2);          {   mov al,[di+2]    ;get blue      }
    F.AddCode1($EE);                {   out dx,al        ;output        }
    F.AddCode1($5A);                {   pop dx                          }
    F.AddCode1($4D);                {   dec bp                          }
    F.AddJump($75,'nextpal');       { jne nextpal        ;next color    }
  End;

Var
  Ofs:Word;
Begin
  F.AddCode2($B0,19);         { mov al,19     ;graphmode 13h  }
  F.AddCode2($CD,16);         { int 16                        }
  F.AddCodeAbs($BE,'data',0); { mov si,data   ;data pointer   }
  F.AddCode1($FC);            { cld                           }
  F.AddCodeWord($BA,$03C8);   { mov dx,$03C8  ;palette reg    }
  F.AddCode2($B0,1);          { mov al,1      ;color 1        }
  F.AddCode1($EE);            { out dx,al                     }
  F.AddCode2($30,$D2);        { xor dl,dl     ;clear bitflags }
  MatchPalette;
  Colors:=0;
  FillChar(Used,256,False);
  AddColor(0);
  BitPack;
  Palette:=NewPal;
  For Ofs:=0 to 63999 do Picture[Ofs]:=Trans[Picture[Ofs]];
End;

Const
  MinCopy  =3;
  MinBlock =2;
  MinCAdd  =4;
  MinBwCopy=4;

  CopyBits  =3; CopyRange  =7;
  BlockBits =4; BlockRange =15;
  CAddBits  =3; CAddRange  =7;
  BwCopyBits=3; BwCopyRange=7;

  CAdderBits=3;
  CAdderRange=[1..6,254..255];
  CAdder=2;

  CopyLong=MinCopy+CopyRange+1;
  BwCopyLong=MinBwCopy+BwCopyRange+1;

Procedure TImage.MakePicture(Var F:TCode; Var Commands:Word);
Var
  Screen:Array[0..63999] of Byte Absolute $A000:0;

  Function CountBits(Value:Word):Byte;
  Var
    Cnt:Byte;
  Begin
    Cnt:=0;
    While Value>0 do Begin
      Value:=Value shr 1;
      Inc(Cnt);
    End;
    CountBits:=Cnt;
  End;

  Function OfsBits(Ofs:Word):Byte;
  Var
    Bits:Byte;
  Begin
    Bits:=0;
    While Ofs>(2 shl Bits)-2 do Inc(Bits);
    OfsBits:=Bits;
  End;

  Procedure PackStream(Var Commands:Word);
  Var
    Pixel:Word;

    Procedure CountBlock(Var Color:Byte; Var Cnt:Word);
    Begin
      Color:=Picture[Pixel];
      Cnt:=1;
      While (Pixel+Cnt<PicSize) and (Picture[Pixel+Cnt]=Color) do Inc(Cnt);
    End;

    Procedure CountAddCopy(Var Add:Byte; Var Ofs0,Len0,Ofs,Len:Word);
    Var
      Pic:Pointer;
      Pix:Word;
      Ptr1,Cnt:Word;
      Color,Adder:Byte;
    Begin
      Pic:=@Picture;
      Pix:=Pixel;
      Color:=Picture[Pixel];
      Len:=0;
      Len0:=0;
      Ptr1:=0;
      While Ptr1+Len<Pixel do Begin
        Adder:=Byte(Color-Picture[Ptr1]);
{
        Cnt:=1;
        While (Ptr1+Cnt<Pixel) and (Picture[Pixel+Cnt]=Picture[Ptr1+Cnt]+Add) do Inc(Cnt);
}
        Asm
          push ds
          lds bx,[Pic]
          mov si,[Ptr1]
          mov dx,[Pix]
          mov di,dx
          mov cx,0
          @next:
            inc cx
            inc si
            inc di
            cmp si,dx
            jae @done
              mov al,[bx+si]
              add al,Adder

              cmp al,[bx+di]
          je @next
          @done:
          mov [Cnt],cx
          pop ds
        End;
        If Adder=0 Then Begin
          If Cnt>=Len0 Then Begin
            Ofs0:=Pixel-Ptr1;
            Len0:=Cnt;
          End;
        End Else Begin
          If Cnt>=Len Then Begin
            Add:=Adder;
            Ofs:=Pixel-Ptr1;
            Len:=Cnt;
          End;
        End;
        Inc(Ptr1);
      End;
    End;

    Procedure CountBwCopy(Var Ofs,Len:Word);
    Var
      Pic:Pointer;
      Pix:Word;
      Ptr1,Cnt:Word;
    Begin
      Pic:=@Picture;
      Pix:=Pixel;
      Len:=0;
      Ptr1:=0;
      While Ptr1<Pixel do Begin
{
        Cnt:=0;
        While (Ptr1>=Cnt) and (Picture[Pixel+Cnt]=Picture[Ptr1-Cnt]) do Inc(Cnt);
}
        Asm
          push ds
          lds bx,[Pic]
          mov di,[Ptr1]
          mov si,[Pix]
          mov dx,di
          mov cx,0
          @next:
            cmp dx,cx
            jb @done
              mov al,[si+bx]
              cmp al,[di+bx]
              jne @done
                inc cx
                inc si
                dec di
          jmp @next
          @done:
          mov [Cnt],cx
          pop ds
        End;

        If Cnt>=Len Then Begin
          Ofs:=Pixel-Ptr1;
          Len:=Cnt;
        End;
        Inc(Ptr1);
        If Ptr1<Len Then Ptr1:=Len;
      End;
    End;

    Function Max(A,B:Word):Word;
    Begin
      If A>B Then Max:=A Else Max:=B;
    End;

  Var
    BlockLen,CopyLen,CopyOfs,CAddLen,CAddOfs,BwCopyLen,BwCopyOfs:Word;
    BlockSize,CopySize,CAddSize,BwCopySize:Word;
    BlockGain,CopyGain,CAddGain,BwCopyGain:Integer;
    Cnt:Word;
    Color,Len,Add:Byte;
  Const
    RawSize=10;
  Begin
    SetSize;
    Pixel:=PicStart;
    Commands:=0;
    While Pixel<PicSize do Begin
      Write(Pixel,#13);
      CountBlock(Color,BlockLen);
      If BlockLen<MinBlock Then Begin
        BlockLen:=1;
        BlockSize:=RawSize;
      End Else Begin
        BlockSize:=4+BlockBits+8;
        If BlockLen>MinBlock+BlockRange Then Begin
          BlockLen:=MinBlock+BlockRange;
        End;
      End;
      CountAddCopy(Add,CopyOfs,CopyLen,CAddOfs,CAddLen);
      If CopyLen>=MinCopy Then Begin
        Dec(CopyOfs,CopyLen);
        If CopyLen<CopyLong Then Begin
          CopySize:=2+CopyBits+4+OfsBits(CopyOfs);
        End Else Begin
          CopySize:=2+4+OfsBits(CopyLen-CopyLong)+4+OfsBits(CopyOfs);
        End;
      End Else Begin
        CopySize:=100;
        CopyLen:=0;
      End;
      If (CAddLen>=MinCAdd) and (Add in CAdderRange) Then Begin
        If CAddLen>MinCAdd+CAddRange Then Begin
          CAddLen:=MinCAdd+CAddRange;
        End;
        Dec(CAddOfs,CAddLen);
        CAddSize:=4+CAdderBits+CAddBits+4+OfsBits(CAddOfs);
      End Else Begin
        CAddSize:=100;
        CAddLen:=0;
      End;
      CountBwCopy(BwCopyOfs,BwCopyLen);
      If BwCopyLen>=MinBwCopy Then Begin
        If BwCopyLen<BwCopyLong Then Begin
          BwCopySize:=4+BwCopyBits+4+OfsBits(BwCopyOfs);
        End Else Begin
          BwCopySize:=4+4+OfsBits(BwCopyLen-BwCopyLong)+4+OfsBits(BwCopyOfs);
        End;
      End Else Begin
        BwCopySize:=100;
        BwCopyLen:=0;
      End;
{
  00    copy short   len(CopyBits)+MinCopy,ofs[[4]]+len
  01    copy         len[[4]]+CopyLong,ofs[[4]]+len
  10    raw          color
  1100  block        len(BlockBits)+3,color
  1101  copy add     add(CAdderBits)-CAdder,len(CAddBits)+MinCAdd,Ofs[[4]]+len
  1110  bwcopy short len(BwCopyBits)+MinBwCopy,Ofs[[4]]
  1111  bwcopy       len[[4]]+BwCopyLong,ofs[[4]]
}
      BlockGain:=BlockLen*8-BlockSize;
      CopyGain:=CopyLen*8-CopySize;
      CAddGain:=CAddLen*8-CAddSize;
      BwCopyGain:=BwCopyLen*8-BwCopySize;

      If (CopyGain>BlockGain) or (CAddGain>BlockGain) or (BwCopyGain>BlockGain) Then Begin
        If (CopyGain>=BwCopyGain) or (CAddGain>=BwCopyGain) Then Begin
          If CopyGain>=CAddGain  Then Begin
            If CopyLen<CopyLong Then Begin
              F.AddData(0,2);
              F.AddData(CopyLen-MinCopy,CopyBits);
            End Else Begin
              F.AddData(1,2);
              F.AddLen(CopyLen-CopyLong);
            End;
            F.AddLen(CopyOfs);
            Inc(Pixel,CopyLen);
          End Else Begin
            F.AddData(13,4);
            If Add<100 Then Dec(Add);
            F.AddData(Add+CAdder,CAdderBits);
            F.AddData(CAddLen-MinCAdd,CAddBits);
            F.AddLen(CAddOfs);
            Inc(Pixel,CAddLen);
          End;
        End Else Begin
          If BwCopyLen<BwCopyLong Then Begin
            F.AddData(14,4);
            F.AddData(BwCopyLen-MinBwCopy,BwCopyBits);
          End Else Begin
            F.AddData(15,4);
            F.AddLen(BwCopyLen-BwCopyLong);
          End;
          F.AddLen(BwCopyOfs);
          Inc(Pixel,BwCopyLen);
        End;
      End Else Begin
        If BlockLen>=2 Then Begin
          F.AddData(12,4);
          F.AddData(BlockLen-MinBlock,BlockBits);
          F.AddData(Color,8);
          Inc(Pixel,BlockLen);
        End Else Begin
          F.AddData(2,2);
          F.AddData(Color,8);
          Inc(Pixel);
        End;
      End;
      Inc(Commands);
    End;
    F.AddCodeWord($68,$A000);    { push A000              }
    F.AddCode1($07);             { pop es                 }
    F.AddCodeWord($BF,PicStart); { mov di,PicStart        }
    F.AddCodeWord($BD,Commands); { mov bp,Commands        }
{
  00    copy short   len(CopyBits)+MinCopy,ofs[[4]]+len
  01    copy         len[[4]]+CopyLong,ofs[[4]]+len
  10    raw          color
  1100  block        len(BlockBits)+3,color
  1101  copy add     add(CAdderBits)-CAdder,len(CAddBits)+MinCAdd,Ofs[[4]]+len
  1110  bwcopy short len(BwCopyBits)+MinBwCopy,Ofs[[4]]
  1111  bwcopy       len[[4]]+BwCopyLong,ofs[[4]]
}
    F.AddLabel('next');         { next:                               }
    F.AddCode2($B0,2);          {   mov al,2                          }
    F.AddCall('getbits');       {   call getbits                      }
    F.AddCode2($3C,2);          {   cmp al,2                          }
    F.AddJump($72,'copy');      {   jb copy                           }
    F.AddJump($77,'morecodes'); {     ja morecodes                    }
    F.AddCall('getbyte');       {       call getbyte                  }
    F.AddJump($EB,'store');     {       jmp store                     }
    F.AddLabel('morecodes');    {     morecodes:                      }
    F.AddCode2($B0,2);          {       mov al,2                      }
    F.AddCall('getbits');       {       call getbits                  }
    F.AddCode2($3C,2);          {       cmp al,2                      }
    F.AddJump($77,'bwcopy');    {       ja bwcopy                     }
    F.AddJump($74,'bwcopyshort');{      je bwcopyshort                }
    F.AddCode1($48);            {       dec ax                        }
    F.AddJump($74,'copyadd');   {       jz copyadd                    }
    F.AddCode2($B0,BlockBits);  {         mov al,BlockBits            }
    F.AddCall('getbits');       {         call getbits      ;get len  }
    F.AddCode2($04,MinBlock);   {         add al,MinBlock             }
    F.AddCode1($91);            {         xchg cx,ax                  }
    F.AddCall('getbyte');       {         call getbyte      ;get color}
    F.AddCode1($F3);            {         rep                         }
    F.AddLabel('store');        {       store:                        }
    F.AddCode1($AA);            {         stosb                       }
    F.AddJump($EB,'done');      {         jmp done                    }
    F.AddLabel('copyadd');      {       copyadd:                      }
    F.AddCode2($B0,CAdderBits); {         mov al,CAdderBits ;get add  }
    F.AddCall('getbits');       {         call getbits                }
    F.AddCode2($2C,CAdder);     {         sub al,CAdder               }
    F.AddJump($7C,'negadd');    {         jl negadd                   }
    F.AddCode1($40);            {           inc ax                    }
    F.AddLabel('negadd');       {         negadd:                     }
    F.AddCode1($93);            {         xchg bx,ax        ;move add }
    F.AddCode2($B0,CAddBits);   {         mov al,CAddBits   ;get len  }
    F.AddCall('getbits');       {         call getbits                }
    F.AddCodeWord($05,MinCAdd); {         add ax,MinCAdd              }
    F.AddJump($EB,'doadd');     {         jmp doadd                   }
    F.AddLabel('bwcopyshort');  {       bwcopyshort:                  }
    F.AddCode2($B0,BwCopyBits); {         mov al,BwCopyBits           }
    F.AddCall('getbits');       {         call getbits                }
    F.AddCode2($04,MinBwCopy);  {         add al,MinBwCopy            }
    F.AddJump($EB,'dobwcopy');  {         jmp dobwcopy                }
    F.AddLabel('bwcopy');       {       bwcopy:                       }
    F.AddCall('getbitlen');     {         call getbitlen              }
    F.AddCodeWord($05,BwCopyLong);{       add ax,BwCopyLong           }
    F.AddLabel('dobwcopy');     {       dobwcopy:                     }
    F.AddCode1($50);            {       push ax             ;save len }
    F.AddCall('getbitlen');     {       call getbitlen      ;get ofs  }
    F.AddCode2($89,$FB);        {       mov bx,di                     }
    F.AddCode2($29,$C3);        {       sub bx,ax                     }
    F.AddCode1($59);            {       pop cx              ;get len  }
    F.AddLabel('nextbwcopy');   {       nextbwcopy:                   }
    F.AddCode3($26,$8A,$07);    {         mov al,[es:bx]              }
    F.AddCode1($4B);            {         dec bx                      }
    F.AddCode1($AA);            {         stosb                       }
    F.AddJump($E2,'nextbwcopy');{       loop nextbwcopy               }
    F.AddJump($EB,'done');      {       jmp done                      }
    F.AddLabel('copy');         {   copy:                             }
    F.AddCode1($48);            {     dec ax                          }
    F.AddJump($74,'copylong');  {     jz copylong                     }
    F.AddCode2($B0,CopyBits);   {       mov al,CopyBits   ;get len    }
    F.AddCall('getbits');       {       call getbits                  }
    F.AddCode2($04,MinCopy);    {       add al,MinCopy                }
    F.AddJump($EB,'docopy');    {       jmp docopy                    }
    F.AddLabel('copylong');     {     copylong:                       }
    F.AddCall('getbitlen');     {       call getbitlen    ;get len    }
    F.AddCodeword($05,CopyLong);{       add ax,CopyLong               }
    F.AddLabel('docopy');       {     docopy:                         }
    F.AddCode2($31,$DB);        {     xor bx,bx           ;add=0      }
    F.AddLabel('doadd');        {   doadd:                            }
    F.AddCode1($53);            {     push bx             ;save add   }
    F.AddCode1($50);            {     push ax             ;save len   }
    F.AddCall('getbitlen');     {     call getbitlen      ;get ofs    }
    F.AddCode1($59);            {     pop cx              ;get len    }
    F.AddCode1($5B);            {     pop bx              ;get add    }
    F.AddCode1($52);            {     push dx             ;save buf   }
    F.AddCode2($89,$DA);        {     mov dx,bx           ;move add   }
    F.AddCode1($93);            {     xchg bx,ax          ;move ofs   }
    F.AddCode2($01,$CB);        {     add bx,cx           ;ofs+=len   }
    F.AddCode2($F7,$DB);        {     neg bx              ;-ofs       }
    F.AddLabel('nextcopy');     {     nextcopy:                       }
    F.AddCode3($26,$8A,$01);    {       mov al,[es:di+bx] ;get byte   }
    F.AddCode2($00,$D0);        {       add al,dl         ;add        }
    F.AddCode1($AA);            {       stosb             ;store byte }
    F.AddJump($E2,'nextcopy');  {     loop nextcopy                   }
    F.AddCode1($5A);            {     pop dx              ;get buf    }
    F.AddLabel('done');         {   done:                             }
    F.AddCode1($4D);            {   dec bp                            }
    F.AddJump($74,'exit');      {   jz exit               ;next cmd   }
    F.AddWordJump('next');      { jmp next                            }
    F.AddLabel('exit');         { exit:                               }
  End;

Begin
  PackStream(Commands);

  F.AddCode2($31,$C0);       { xor ax,ax               ;readkey    }
  F.AddCode2($CD,22);        { int 22                              }
  F.AddCodeWord($B8,3);      { mov ax,3                ;textmode   }
  F.AddCode2($CD,16);        { int 16                              }
  F.AddCode2($CD,32);        { int 32                  ;terminate  }

  F.AddLabel('getbyte');     { getbyte:                             }
  F.AddCode2($B0,8);         {   mov al,8              ;get 8 bits  }
  F.AddLabel('getbits');     { getbits:                             }
  F.AddCode1($51);           {   push cx               ;save cx     }
  F.AddCode2($88,$C1);       {   mov cl,al             ;set counter }
  F.AddCode2($30,$ED);       {   xor ch,ch                          }
  F.AddCode2($31,$C0);       {   xor ax,ax             ;clear ax    }
  F.AddJump($E3,'gotbits');  {   jcxz gotbits                       }
  F.AddLabel('nextbit');     {     nextbit:                         }
  F.AddCode2($08,$D2);       {       or dl,dl          ;buf empty?  }
  F.AddJump($75,'notempty'); {       jnz notempty                   }
  F.AddCode2($8A,$34);       {         mov dh,[si]     ;get byte    }
  F.AddCode1($46);           {         inc si                       }
  F.AddCode2($F6,$D2);       {         not dl          ;set flags   }
  F.AddLabel('notempty');    {       notempty:                      }
  F.AddCode2($D1,$E2);       {       shl dx,1          ;get bit     }
  F.AddCode2($D1,$D0);       {       rcl ax,1          ;store in ax }
  F.AddJump($E2,'nextbit');  {     loop nextbit                     }
  F.AddLabel('gotbits');     {   gotbits:                           }
  F.AddCode1($59);           {   pop cx                ;restore cx  }
  F.AddCode1($C3);           { ret                                  }

  F.AddLabel('testbit');     { testbit:                             }
  F.AddCode2($B0,1);         {   mov al,1              ;get one bit }
  F.AddCall('getbits');      {   call getbits                       }
  F.AddCode2($08,$C0);       {   or al,al              ;test it     }
  F.AddCode1($C3);           { ret                                  }

  F.AddLabel('getbitlen');   { getbitlen:                          }
  F.AddCode2($B0,$04);       {   mov al,4              ;get bits   }
  F.AddCall('getbits');      {   call getbits                      }
  F.AddCode2($88,$C1);       {   mov cl,al             ;1<<bits    }
  F.AddCodeWord($BB,1);      {   mov bx,1                          }
  F.AddCode2($D3,$E3);       {   shl bx,cl                         }
  F.AddCode1($4B);           {   dec bx                ;-1         }
  F.AddCall('getbits');      {   call getbits          ;get ofs    }
  F.AddCode2($01,$D8);       {   add ax,bx                         }
  F.AddCode1($C3);           { ret                                 }

  F.AddLabel('readtreenodes');   { readtreenodes:                        }
  F.AddCall('readtreenode');     {   call readtreenode                   }
  F.AddLabel('readtreenode');    { readtreenode:                         }
  F.AddCall('testbit');          {   call testbit                        }
  F.AddCode1($AA);               {   stosb                ;store split   }
  F.AddJump($75,'split');        {   jnz split                           }
  F.AddCall('getbyte');          {     call getbyte       ;get color     }
  F.AddCode1($AA);               {     stosb                             }
  F.AddCode1($C3);               {     ret                               }
  F.AddLabel('split');           {   split:                              }
  F.AddCode2($88,$D8);           {   mov al,bl                           }
  F.AddCode1($AA);               {   stosb                               }
  F.AddCode1($57);               {   push di              ;save index    }
  F.AddCode2($89,$DF);           {   mov di,bx            ;Tree[Nodes]   }
  F.AddCode3($C1,$E7,2);         {   shl di,2                            }
  F.AddCode2Abs($81,$C7,'bss',0);{   add di,bss                          }
  F.AddCode1($43);               {   inc bx               ;Inc(Nodes)    }
  F.AddCall('readtreenodes');    {   call readtreenodes                  }
  F.AddCode1($5F);               {   pop di               ;restore index }
  F.AddCode1($C3);               { ret                                   }

  F.AddLabel('getcolor');        { getcolor:                       }
  F.AddCode2($31,$C0);           {   xor ax,ax         ;code=0     }
  F.AddLabel('nextnode');        {   nextnode:                     }
  F.AddCode1($93);               {     xchg bx,ax      ;Tree[code] }
  F.AddCode2($D1,$E3);           {     shl bx,1                    }
  F.AddCall('testbit');          {     call testbit                }
  F.AddCode2($01,$C3);           {     add bx,ax       ;.Leg[bit]  }
  F.AddCode2($D1,$E3);           {     shl bx,1                    }
  F.AddCode2Abs($81,$C3,'bss',0);{     add bx,bss                  }
  F.AddCode3($8A,$47,1);         {     mov al,[bx+1]   ;get code   }
  F.AddCode3($80,$3F,0);         {     cmp byte[bx],0              }
  F.AddJump($75,'nextnode');     {   jnz nextnode                  }

  F.AddCode2($3C,217);           {   cmp al,217                    }
  F.AddJump($74,'getbyte');      {   je getbyte                    }

  F.AddCode1($C3);               { ret                             }

End;

(*
Procedure TImage.Unpack(Var F:TCode; Commands:Word);

  Function GetBits(Bits:Byte):Word;
  Begin
    GetBits:=F.Stream.Read(Bits);
  End;

  Function GetBitLen:Word;
  Var
    Len:Byte;
  Begin
    Len:=GetBits(4);
    GetBitLen:=GetBits(Len)+Pred(1 shl Len);
  End;

  Procedure UnpackStream(Pixel,Commands:Word);
  Var
    Ptr:Word;
    Red,Green,Blue:Byte;
    Code,Color,Add:Byte;
    Cmd,Cnt,Ofs:Word;
  Begin
{
  -1..2   126    0     rr gg bb
  -4..3    50    10    rrr ggg bbb
  0..1     12    110   r g b
  -9..6    12    1110  rrrr gggg bbbb
  0..63     9    1111  rrrrrr gggggg bbbbbb
}
    FillChar(Palette,768,0);
    Ptr:=0;
    For Color:=1 to 210 do Begin
      If GetBits(1)=0 Then Begin
        Inc(Red,GetBits(2)-1);
        Inc(Green,GetBits(2)-1);
        Inc(Blue,GetBits(2)-1);
      End Else Begin
        If GetBits(1)=0 Then Begin
          Inc(Red,GetBits(3)-4);
          Inc(Green,GetBits(3)-4);
          Inc(Blue,GetBits(3)-4);
        End Else Begin
          If GetBits(1)=0 Then Begin
            Inc(Red,GetBits(1));
            Inc(Green,GetBits(1));
            Inc(Blue,GetBits(1));
          End Else Begin
            If GetBits(1)=0 Then Begin
              Inc(Red,GetBits(4)-9);
              Inc(Green,GetBits(4)-9);
              Inc(Blue,GetBits(4)-9);
            End Else Begin
              Red:=GetBits(6);
              Green:=GetBits(6);
              Blue:=GetBits(6);
            End;
          End;
        End;
      End;
      With Palette[Color] do Begin
        R:=Red;
        G:=Green;
        B:=Blue;
      End;
    End;
{
  00    copy short   len(CopyBits)+MinCopy,ofs[[4]]+len
  01    copy         len[[4]]+CopyLong,ofs[[4]]+len
  10    raw          color
  1100  block        len(BlockBits)+3,color
  1101  copy add     add(CAdderBits)-CAdder,len(CAddBits)+MinCAdd,Ofs[[4]]+len
  1110  bwcopy short len(BwCopyBits)+MinBwCopy,Ofs[[4]]
  1111  bwcopy       len[[4]]+BwCopyLong,ofs[[4]]
}
    FillChar(Picture,64000,0);
    For Cmd:=1 to Commands do Begin
      Case GetBits(2) of
        0:Begin
          Cnt:=GetBits(CopyBits)+MinCopy;
          Ofs:=GetBitLen+Cnt;
          Repeat
            Picture[Pixel]:=Picture[Pixel-Ofs];
            Inc(Pixel);
            Dec(Cnt);
          Until Cnt=0;
        End;
        1:Begin
          Cnt:=GetBitLen+CopyLong;
          Ofs:=GetBitLen+Cnt;
          Repeat
            Picture[Pixel]:=Picture[Pixel-Ofs];
            Inc(Pixel);
            Dec(Cnt);
          Until Cnt=0;
        End;
        2:Begin
          Picture[Pixel]:=GetBits(8);
          Inc(Pixel);
        End;
        3:Begin
          Case GetBits(2) of
            0:Begin
              Cnt:=GetBits(BlockBits)+MinBlock;
              Color:=GetBits(8);
              Repeat
                Picture[Pixel]:=Color;
                Inc(Pixel);
                Dec(Cnt);
              Until Cnt=0;
            End;
            1:Begin
              Add:=Byte(GetBits(CAdderBits)-CAdder);
              If Add<100 Then Inc(Add);
              Cnt:=GetBits(CAddBits)+MinCAdd;
              Ofs:=GetBitLen+Cnt;
              Repeat
                Picture[Pixel]:=Byte(Picture[Pixel-Ofs]+Add);
                Inc(Pixel);
                Dec(Cnt);
              Until Cnt=0;
            End;
            2:Begin
              Cnt:=GetBits(BwCopyBits)+MinBwCopy;
              Ofs:=Pixel-GetBitLen;
              Repeat
                Picture[Pixel]:=Picture[Ofs];
                Inc(Pixel);
                Dec(Ofs);
                Dec(Cnt);
              Until Cnt=0;
            End;
            3:Begin
              Cnt:=GetBitLen+BwCopyLong;
              Ofs:=Pixel-GetBitLen;
              Repeat
                Picture[Pixel]:=Picture[Ofs];
                Inc(Pixel);
                Dec(Ofs);
                Dec(Cnt);
              Until Cnt=0;
            End;
          End;
        End;
      End;
    End;
  End;

Begin
  F.Stream.Reset;
  UnpackStream(PicStart,Commands);
End;
*)

Var
  Image:PImage;
  F:TCode;
  Commands:Word;

Begin
  New(Image);
  Image^.Load('hugi.raw');
  F.Create('entry.com');
  Image^.MakePalette(F);
  Image^.MakePicture(F,Commands);
  F.Stream.Close;
  {Image^.Unpack(F,Commands);}
  F.Close;
  Dispose(Image);
End.
