Unit CodeMake;

{$A-,B-,D-,E-,F-,G+,I-,L-,N+,O-,P-,Q-,R-,S-,T+,V-,X+}
{$M 65520,0,655360}

{

CodeMaker unit
Copyright 1999 GreenGhost

99.05.13 : 0.01
99.05.14 : 0.02 : Absolute reference added
99.05.15 : 0.03 : Duplicate label check added
99.05.16 : 0.04 : BufBits made public
99.05.20 : 0.05 : Stream object added
99.05.25 : 0.06 : AddLen added
99.05.27 : 0.07 : Range checking for short jumps added
99.05.29 : 0.08 : Close returns size
99.05.31 : 0.09 : AddWordJump added

}

Interface

Uses
  BitStrm;

Const
  MaxCodeSize=5000;
  MaxDataSize=40000;

Type
  TName=String[20];

  PLabel=^TLabel;
  TLabel=Record
    Name:TName;
    Ofs:Word;
    Next:PLabel;
  End;

  PRef=^TRef;
  TRef=Record
    Name:TName;
    Ofs:Word;
    Short:Boolean;
    Next:PRef;
  End;

  PAbs=^TAbs;
  TAbs=Record
    Name:TName;
    Ofs:Word;
    Add:Word;
    Next:PAbs;
  End;

  TCodeBuffer=Array[0..MaxCodeSize-1] of Byte;
  TDataBuffer=Array[0..MaxDataSize-1] of Byte;

  TBufBitStream=Object(TBitStream)
    Buffer:^TDataBuffer;
    DataSize,ReadOfs:Word;
    Constructor Init(Var Buf:TDataBuffer);
    Procedure   Reset;
    Procedure   Input; Virtual;
    Procedure   Output; Virtual;
  End;

  TCode=Object
  Private
    F:File;
    Labels:PLabel;
    Refs:PRef;
    Abses:PAbs;
    Buffer:Byte;
    Function  FindLabel(Const Name:TName):Word;
    Procedure AddRef(Const Name:TName; Short:Boolean);
    Procedure AddAbs(Const Name:TName; Add:Word);
  Public
    Code:^TCodeBuffer;
    Data:^TDataBuffer;
    CodeSize:Word;
    Stream:TBufBitStream;
    Procedure Create(Const Name:String);
    Function  Close:LongInt;
    Procedure AddData(Code1:Word; Bits:Byte);
    Procedure AddLen(Len:Word);
    Procedure AddCode1(Code1:Byte);
    Procedure AddCode2(Code1,Code2:Byte);
    Procedure AddCode3(Code1,Code2,Code3:Byte);
    Procedure AddSetCounter(Cnt:Word);
    Procedure AddCodeWord(Code1:Byte; Code2:Word);
    Procedure AddLabel(Const Name:TName);
    Procedure AddLabelOfs(Const Name:TName; Add:Word);
    Procedure AddJump(Code1:Byte; Const Name:TName);
    Procedure AddWordJump(Const Name:TName);
    Procedure AddCall(Const Name:TName);
    Procedure AddCodeAbs(Code1:Byte; Const Name:TName; Add:Word);
    Procedure AddCode2Abs(Code1,Code2:Byte; Const Name:TName; Add:Word);
  End;

Implementation

Constructor TBufBitStream.Init(Var Buf:TDataBuffer);
Begin
  Inherited Init(True);
  Buffer:=@Buf;
  DataSize:=0;
End;

Procedure TBufBitStream.Reset;
Begin
  ReadOfs:=0;
  BufBits:=0;
End;

Procedure TBufBitStream.Input;
Begin
  BufByte:=Buffer^[ReadOfs];
  Inc(ReadOfs);
End;

Procedure TBufBitStream.Output;
Begin
  Buffer^[DataSize]:=BufByte;
  Inc(DataSize);
End;

Function TCode.FindLabel(Const Name:TName):Word;
Var
  Lbl:PLabel;
Begin
  Lbl:=Labels;
  While Lbl^.Name<>Name do Begin
    Lbl:=Lbl^.Next;
    If Lbl=Nil Then Begin
      WriteLn('Unknown label : ',Name);
      Halt;
    End;
  End;
  FindLabel:=Lbl^.Ofs;
End;

Procedure TCode.AddRef(Const Name:TName; Short:Boolean);
Var
  Ref:PRef;
Begin
  New(Ref);
  Ref^.Name:=Name;
  Ref^.Ofs:=CodeSize;
  Ref^.Short:=Short;
  Ref^.Next:=Refs;
  Refs:=Ref;
End;

Procedure TCode.AddAbs(Const Name:TName; Add:Word);
Var
  Abs:PAbs;
Begin
  New(Abs);
  Abs^.Name:=Name;
  Abs^.Ofs:=CodeSize;
  Abs^.Add:=Add;
  Abs^.Next:=Abses;
  Abses:=Abs;
End;

Procedure TCode.Create(Const Name:String);
Begin
  Assign(F,Name);
  Rewrite(F,1);
  CodeSize:=0;
  New(Code);
  New(Data);
  Labels:=Nil;
  Refs:=Nil;
  Stream.Init(Data^);
End;

Function TCode.Close:LongInt;
Var
  Ref:PRef;
  Abs:PAbs;
  Lbl:PLabel;
  Ofs:Integer;
Begin
  Stream.Close;
  AddLabel('data');
  AddLabelOfs('bss',Stream.DataSize);
  While Refs<>Nil do Begin
    Ref:=Refs;
    Refs:=Ref^.Next;
    Ofs:=FindLabel(Ref^.Name)-Ref^.Ofs-1;
    If Ref^.Short Then Begin
      If (Ofs>127) or (Ofs<-128) Then Begin
        WriteLn('Short reference out of range!');
        Halt;
      End;
      Code^[Ref^.Ofs]:=Lo(Ofs);
    End Else Begin
      Dec(Ofs);
      Code^[Ref^.Ofs]:=Lo(Ofs);
      Code^[Succ(Ref^.Ofs)]:=Hi(Ofs);
    End;
    Dispose(Ref);
  End;
  While Abses<>Nil do Begin
    Abs:=Abses;
    Abses:=Abs^.Next;
    Ofs:=FindLabel(Abs^.Name)+Abs^.Add+256;
    Code^[Abs^.Ofs]:=Lo(Ofs);
    Code^[Succ(Abs^.Ofs)]:=Hi(Ofs);
    Dispose(Abs);
  End;
  While Labels<>Nil do Begin
    Lbl:=Labels;
    Labels:=Lbl^.Next;
    Dispose(Lbl);
  End;
  BlockWrite(F,Code^,CodeSize);
  BlockWrite(F,Data^,Stream.DataSize);
  System.Close(F);
  Close:=CodeSize+Stream.DataSize;
  Dispose(Code);
  Dispose(Data);
End;

Procedure TCode.AddData(Code1:Word; Bits:Byte);
Begin
  Stream.Write(Code1,Bits);
End;

Procedure TCode.AddLen(Len:Word);
Var
  Bits:Byte;
Begin
  Bits:=0;
  While Len>(2 shl Bits)-2 do Inc(Bits);
  AddData(Bits,4);
  AddData(Len-Pred(1 shl Bits),Bits);
End;

Procedure TCode.AddCode1(Code1:Byte);
Begin
  Code^[CodeSize]:=Code1;
  Inc(CodeSize);
End;

Procedure TCode.AddCode2(Code1,Code2:Byte);
Begin
  AddCode1(Code1);
  AddCode1(Code2);
End;

Procedure TCode.AddCode3(Code1,Code2,Code3:Byte);
Begin
  AddCode2(Code1,Code2);
  AddCode1(Code3);
End;

Procedure TCode.AddSetCounter(Cnt:Word);
Begin
  If Cnt<256 Then Begin
    AddCode2($B1,Cnt);    { B1xx     mov cl,xx   }
  End Else Begin
    AddCodeWord($B9,Cnt); { B9xxyy   mov cx,yyxx }
  End;
End;

Procedure TCode.AddCodeWord(Code1:Byte; Code2:Word);
Begin
  AddCode3(Code1,Lo(Code2),Hi(Code2));
End;

Procedure TCode.AddLabel(Const Name:TName);
Begin
  AddLabelOfs(Name,0);
End;

Procedure TCode.AddLabelOfs(Const Name:TName; Add:Word);
Var
  Lbl:PLabel;
Begin
  Lbl:=Labels;
  While Lbl<>Nil do Begin
    If Lbl^.Name=Name Then Begin
      WriteLn('Duplicate label : ',Name);
      Halt;
    End;
    Lbl:=Lbl^.Next;
  End;
  New(Lbl);
  Lbl^.Name:=Name;
  Lbl^.Ofs:=CodeSize+Add;
  Lbl^.Next:=Labels;
  Labels:=Lbl;
End;

Procedure TCode.AddJump(Code1:Byte; Const Name:TName);
Begin
  AddCode1(Code1);
  AddRef(Name,True);
  AddCode1(0);
End;

Procedure TCode.AddWordJump(Const Name:TName);
Begin
  AddCode1($E9);
  AddRef(Name,False);
  AddCode2(0,0);
End;

Procedure TCode.AddCall(Const Name:TName);
Begin
  AddCode1($E8);
  AddRef(Name,False);
  AddCode2(0,0);
End;

Procedure TCode.AddCodeAbs(Code1:Byte; Const Name:TName; Add:Word);
Begin
  AddCode1(Code1);
  AddAbs(Name,Add);
  AddCode2(0,0);
End;

Procedure TCode.AddCode2Abs(Code1,Code2:Byte; Const Name:TName; Add:Word);
Begin
  AddCode2(Code1,Code2);
  AddAbs(Name,Add);
  AddCode2(0,0);
End;

End.
