Unit BitStrm;

{

0.01 : 98.10.13
0.02 : 99.05.20 : Splitted into BitStrm & FBitStrm
0.03 : 99.05.21 : Allows multiple Close calls

}

Interface

Type
  TBitStream=Object
    Out:Boolean;
    BufByte,BufBits:Byte;
    Constructor Init(StreamOut:Boolean);
    Destructor  Close;
    Procedure   Input; Virtual;
    Procedure   Output; Virtual;
    Function    Read(Bits:Byte):LongInt;
    Procedure   Write(Data:LongInt; Bits:Byte);
    Function    ReadBit:Byte;
    Procedure   WriteBit(Data:Byte);
  End;

Implementation

Constructor TBitStream.Init(StreamOut:Boolean);
Begin
  Out:=StreamOut;
  BufByte:=0;
  BufBits:=0;
End;

Destructor TBitStream.Close;
Begin
  If Out Then Begin
    If BufBits>0 Then Begin
      Output;
      BufBits:=0;
    End;
  End;
End;

Procedure TBitStream.Output;
Begin
  RunError;
End;

Procedure TBitStream.Input;
Begin
  RunError;
End;

Function TBitStream.Read(Bits:Byte):LongInt;
Var
  Data:LongInt;
Begin
  Data:=0;
  While Bits>0 do Begin
    Data:=(Data shl 1)+ReadBit;
    Dec(Bits);
  End;
  Read:=Data;
End;

Procedure TBitStream.Write(Data:LongInt; Bits:Byte);
Begin
  While Bits>0 do Begin
    Dec(Bits);
    WriteBit((Data shr Bits) and 1);
  End;
End;

Function TBitStream.ReadBit:Byte;
Begin
  If BufBits=0 Then Begin
    Input;
    BufBits:=8;
  End;
  Dec(BufBits);
  ReadBit:=(BufByte shr BufBits) and 1;
End;

Procedure TBitStream.WriteBit(Data:Byte);
Begin
  BufByte:=BufByte or (Data shl (7-BufBits));
  Inc(BufBits);
  If BufBits=8 Then Begin
    Output;
    BufByte:=0;
    BufBits:=0;
  End;
End;

End.
