;  TEMPLATE
;  Developed by Boo Khan Ming (Malaysia)
;
;  Revision 1.0 (1999.5.12)
;
;  E-mail: bookm@tm.net.my
;  WWW:    http://www.geocities.com/SiliconValley/Horizon/3409
;
;
;  This is my own compression technique.
;  Two different compression techniques employed here.
;  The palette is compact through 8-to-6 bit transformation.
;  The image data is compact through frequency table.

        .MODEL Tiny
        .286

        .CODE
        .STARTUP

        push    cs
        pop     ds
        push    0a000h
        pop     es
        mov     al, 13h
        int     10h
        mov     dx, 03c8h
        xor     ax, ax
        out     dx, al
        inc     dx
        mov     cx, 192
        mov     si, OFFSET Palette
NextPalette:
        lodsw
        mov     bx, ax
        lodsb
        mov     ah, al
        mov     al, bl
        shr     al, 2
        out     dx, al
        shl     bl, 6
        shr     bl, 2
        mov     al, bh
        shr     al, 4
        or      al, bl
        out     dx, al
        shl     bh, 4
        shr     bh, 2
        mov     al, ah
        shr     al, 6
        or      al, bh
        out     dx, al
        mov     al, ah
        and     al, 03fh
        out     dx, al
        loop    NextPalette
        xor     di, di
        add     si, 90
NextImage:
        lodsb
        push    si
        mov     cx, 45
        mov     si, OFFSET FrequencyTable
NextTable:
        mov     bx, [si]
        cmp     bh, al
        jz      Expand
        inc     si
        inc     si
        loop    NextTable
        stosb
        pop     si
        cmp     di, 60480
        jae     Exit
        jmp     NextImage
Expand:
        pop     si
        lodsb
        mov     cl, al
        mov     al, bl
        rep     stosb
        cmp     di, 60480
        jae     Exit
        jmp     NextImage
Exit:
        xor     ax, ax
        int     16h
        mov     ax, 03h
        int     10h
        mov     ah, 4ch
        int     21h

        Palette         db      576 DUP(?)
        FrequencyTable  dw      45 DUP(?)

        END
