bits 32

section .text

_WdosxStart:

; ESI=argc, EDI=argv[], EBP=env[]

; Assemble with NASM as rdoff object, link with WDOSX extender.

        mov     [argc],esi
        mov     [argv],edi
        mov     [env],ebp

        and     dword [Int_SP],byte 0   ; Clear SS:SP to fix stack.
        mov     eax,ds
        mov     es,eax

        cmp     esi,2
        jae     NoProblem
        mov     ah,09h
        mov     edx,Error0
        int     21h
        mov     ah,4Ch
        int     21h
NoProblem:

        mov     eax,3D00h               ; Open file for read access
        mov     edx,[edi+4]             ; argv[1]
        int     21h
        jnc     NoProblem2
        mov     ah,09h
        mov     edx,Error1
        int     21h
        mov     ah,4Ch
        int     21h
NoProblem2:
        xchg    ebx,eax                 ; Put file handle in EBX
        mov     edx,Palette             ; Read it into the pallete and image.
        mov     ecx,64768               ; Read all the bytes!
        mov     ah,3Fh                  ; Read from File
        int     21h
        cmp     eax,ecx                 ; Make sure we read enough!
        jz      NoProblem3
        mov     ah,09h
        mov     edx,Error2
        int     21h
        mov     ah,4Ch
        int     21h
NoProblem3:
        mov     ah,3Eh                  ; We are done with the file, so
        int     21h                     ; we kindly close it.

        jmp    SkipGraphics

        mov     dword [Int_EAX],0013h   ; Set the neat video mode!
        mov     bl,10h                  ; Call our wonderful friend int 10h
        call    RealInt                 ; With our wonderful kludge!
        mov     edx,03C4h
        mov     eax,0604h
        out     dx,ax                   ; Disable chain4 mode
        mov     eax,0100h
        out     dx,ax                   ; Synchronous reset while switching clocks
        mov     dl,0C2h
        mov     al,0E3h
        out     dx,al                   ; Select 28 MHz dot clock & 60 Hz scanning rate
        mov     dl,0C4h
        mov     eax,0300h
        out     dx,ax                   ; Undo reset (restart sequencer)
        mov     dl,0D4h                 ; reprogram the CRT Controller
        mov     al,11h                  ; VSync End reg contains register write
        out     dx,al                   ; protect bit
        inc     edx                     ; CRT Controller Data register
        in      al,dx                   ; get current VSync End register setting
        and     al,7fh                  ; remove write protect on various
        out     dx,al                   ; CRTC registers
        dec     edx                     ; CRT Controller Index
        mov     esi,CRTCValues
        mov     ecx,10
        rep     outsw
        mov     dl,0C4h
        mov     eax,0F02h        
        out     dx,ax                   ; enable writes to all four planes

        mov     edi,000A0000h
        mov     ecx,4800
        xor     eax,eax
        rep     stosd
       

        mov     esi,Palette
        mov     edx,03C8h
        mov     al,0
        out     dx,al                   ; Write offset of palette start.
        inc     edx                     ; Increment to the next port for 
        mov     ecx,0300h               ; value writes.
        rep     outsb                   ; And write them all!


        call    BlitImage
        call    DrawPaletteLines
        
SkipGraphics:

        call    ReducePaletteEntries

        call    PerformStatistics


;        mov     byte [Int_EAX+1],0
;        mov     bl,16h
;        call    RealInt

;        call    BlitImage
;        mov     esi,Palette
;        mov     edx,03C8h
;        mov     al,0
;        out     dx,al                   ; Write offset of palette start.
;        inc     edx                     ; Increment to the next port for 
;        mov     ecx,0300h               ; value writes.
;        rep     outsb                   ; And write them all!

        mov     edi,[NumberOfColors]
        lea     edi,[edi*2+edi+Palette]
        mov     esi,Image
        mov     ecx,16000        
        rep     movsd

        mov     esi,Palette
        mov     edi,Compress2
        mov     [HappyOffset],edi
        mov     ecx,[NumberOfColors]
        lea     ecx,[ecx*2+ecx+64000]
        xor     edx,edx
M_L0:   mov     al,[esi]
        inc     esi
        inc     edx
        test    al,al
        jz      M_P4
        cmp     edx,1
        jz      M_P1
        dec     edx
        mov     bl,dl
        and     bl,0Fh
        jz      M_P5
        add     bl,240
        mov     [edi],bl
        inc     edi
M_P5:   shr     edx,4
M_L1:   test    edx,edx
        jz      M_P1
        mov     ebx,edx
        cmp     ebx,31
        jb      M_P2
        mov     ebx,30
M_P2:   sub     edx,ebx
        add     bl,210
        mov     [edi],bl
        inc     edi
        jmp     short M_L1
M_P1:   xor     edx,edx
M_P0:   mov     [edi],al
M_P3:   inc     edi
M_P4:   dec     ecx
        jnz     M_L0



        mov     [HappySize],edi

        mov     eax,[HappySize]
        sub     eax,Compress2
        call    WriteNumber


        call    CompressLZW

        mov     ah,3Ch
        mov     edx,NewFileName
        xor     ecx,ecx
        int     21h
        jnc     NoProblem4
        mov     dword [Int_EAX],0003h
        mov     bl,10h
        call    RealInt
        mov     ah,09h
        mov     edx,Error3
        int     21h
        mov     ah,4Ch
        int     21h
NoProblem4:
        mov     ebx,eax

        mov     ecx,[NumberOfColors]
        mov     eax,ecx
        call    WriteNumber
        lea     ecx,[ecx*2+ecx]
        mov     [LZW_aa+1],cx

        mov     ecx,[CompressLength]
;        inc     ecx
;        and     ecx,byte -2
;        add     ecx,(LZ77End-LZ77Fix)-2
;        mov     [LZ77xx+1],cx

        mov     ah,40h
        mov     ecx,LZWEnd-LZWStart
        mov     edx,LZWStart
        int     21h

        mov     ah,40h
        mov     ecx,[CompressLength]
        mov     edx,Compress
        int     21h


        mov     ah,3Eh
        int     21h



;        and     dword [Int_EAX],byte 0
;        mov     bl,16h
;        call    RealInt


;        mov     dword [Int_EAX],0003h
;        mov     bl,10h
;        call    RealInt

        mov     ah,4Ch
        int     21h


PerformStatistics:
        pushad
        mov     ecx,256
        xor     eax,eax
        mov     edi,PaletteTable
        rep     stosd

        mov     esi,Image

PS_L0:  mov     al,[esi]
        inc     esi
        inc     dword [eax*4+PaletteTable]
        cmp     esi,Image+64000
        jb      PS_L0

        xor     ecx,ecx
        mov     esi,PaletteTable

PS_L1:  mov     eax,ecx
        call    WriteNumber
        mov     eax,[esi+ecx*4]
        call    WriteNumber
        mov     ah,09h
        mov     edx,CRLF
        int     21h
        inc     ecx
        cmp     ecx,256
        jb      PS_L1



        popad
        ret


ReducePaletteEntries:
        pushad
        mov     ecx,64
        mov     edi,PaletteTable
        xor     eax,eax
        rep     stosd
        mov     esi,Image
RPE_L0: mov     al,[esi]
        inc     esi
        mov     byte [eax+PaletteTable],1
        cmp     esi,Image+64000
        jb      RPE_L0

        xor     edi,edi
        mov     ebp,256
RPE_L1: cmp     byte [edi+PaletteTable],1
        jz      RPE_P0
        mov     ecx,256
        lea     esi,[edi+ebp-256]
        sub     ecx,esi
        lea     esi,[esi*2+esi+Palette]
        jz      RPE_P1
RPE_L2: mov     al,[esi+3]
        mov     [esi],al
        mov     al,[esi+4]
        mov     [esi+1],al
        mov     al,[esi+5]
        mov     [esi+2],al
        add     esi,byte 3
        dec     ecx
        jnz     RPE_L2
        mov     byte [Palette+(255*3)],0
        mov     byte [Palette+(255*3)+1],63
        mov     byte [Palette+(255*3)+2],63
RPE_P1: lea     eax,[edi+ebp-256]
        mov     esi,Image
        mov     ecx,64000
RPE_L3: cmp     byte [esi],al
        jb      RPE_P2
        dec     byte [esi]
RPE_P2: inc     esi
        dec     ecx
        jnz     RPE_L3
        dec     ebp
RPE_P0: inc     edi
        cmp     edi,256
        jb      RPE_L1

        mov     [NumberOfColors],ebp

        popad
        ret


; LZ77 is conceptually simpler than LZW compression, because it consists
; soley of storing pointers to the already decoded string with a length
; of characters to copy, and if no previous string of bytes will suffice,
; allowing new bytes to be read in.  This will be accomplished by keeping
; a MaximumCodeSize variable, which is the maximum possible pointer to the
; decoded string, plus 2.  If the pointer is to the end of the decoded string
; (e.g. 0 bytes after it) then a fixed number of bytes between 1 and 16 will
; be read from the stream after reading a 4 bit value, corresponding to the
; number of bytes to read -1.  If the pointer is to the end of the decoded
; string plus one (-1 bytes, theoretically), then the stream is done.
; Therefore, the MaximumCodeSize starts 2.  It then increases as the length
; of the decoded stream increases.  For pointers inside the decoded block,
; a second variable is read, with a maximum size of EndOfStream-Pointer.
; This is the maximum length that could be copied from the decoded stream at
; the Pointer position.  Therefore, the compressor should find the longest
; string at the highest position, to minimize the size of the length
; variable.
;
;       EndOfStream starts at 0, and is equal to the offset in the stream
; where the next decoded byte will be written.      
;
;       CompressPointer starts at Palette, and it is the pointer to the byte
; which is the next to be compresses.  CompressPointer-EndOfStream is the
; length of the string currently being manipulated, plus the offset of
; Palette.
;
;
;
;       The codes will be stored by multiplying the encoded data stream by
; the size of the MaxCodeVariable or another value, and then adding the
; value of the code to the stream.  This will facilitate maximum compression.
;

; **************************************************************************
; This method of LZ77 works more like LZW.  All codes below 256 are bytes to
; be written to the stream.  Codes above 256 have 256 subtracted from them,
; and if it is longer than the decoded stream, it is the end code.  Otherwise
; it works the same as the code in the above version, followed by a length
; code depending on where the pointer is.  The length code does not have
; 256 byte entries.
;
;
;
;
;
;


CompressLZ77:
        pushad
        xor     esi,esi                 ; Pointer into the data stream.
        mov     [CodePosition],esi      ; Zero this, too
        mov     ebp,257                 ; Size of code.
        mov     al,[esi+Palette]        ; Move the first byte into AL
C77_P2: movzx   ebx,al                  ; Zero extend the first byte into ebx
        mov     ecx,ebp                 ; Code size
        inc     esi                     ; Increment ESI
        call    WriteCodeLZ77           ; Write the first code
        inc     ebp                     ; Increment the code size
C77_L0: mov     al,[esi+Palette]        ; Load first byte from data stream.
        mov     ecx,esi                 ; Number of bytes to search for match
        cmp     esi,64768               ; Test for the end of the data stream
        jz      near C77_End            ; Jump to the end if we are done
        mov     edi,Palette             ; Start searching at the beginning
        and     dword [RunLength],byte 0; Set the run length to 0
C77_L1: repnz   scasb                   ; Scan for first matching byte
        jnz     C77_P1                  ; If no match, go here
        mov     edx,edi                 ; Position to start scanning.
        sub     edx,Palette
        mov     ebx,esi                 ; Position to read from
C77_L2: inc     ebx
        cmp     ebx,64768               ; Compare with end
        jz      C77_P0
        cmp     edx,esi                 ; Compare with end of thingy
        jz      C77_P0                  ; Lalala
        mov     ah,[edx+Palette]        ; Compare with other character!!!
        inc     edx
        cmp     ah,[ebx+Palette]        ; Load character to compare!
        jz      C77_L2
C77_P0: sub     ebx,esi                 ; Length of run
        cmp     ebx,[RunLength]         ; See if we update the run?
        jb      C77_L1
        mov     [RunLength],ebx
        sub     edi,Palette+1-256       ; Make a proper code offset
        mov     [RunOffset],edi
        add     edi,Palette+1-256
        jmp     short C77_L1
C77_P1: cmp     dword [RunLength],byte 1; Runs of 1 suck a lot.
        jbe     near C77_P2
        mov     ebx,[RunOffset]         ; BlahBlah
        mov     ecx,ebp                 ; Happy small tiny insignificant EBP
        call    WriteCodeLZ77           ; Write the code
        lea     ecx,[esi+255]
        sub     ecx,ebx
        mov     ebx,[RunLength]
        add     ebp,ebx
        add     esi,ebx
        dec     ebx
        dec     ebx
        call    WriteCodeLZ77
        jmp     C77_L0

C77_End:mov     ebx,ebp                 ; The code size must increase, and
        mov     ecx,ebx
        dec     ebx                     ; we need to write the code right
        call    WriteCodeLZ77           ; before the end, elegant solution.


        xor     eax,eax
        mov     edi,Compress2
        mov     ecx,16384
        rep     stosd

        mov     ecx,[CodePosition]
        lea     esi,[ecx*4+(Compress2a-4)]
C77_L3: mov     ebp,[esi]
        mov     ebx,ebp
        shr     ebx,16
        and     ebp,0000FFFFh
        mov     edi,Compress2
        mov     eax,[edi]
        mul     ebx
        add     eax,ebp
        adc     edx,byte 0
        mov     ebp,8191
        mov     [edi],eax
C77_L4: add     edi,byte 4
        xchg    edx,[edi]
        mov     eax,edx
        mul     ebx
        add     [edi],eax
        adc     edx,byte 0
        dec     ebp
        jnz     C77_L4
        sub     esi,byte 4
        dec     ecx
        jnz     C77_L3

        mov     edi,Compress2+65536
C77_L5: dec     edi
        cmp     byte [edi],0
        jz      C77_L5
        sub     edi,Compress2
        mov     [CompressLength],edi        

        popad
        ret

; Call with EBX equalling code, and ECX equalling the size of the maximum
; code that can be written, i.e. the multiplyier.
WriteCodeLZ77:
        pushad
        mov     eax,ebx
        call    WriteNumber
        mov     eax,ecx
        call    WriteNumber

        mov     edi,[CodePosition]
        shl     ecx,16
        and     ebx,0000FFFFh
        inc     edi
        or      ebx,ecx
        mov     [edi*4+Compress2a-4],ebx
        mov     [CodePosition],edi
        popad
        ret

CompressLZW:
        pushad
        mov     ah,80h
        mov     edi,CharTable
        mov     ecx,256
        rep     stosd


        xor     eax,eax
        xor     edi,edi
        xor     ebp,ebp
        mov     [NumCodes],eax
        mov     [Compress],eax
        mov     [CodeSize],dword 9
        mov     [TestSize],dword 512-258

        mov     esi,[HappyOffset]       ; Start of stuff to compress
        lodsb                           ; Load first character..
        mov     ecx,eax                 ; Store old character..

; ESI=pointer to read from buffer.  EBP=bit pos to write to
; EAX=current char (high 24 bits are zero!).
; ECX=last char (high 16 bits are zero!)
; EBX=TraceCode
; EDI=Number of codes

C_L1:   lodsb                           ; Load character into EAX!
        cmp     esi,[HappySize]         ; Compare with end!
        ja      near C_P0               ; And die if end :/
C_P6:   mov     ebx,[CharTable+eax*4]   ; Load TracePointer
        test    bh,80h                  ; See if we need to make a new char..
        jnz     C_P1                    ; Jump if we DO.
C_L2:   cmp     ecx,[CodeTable+ebx*4]   ; Compare LastCode with CodeTable[TraceCode]
        jnz     C_P3                    ; If not, load a new code.
        lea     ecx,[ebx+258]           ; LastCode=TraceCode+258 :)
        mov     dl,al                   ; Save character in DL
        lodsb                           ; Load character
        cmp     esi,[HappySize]         ; Test for overrun..
        ja      near C_P0               ; And read more if we can!
C_P5:   cmp     al,dl                   ; Test for same as old character
        jnz     C_P6                    ; If not, load new TracePointer
C_P3:   mov     edx,ebx                 ; Store TracePointer in EDX
        mov     ebx,[LinkTable+ebx*4]   ; Load LinkTable[TracePointer]
        test    ebx,ebx                 ; Test for end of code sequence.
        jnz     C_L2                    ; If not the end, keep going!
        mov     [LinkTable+edx*4],edi   ; Store current code in pointer table
        jmp     C_P7                    ; And then write and add the code.
C_P1:   mov     [CharTable+eax*4],edi   ; Store First link here..
C_P7:   mov     [CodeTable+edi*4],ecx   ; Store LastCode in CodeTable[NumCodes]
        and     dword [LinkTable+edi*4],byte 0 ; Zero LinkTable

        call    WriteCodeLZW            ; Write code in ECX
        mov     ecx,eax                 ; LastCode=CurrentChar

        inc     edi                     ; Increment Code Table.

        cmp     edi,[TestSize]
        jbe     C_L0
        shl     dword [TestSize],1
        add     dword [TestSize],258
        inc     byte [CodeSize]
        


C_L0:   cmp     edi,3838                    ; Test for end of code table
        jnz     near C_L1                   ; If not the end, loop around.
        mov     ecx,256                     ; Otherwise write code 256, the
        call    WriteCodeLZW                ; horrid clear code.
        mov     [CodeSize],byte 9
        mov     [TestSize],dword 512-258
        

        mov     edi,CharTable+1             ; Clear the firstpointer table
        mov     cl,0
C_L3:   mov     byte [edi],80h              ; into all the high words to
        add     edi,byte 4                  ; specify that they are OFF now.
        dec     cl
        jnz     C_L3
        xor     edi,edi
        mov     ecx,eax
        jmp     C_L1

C_P0:   
        call    WriteCodeLZW
        mov     ecx,257
        call    WriteCodeLZW

        add     ebp,byte 7
        shr     ebp,3
        mov     [CompressLength],ebp
        
        popad
        ret


; EBP=bit position
; ECX=code
; EDX is free, so is EAX.
WriteCodeLZW:
        push    eax             ; Save EAX
;        mov     eax,[CodeSize]
;        call    WriteNumber
;        mov     eax,ecx
;        call    WriteNumber
        mov     edx,ebp         ; EDX=bit position too
        xchg    ecx,ebp         ; ECX=bit position and EBP=code
        shr     edx,3           ; Get byte position in EDX
        and     ecx,byte 7      ; Mask off all but low 7 bits
        shl     ebp,cl          ; Shift this appropriately.
        mov     eax,ebp         ; Make this complete
        or      al,[edx+Compress] ; Load first byte
        lea     ebp,[ecx+edx*8] ; Get EBP back to normal
        mov     [edx+Compress],eax ; Store the new code        
        pop     eax
        add     ebp,[CodeSize]
        ret

WriteNumber:
        pushad
        mov     edi,Stringy+14
        mov     word [edi],' $'
        xor     ebx,ebx
        mov     bl,10
WNL0:   xor     edx,edx
        div     ebx
        add     dl,30h
        dec     edi
        mov     [edi],dl
        test    eax,eax
        jnz     WNL0
        mov     edx,edi
        mov     ah,09h
        int     21h
        popad
        ret

BlitImage:
        pushad
        mov     edx,03C4h
        mov     al,02h        
        out     dx,ax                   ; enable writes to plane register
        inc     edx                     ; Write to next thing..
        dec     eax                     ; Set AL to 1, and write it to mask
        mov     esi,Image               ; all but first channel.
        mov     edi,000A0000h           ; Offset of display.
        mov     ebx,4                   ; Number of dudes to write.
BIL0:   mov     ecx,15999               ; Write one quarter of the display.
        out     dx,ax                   ; Write the mask!
BIL1:   mov     ah,[esi+ecx*4]          ; Load from ESI
        mov     [edi+ecx],ah            ; Write to EDI
        dec     ecx                     ; Decrement pointer!
        jns     BIL1                    ; Jump while above -1
        inc     esi                     ; We increment ESI to catch next plane
        shl     al,1                    ; Shift AL.        
        dec     ebx
        jnz     BIL0

        popad
        ret

DrawPaletteLines:
        pushad
        mov     edx,03C4h
        mov     al,02h
        out     dx,ax
        inc     edx
        mov     al,11h
        xor     ebx,ebx
        mov     edi,000A0000h+80*200
DPLL0:  mov     ecx,40*80
        out     dx,al
DPLL1:  mov     [edi+ecx],bl
        sub     ecx,byte 80
        jns     DPLL1
        inc     ebx
        rol     al,1
        jnc     DPLL0
        inc     edi
        cmp     ebx,256
        jb      DPLL0
        popad
        ret


; Call with BL=interrupt number
; all values are put back into the respective Int_ memory addresses
RealInt:
        push es
        push edi
        push eax
        push ebx
        push ecx
        push ds
        pop es
        mov edi,Int_EDI
        xor ecx,ecx
        and ebx,000000FFh
        mov eax,0300h
        int 31h

        mov cl,13
        mov dword ebx,dword Int_EDI
RIL0:   mov eax,[es:edi]
        mov [ebx],eax
        add edi,byte 4
        add ebx,byte 4
        dec cl
        jnz RIL0

        pop ecx
        pop ebx
        pop eax
        pop edi
        pop es
        ret



; This is the decompression routine for LZW compression.

bits 16
LZWStart:
        mov     al,13h          ; Set video mode!
        int     10h             ; With our friend int 10h!

        mov     dx,03C8h        ; Crazy palette
        xchg    bx,ax           ; Make al zero!
        out     dx,al           ; Write first palette entry now!
        inc     dx              ; Move DX to correct port.
        xchg    di,ax           ; Set DI to zero, we'll write to here.
        push    word 0A000h     ; Address of video memory
        pop     es              ; Set ES to the neat new place
        mov     cx,32000
        rep     stosw

        xor     di,di
LZW_aa: mov     bp,768          ; Number of palette entries to set!  BP is
                                ; decremented before write, so it must be
                                ; 768.  Since we use js
        xor     ebx,ebx         ; Bit position

LZW_L0: call    LZWReadCode     ; This reads an LZW code from the stream.
        cmp     ax,257          ; Test for end of stream.
        jz      near LZWDone    ; If the end, exit
        cmp     ax,256          ; Test for clear code.
        jnz     LZW_P0          ; If not, continue.
        mov     byte [LZWCodeSize-LZWFix],9     ; New code size
        mov     byte [LZWNextCode-LZWFix+1],4   ; New end of code size,
                                                ; equal to 1024, since the
                                                ; low byte is already 0
        mov     byte [LZWCodeMask-LZWFix+1],1   ; The low 8 bits are all 1.
        mov     word [LZWNumCodes-LZWFix],258   ; Set the number of codes
        call    LZWReadCode                     ; back to 258 and read the
        mov     ch,al                           ; next code, write it into
        mov     si,ax                           ; SuffixChar and LastCode
        stosb                                   ; Also write it to the screen
        jmp     short LZW_L0                    ; (assuming that we will
                                                ; never get a clear code
                                                ; before we've finished
                                                ; reading the palette

LZW_P0: push    ax                              ; Save the current code
        push    bx                              ; Save the current bitpos
        mov     bx,LZWStack                     ; Set BX up as the stackpoint
        cmp     ax,[LZWNumCodes-LZWFix]         ; See if this is a code not
        jb      LZW_P1                          ; yet in our table (a run of
        mov     ax,si                           ; the last color).  If so,
        mov     [bx],ch                         ; handle this appropriately.
        inc     bx                              ; I forget exactly why this
LZW_P1: push    di                              ; stuff works, it's in GIF.
LZW_L2: cmp     ah,1                    ; This line tests to see if the code
        jb LZW_P2                       ; is a character or a real code.  All
        xchg    di,ax                   ; chars are below 256, all codes 
        mov     al,[di+LZWCharTable]    ; are above.  This code takes the
        mov     [bx],al                 ; suffix char of the code pointed to
        inc     bx                      ; and adds it to the stack.  It
        shl     di,1                    ; then replaces the current code
        mov     ax,[di+LZWCodeTable]    ; with the code from the code pointed
        jmp     short LZW_L2            ; to and loops to check again.
LZW_P2: mov     [bx],al                 ; Write the very last character
        mov     ch,al                   ; Save first char written in this 
        inc     bx                      ; block of chars, it's the SuffixChar
        pop     di                      ; Restore DI from above as pointer to
LZW_L1: dec     bx                      ; Decrease stack pointer
        mov     al,[bx]                 ; Read byte from stack
        push    bx
        mov     bx,1                    ; Make this 1
        cmp     al,211                  ; Above this, it's a neat thing
        jb      LZW_P6
        cmp     al,241
        jb      LZW_P5
        mov     bl,al
        sub     bl,240
        jmp     short LZW_P4
LZW_P5: mov     bl,al
        sub     bl,210
        shl     bx,4       
LZW_P4: mov     al,0
LZW_P6: dec     bp                      ; video memory.  Dec BP for test of
        js      LZW_P3                  ; end of palette
LZW_xx: out     dx,al                   ; And write it to the pallete or
LZW_ee: dec     bx
        jnz     LZW_P4
        pop     bx
        cmp     bh,0C0h                 ; screen.
        ja      LZW_L1                  

        mov     bx,[LZWNumCodes-LZWFix]
        mov     [bx+LZWCharTable],ch    ; Write first char of this block
        inc     bx                      ; What we do here is write the last
        mov     [LZWNumCodes-LZWFix],bx ; code that was actually added.
        shl     bx,1                    ; The current new code will be written
        mov     [bx+LZWCodeTable-2],si  ; on the next pass!
        cmp     bx,[LZWNextCode-LZWFix]
        pop     bx
        pop     si                      ; Old code equals the code we just
        jb      near LZW_L0                ; finished processing.  It will be
        inc     byte [LZWCodeSize-LZWFix]  ; The base code written into
        shl     word [LZWNextCode-LZWFix],1; the new code next pass.
        shl     word [LZWCodeMask-LZWFix],1
        inc     word [LZWCodeMask-LZWFix]
        jmp     LZW_L0

LZW_P3: inc     bp                      ; Keep BP from ever becoming positive.
        stosb                           ; Store the byte to the screen
        jmp     short LZW_ee            ; And return to the happy thing


LZWDone:mov     ah,0                            ; Clean keypress
        int     16h                             
        mov     ax,3                            ; Restore clean screen
        int     10h                             ; Then we read one last
                                                ; (non existant) code, and
                                                ; RET to DOS
LZWReadCode:                                    
        mov     cl,bl
        shr     ebx,3
        mov     eax,[bx+LZWEnd-LZWFix]
        and     cl,7
        shr     eax,cl
        and     ax,[LZWCodeMask-LZWFix]
        shl     ebx,3
        add     bl,cl
        add     ebx,[LZWCodeSize-LZWFix]
        ret


LZWCodeSize     DD      9
LZWNextCode     DW      1024
LZWCodeMask     DW      511
LZWNumCodes     DW      257

LZWEnd:

LZWFix          EQU     LZWStart-100h

LZWSuffixChar   EQU     0C0FEh
LZWEndOfCode    EQU     (LZWEnd-LZWStart)+100h
LZWStack        EQU     0C0FFh
LZWCodeTable    EQU     0D000h
LZWCharTable    EQU     0B000h




; This is the decompression routine for LZ77 compression.

LZ77Start:
        mov     al,13h
        int     10h
        mov     di,64768        ; Set DI to zero, we'll write to here.
        mov     si,di           ; This needs to be at DI too
        push    word 0A000h     ; Address of video memory
        pop     es              ; Set ES to the neat new place
        mov     bp,257          ; This is the code size
LZ77L1: call    LZ77Read        ; Woohoo!
        cmp     ax,256          ; See if this is a byte!
        ja      LZ77P0
        stosb
        inc     bp
        jmp     short LZ77L1
LZ77P0: inc     ax              ; Increment AX for fun!
        cmp     ax,bp           ; And to see if we're done :)
        jae     LZ77P1          ; If so, go away
        sub     ax,257+768      ; Make this a normal offset friend
        xchg    bx,ax           ; Put it into BX
        push    bp
        lea     bp,[di+767-768] ; Real offset of DI
        sub     bp,bx           ; Get size thing
        call    LZ77Read        ; Read next code which is length!
        xchg    cx,ax           ; Number of bytes to copy!
        inc     cx
        inc     cx
        pop     bp
LZ77L2: mov     al,[es:bx]      ; Load thingy
        inc     bx              ; And increment BX
        inc     bp
        stosb                   ; Store the byte
        dec     cx
        jnz     LZ77L2          ; Now store it happily.
        jmp     short LZ77L1

LZ77P1: mov     dx,03C8h
        mov     al,0
        out     dx,al
        inc     dx
        push    es
        pop     ds
        mov     cx,768
        rep     outsb
        mov     ah,0
        int     16h
        mov     ax,03h
        int     10h
;        ret
LZ77Read:
        push    dx
        push    di
LZ77xx: mov     di,0DEADh
        xor     dx,dx
LZ77L0: mov     ax,[di]
        div     bp
        mov     [di],ax
        dec     di
        dec     di
        cmp     di,(LZ77End-LZ77Fix)-2
        ja      LZ77L0
        xchg    dx,ax
        pop     di
        pop     dx
        ret


LZ77End:

LZ77Fix         EQU     LZ77Start-100h


bits 32



; End of decompression routine for LZW compression.

section .data
Error0          DB      'Proper usage is SQUISH image.RAW$'
Error1          DB      'Unable to open image file.$'
Error2          DB      'Image is not 320x200 with 768 bytes of palette.$'
Error3          DB      'Cannot create ENTRY.COM$'

CRTCValues      DW 0D06h,3E07h,4109h,0EA10h,0AC11h,0DF12h,0014h,0E715h,0616h
                DW 0E317h

CRLF            DB 13,10,'$'

NewFileName     DB      'ENTRY.COM',0

section .bss


CodeTable       RESD 3838
LinkTable       RESD 3838
CharTable       RESD 256
NumCodes        RESD 1

Int_EDI         RESD 1
Int_ESI         RESD 1
Int_EBP         RESD 1
Int_Reserved    RESD 1
Int_EBX         RESD 1
Int_EDX         RESD 1
Int_ECX         RESD 1
Int_EAX         RESD 1
Int_Flags       RESW 1
Int_ES          RESW 1
Int_DS          RESW 1
Int_FS          RESW 1
Int_GS          RESW 1
Int_IP          RESW 1
Int_CS          RESW 1
Int_SP          RESW 1
Int_SS          RESW 2

argc            RESD 1
argv            RESD 1
env             RESD 1
CompressLength  RESD 1
Compress2Length RESD 1
TestSize        RESD 1
CodeSize        RESD 1
Stringy         RESB 16
CodePosition    RESD 1
RunLength       RESD 1
RunOffset       RESD 1
NumberOfColors  RESD 1
HappyOffset     RESD 1
HappySize       RESD 1

PaletteTable    RESD 256
Palette         RESB 768
Image           RESB 64000
Compress        RESB 65536
Compress2       RESB 65536
Compress2a      RESD 100000
