;                       BrainFuck by Tom
;                     E-mail: bojcan@buli.net
; Size: 157 bytes

[ORG 0x100]
[BITS 16]
[SECTION .text]

start           mov ch,0xc3        ;(2)
                mov di,1000        ;(3)
                rep stosb          ;(2)

                shr si,1           ;(2)
                lodsb              ;(1)
                xchg bx,ax         ;(1)
                mov [bx+si],al     ;(2)

                mov dx,0x82        ;(3)
                mov ah,0x3d        ;(2)
                mov di,ax          ;(2)
                int 0x21           ;(2)

                xchg bx,ax         ;(1)
                mov dh,0x04        ;(2)
                mov ah,0x3f        ;(2)
                dec cx             ;(1)
                int 0x21           ;(2)
;---------------------------------------------------------------------------
INTERPRETER     mov si,dx          ;(2)

INT_START       lodsb              ;(1)
                test al,al         ;(2)
                jz start+1         ;(2)

                mov ah,0x06        ;(2)
                xor dx,dx          ;(2)
                mov cx,dx          ;(2)
                dec dx             ;(1)

                cmp al,'<'         ;(2)
                jne INT_1          ;(2)
                dec di             ;(1)
                dec di             ;(1)

INT_1           cmp al,'>'         ;(2)
                jne INT_2          ;(2)
                scasw              ;(1)

INT_2           cmp al,'+'         ;(2)
                jne INT_3          ;(2)
                inc word [di]      ;(2)

INT_3           cmp al,'-'         ;(2)
                jne INT_4          ;(2)
                dec word [di]      ;(2)
;-----------------------------------------------
INT_4           cmp al,'.'         ;(2)
                jne INT_5          ;(2)

                mov dl,[di]        ;(2)
                cmp dl,0x09        ;(2)
                je TEMP_1          ;(2)
                mov ah,0x02        ;(2)
                cmp dl,0x0a        ;(2)
                jne TEMP_1         ;(2)
                mov dl,0x0d        ;(2)
                int 0x21           ;(2)
                mov dl,0x0a        ;(2)
TEMP_1          int 0x21           ;(2)
                xchg ax,cx         ;(1)
;------------------------------------------------
INT_5           cmp al,','         ;(2)
                jne INT_6          ;(2)
                int 0x21           ;(2)
                jz EOF             ;(2)
                cmp al,0x0d        ;(2)
                jne TEMP_2         ;(2)
                int 0x21           ;(2)
TEMP_2          mov ah,cl          ;(2)
                mov [di],ax        ;(2)
                jnz INT_START      ;(2)
EOF             mov [di],dx        ;(2)
;------------------------------------------------
INT_6           cmp al,'['         ;(2)
                jne INT_START      ;(2)

                mov dx, si         ;(2)
                inc cx             ;(1)
TEMP_4          lodsb              ;(1)
                cmp al,'['         ;(2)
                jne TEMP_5         ;(2)
                inc cx             ;(1)
TEMP_5          cmp al,']'         ;(2)
                jne TEMP_6         ;(2)
                dec cx             ;(1)
TEMP_6          jnz TEMP_4         ;(2)

                dec si             ;(1)
                mov byte [si],cl   ;(2)
                push si            ;(1)

TEMP_7          cmp word [di],cx   ;(2)
                je TEMP_8          ;(2)
                push dx            ;(1)
                call INTERPRETER   ;(3)
                pop dx             ;(1)
                jmp short TEMP_7   ;(2)

TEMP_8          pop si             ;(1)
                mov byte [si],']'  ;(3)
                jmp short INT_START ;(2)