; 
;		     100 byte BF interpreter by TAD 1999
; 	  	Thanks to Ruud for the tip about using FCB's
;		   and all the other 100 bytes of code #;o)
; 
	.model tiny
	.code
	org 256
start:
	;
	; assumes:
	;	bx=0000	  si=0100   di=FFFE  0D7A < dx < 4E06
	;

	push	dx
	mov	ah,1Ah			; set DTA --> DS:DX
	int	21h
	mov	ax,5C0Fh		;# this gives DX=005C, AX=0F00
	mul	si			;#
	int	21h			; open FCB
	sub	[bx+6Bh],dl		; record-size = A480 bytes
	mov	ah,27h
	int	21h			; Read FCB/clear upto A480 bytes
	pop	si
	;
	; ax=2703  cx=0001   si--> Brf program
	;

	;
	; Modified version of Ruud's "scasw & sub di,ax" method 
	; for the '<' and '>' commands.  This is more flexible in terms
	; of the initial value of DX, it can be upto around 4E06 hex
	; instead of Ruud's 2700 hex.
	;
incdecptr:
	sub	di,ax
	sub	di,ax
	scasw				; di + 2 - ax - ax

mainloop:
	sub	al,']'			; ']' ?		ax=0000
	jnz	short no1
	jcxz	short noloop		; don't loop if cx=0000
	pop	si
	dec	si			; else jump back to '['
noloop:
	pop	cx			; restore parent enable flag

	;
	; This is used by the '+' and '-' commands, because ax=0000
	; from the above sub al,']' code it is safe to keep it here.
	;
submem:	sub	[di],ax

	;
	; Thanks again to Ruud, for this nice way to make BX=0001 when
	; CX=0001, the BX is used in the 'putchar' code.
	;
no1:
	push	cx			; store the enable flag
	sub	al,'['-']'		; '[' ?		ax=0000
	jnz	short popbx
	push	si			; keep address of '['+1
	cmp	[di],ax
	jnz	short nopopbx		; is [p] <> 0000 ?
	xchg	ax,cx			; else cx=0000, pop si
popbx:
	pop	bx
nopopbx:

	;
	; We only check the other commands < > , . - + if cx=0001
	; otherwise we are inside a false [..] loop or sub-loop.
	;

	jcxz	short next		; if cx=0000 then ignore '<>,.-+'

					; we could use "MUL CX" here instead
					; it would make DX=0000 for free.

	sub	al,'<'-'['		; '<' or '>' ?
	test	al,NOT 2
	jz	short incdecptr		; ax=0000 or ax=0002

	sub	al,'+'-'<'		;  +  ,  -  .
	cmp	al,3 			;  0  1  2  3
	ja	short next
	jz	short putchar		; '.' ?
	dec	ax
	jnz	short submem		; '+' or '-' ?		ax=-1 or +1
	mov	[di],ax			; ',' clear high-byte 'getchar'
	dec	bx			; bx=0000
putchar:
	cmp	byte ptr [di],0Ah
	jnz	short togs
rwloop:
	xor	byte ptr [di],7		; tog 0A --> 0D or 0D --> 0A
togs:
	mov	dx,di
	mov	ah,3Fh			;   if ','	AH=3F, BX=0000
	add	ah,bl			; else '.'	AH=40, BX=0001
	int	21h
	dec	ax			;# deal with EOF (ax=FFFF)
	or	[di],ax			;# else ax=0000
	cmp	byte ptr [di],0Dh
	jz	short rwloop		; did we read/write a 0D char ?
next:
	lodsb

	;
	; This is the only line which I managed to code myself #;o)
	; it zero-extends AL to AX, and tests whether AL is 0.
	;
	aad	0		; opcode D5 00 hex

	jnz	short mainloop
	ret			; exit via CS:0000 --> INT 20h

	end	start
