;-----------------------------------------------------------------------------
;------ ENTRY.ASM : 'Brainfuck' interpreter: entry for 6th Hugi size    ------
;------              coding competition, written by Dan Parsonson 02/99 ------
;------              Compiled size: 195 bytes, using TASM 5.0           ------
;------              Version 1.1 - a little smaller than v1.0           ------
;------                                                                 ------
;------ E-Mail: big_mr_ed@hotmail.com                                   ------
;-----------------------------------------------------------------------------
;------ Note: (**) indicates fixup for TASM bug                         ------
;------       (***) try taking this line out and running testit.bat     ------
;------             three times in a row                                ------ 
;-----------------------------------------------------------------------------

code           segment para
               assume  cs:code,ds:code
               org 100h
               .486

Start:

               mov     ah,03Dh              ; open file; read only, no sharing
               db      08Ah, 01Eh, 080h, 00h     ; mov     bl,[080h] (**)
               mov     byte ptr [bx + 81h],al    ; => ASCIIZ string
               mov     dx,082h              ; can't use dl here; why not ?

               int     21h

; Note that this assumes that a .B filename has been supplied

               xchg    bx,ax                ; bx is now handle
               mov     ah,03Fh              ; read from file
               mov     cx,Code_Size         ; max. bytes to read
               mov     dx,offset Code_Buf
               int     21h

               xchg    di,ax                ; di = # bytes read
               xor     ax,ax
               mov     [di + offset Code_Buf],al
                                            ; terminate code properly
               mov     di,offset Data_Buf
               mov     bp,di                ; for later use
               rep stosw                    ; DF assumed to be clear

               mov     gs,ax                ; gs not always 00h ? (***)
               xchg    ax,bx                ; bx = 00h
               inc     cx
               mov     si,di                ; si -> Code_Buf

Interpret      proc    near

I_Main_Loop:

               mov     di,gs                ; data pointer

               xor     ax,ax
               lodsb
               sub     al,'+'
               je      short I_Inc_Data
               dec     ax                   ; ','
               je      short I_Inp_Data
               dec     ax                   ; '-'
               je      short I_Dec_Data
               dec     ax                   ; '.'
               je      short I_Out_Data
               cmp     al,'<' - '.'
               je      short I_Dec_Ptr
               cmp     al,'>' - '.'
               je      short I_Inc_Ptr
               cmp     al,'[' - '.'
               je      short I_Do_Loop

I_Not_Exec:            

               mov     gs,di                ; data pointer

I_Not_Exec_2:

               cmp     [si],bl              ; end of code ? (bl = 00h)
               jne     short I_Main_Loop

               ret

I_Inc_Ptr:

               add     di,04h

I_Dec_Ptr:

               dec     di
               dec     di
               jmp     short I_Not_Exec          ;  0...(Data_Size * 2)

I_Inc_Data:

               add     word ptr [di + bp],02h

I_Dec_Data:

               dec     word ptr [di + bp]
               jmp     short I_Not_Exec

IID_EOF_CR:

               mov     di,offset Data_Temp - offset Data_Buf
                                            ; remove CR/LF from stdin
I_Inp_Data:                                 ;  otherwise => problems !

               mov     ah,03Fh
               mov     dx,offset Read_Byte
               int     21h
               mov     word ptr [di + bp],0FFFFh
               or      ax,ax                ; EOF ?
               jz      short I_Not_Exec_2
               db      0B0h                 ; mov al,....
Read_Byte      db      00h
               cmp     al,01Ah              ; Ctrl-Z
               je      short IID_EOF_CR
               cmp     al,0Dh
               je      short I_Inp_Data     ; convert (0Dh, 0Ah) to (0Ah)
               mov     [di + bp],ax

IID_Done:

               jmp     short I_Not_Exec_2

I_Out_Data:

               cmp     byte ptr [di + bp],0Ah
               jne     IOD_Do_Write

               mov     dl,0Dh
               mov     ah,06h
               int     21h

IOD_Do_Write:

               inc     bx
               mov     ah,40h
               mov     dx,di
               add     dx,bp
               int     21h                  ; write 1 byte to stdout
               dec     bx

               jmp     short I_Not_Exec

I_Do_Loop:

               inc     bx                   ; bx = 00h already
               mov     es,si                ; save it for later

IDL_Nest_Loop:

               lodsb

               inc     bx
               cmp     al,'['
               je      short IDL_Nest_Loop
               dec     bx
               cmp     al,']'
               jne     short IDL_Nest_Loop

IDL_Nest_Loop_2:

               dec     bx
               jnz     short IDL_Nest_Loop

               mov     [si - 01h],bl        ; = 00h

IDL_Start_Loop:

               mov     ax,[di + bp]
               or      ax,ax                ; loop counter
               jz      short IDL_End_Loop
               push    si
               push    es
               mov     si,es
               call    Interpret
               pop     es
               pop     si
               jmp     short IDL_Start_Loop

IDL_End_Loop:

               mov     byte ptr [si - 01h],']'

               jmp     short IID_Done

Interpret      endp

Data_Size      EQU     10000
Code_Size      EQU     Data_Size
Data_Buf       dw      Data_Size dup (?)
Code_Buf       db      Code_Size + 01 dup (?)
Data_Temp      dw      ?                    ; junk buffer

code           ends

               end     Start
