;
; Neon/Spetsnaz' entry for the Hugi Size Coding Competition #6 (Brainfuck interpreter)
;
; Date: 1999/01/26
; Size: 161 bytes
;
; Compile with "tasm /m3 neon.asm"
; Link with "tlink /t neon.obj, entry.com"

; Set DEBUG to 1 for debugging
DEBUG = 0
                .586
                Ideal
                Model     Tiny
                CodeSeg
                StartupCode
                ; Clear databuf
IF DEBUG EQ 1
                mov     cx,40FFh
ELSE
                mov     ch,40h
ENDIF
                mov     di,cx
                push    di
                rep stosw

                mov     si,80h
                lodsb
                add     si,ax
                mov     [si],ah

                mov     ax,3D00h
                mov     dx,82h
                int     21h
                mov     bx,ax

                mov     ah,3Fh
                mov     cx,ax
                mov     dh,90h
                push    dx
                int     21h
                ; Close file? Nope :)

; register setup
; ax,bx,cx,dx - character input
; ax,dl - character output
;
; si = instruction pointer
; di = data pointer
; al = instruction
; bx = 0

                pop     si
                pop     di
                xor     bx,bx
                ;lodsb
                ;dec     si
MainLoop:
MainLoop2:
                ;lodsb
                mov     al,[si]
                test    al,al
                jz      Quit
                cmp     al,'+'
                jne     NotIncData
                inc     [word di]
NotIncData:
                cmp     al,'-'
                jne     NotDecData
                dec     [word di]
NotDecData:
                cmp     al,'<'
                jne     NotDecPtr
                dec     di
                dec     di
NotDecPtr:
                cmp     al,'>'
                jne     NotIncPtr
                inc     di
                inc     di
NotIncPtr:
                cmp     al,','
                jne     NotInput
ReadAgain:
                mov     ah,3Fh
                xor     cx,cx
                inc     cx
                mov     dx,di
                mov     [di],bx
                int     21h
                mov     ax,[di]
                test    ax,ax
                jne     NotEOF
IsEOF:
                mov     [word di],0FFFFh
                jmp     NotInput
NotEOF:
                cmp     al,0Dh
                je      ReadAgain
                cmp     al,26
                je      IsEOF
                xor     ax,ax
NotInput:
                cmp     al,'['
                jne     NotBegLoop
                cmp     [word di],bx
                jne     DoLoop
                ; Scan for matching ']'
ScanLoop:
                lodsb
                cmp     al,'['
                jne     ScanNoLeft
                inc     bx
ScanNoLeft:
                cmp     al,']'
                jne     ScanLoop
                dec     bx
                jnz     ScanLoop
                jmp     MainLoop2
DoLoop:
                push    si
NotBegLoop:
                cmp     al,']'
                jne     NotEndLoop
                pop     si
                dec     si
NotEndLoop:
                cmp     al,'.'
                jne     NotOutput

                mov     dl,[di]
                mov     ah,02h
                cmp     dl,0Ah
                jne     NotEnter
                mov     dl,0Dh
                int     21h
                mov     dl,0Ah
NotEnter:
                int     21h
NotOutput:
                ;lodsb
                inc     si
                jmp     MainLoop
Quit:
                ret
; Brainfuck code
                org     40FFh
label DataBuf word
                ;org     $+10000*2
                org     9082h
label ProgramBuf byte
; Brainfuck data
              end
