 ;""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ; Brainfuck interpreter for the 6th HUGI compo  --  by Jibz^q!p '99 ;
 ;                                                                   ;
 ;   - Fixed Ruud's code and used most of it (sorry ;)..             ;
 ;   - Finally decided to take a look at FCB's .. paid off :)        ;
 ;...................................................................;

.model tiny
.486
.code
org 100h

start:
      mov    dh, 56h              ; dx = around 5600h
      mov    si, dx               ; si -> 5600h
      shr    di, 1                ; di = 7fffh
      mov    ah, 1ah              ; set DTA address to 5600h
      int    21h

      mov    dx, 5ch              ; dx -> FCB of first argument
      mov    ah, 0fh              ; open file using FCB
      int    21h

      mov    ds:[005ch+0eh], di   ; set record size to 7fffh

; Since the DTA address is 5600h, and the record size is 7fffh, when
; we read a record from the bf source file, it will be a partial record
; no longer than 10000 bytes (ie. it will end before 7fffh), and DOS will
; zero-fill the rest of the 7fffh record size. This rest is around 5600h,
; which is more that 20000 bytes, and hence well suited as data[].. Luckily
; di allready contains 7fffh, and can be used as a pointer :)

      mov    ah, 14h              ; read from file to DTA
      int    21h                  ; partial read => al = 3

      mov    cl, 1                ; cx = 1

interpret:
      cmp    al, '['
      jne    not_while
      push   cx                   ; push flag for this loop
      cmp    [di], cx             ; should we do the loop ??
      sbb    cl, ah               ; flag for next loop
      jz     not_while            ;
      push   si                   ; save pointer if executing
not_while:
      cmp    al, ']'
      jne    not_endwhile
      jcxz   skip_level           ; pop flag only if not executed
      pop    si                   ; restore pointer to start of loop
      dec    si
skip_level:
      pop    cx                   ; pop flag

not_endwhile:
      jcxz   test_end             ; skip commands if flag = 0

      cmp    al, '>'
      jne    not_next
      scasw                       ; add di, 2

not_next:
      cmp    al, '<'
      jne    not_prev
      dec    di
      dec    di

not_prev:
      mov    dx, di               ; dx -> data[dp]

      sub    al, '+'              ; '+,-.' are now 0, 1, 2 and 3
      cmp    al, 3
      jne    not_putchar          ; '.' ??

      pusha                       ; save bx and cx
      inc    bx                   ; bx = 1 = handle of stdout
      cmp    byte ptr [di], 0ah   ; 0ah -> 0dh 0ah ??
      jne    not_lf
      lea    dx, CRLF             ; dx -> 0dh 0ah at end of file
      inc    cx                   ; cx = 2
not_lf:
      mov    ah, 40h              ; write to file
      int    21h                  ; write ok => CF = 0
      popa                        ; bx = 0 and cx = 1 again

not_putchar:
      dec    ax
      jnz    not_getchar          ; ',' ??

get_more:
      mov    ah, 3fh              ; read from file (here 1b from stdin)
      int    21h
handle_input:
      dec    ax                   ; -1 => no more data
      js     write_it             ; no more data ??
      mov    al, [di]             ; get byte and zero extend it
write_it:
      mov    [di], ax             ; write zero extended byte or -1
      xor    al, 0dh              ; like cmp here, but sets CF = 0
      jz     get_more             ; if 0dh then 0ah must follow

not_getchar:
      jnc    not_plus_minus       ; not '+' or '-'

      sub    [di], ax             ; ok at this point...

not_plus_minus:
test_end:
      lodsb                       ; get next bf command
      cbw
      test   ax, ax               ; zero means end of code
      jnz    interpret
      ret

CRLF  db     0dh, 0ah

end start
