;*****************************************************************************
;                  ---=== HUGI SIZE CODING COMPO #6 ===---
;*****************************************************************************
; AUTHOR        : Darkblade - TZT (Tribe 2 Tribe)
; DATE          : 24/01/99
;*****************************************************************************
; INFORMATION   : This relies on a few intial registers
;                 ax = 0000
;                 bp = 0900 (or there abouts)
;  Cmd Effect                               Equivalent in C
;  --- ------                               ---------------
;  +   Increase element under pointer       data[dp]++;
;  -   Decrase element under pointer        data[dp]--;
;  >   Increase pointer                     dp++;
;  <   Decrease pointer                     dp--;
;  [   Start loop, counter under pointer    while(data[dp]) {
;  ]   Indicates end of loop                }
;  .   Output ASCII code under pointer      putchar(data[dp] & 0x00ff);
;  ,   Read char and store ASCII under ptr  data[dp]=(unsigned short)getchar();
;*****************************************************************************
; HISTORY       : 24/01/99  - First Version 147 bytes
;*****************************************************************************
                BITS    16
                ORG     100h

                SECTION .text

;
; MAKE THE COMMAND LINE FILENAME ZERO TERMINATED
;

Start:          mov     di, bp                  ; Using BP as a buffer pointer
Exit:           mov     ch, 0c3h                ; A number bigger than i need
                                                ; Useful for Exit + 1 = ret
                rep     stosb                   ; Clear a big buffer

                mov     bl, 80h                 ; The start of the string
                add     bl, BYTE [ bx ]         ; Get the length of the string
                inc     bx                      ; Get past the string
                mov     BYTE [ bx ], al         ; Zero terminate the string

;
; WE NOW NEED TO OPEN THE FILE - WE DONT CARE WETHER IT OPENS - IT ALWAYS WILL
;
Open:           mov     ah, 3dh                 ; The open command
                mov     dx, 82h                 ; Filename pointer
                int     21h                     ; Open the file

Read:           xchg    ax, bx                  ; Get the file handle in bx
                mov     ah, 3fh                 ; The Read command
                mov     dx, bp                  ; Get a pointer to the buffer
                dec     cx                      ; We want a large value
                int     21h                     ; Read the file


;
; START INTERPRETING THE FILE
;

                mov     si, bp                  ; Get a pointer to the input
                mov     di, OutputBuffer        ; A pointer to the output

Interpret:      lodsb                           ; Get the command in al
                or      al, al                  ; See if we are at the end
                jz      Exit + 1                ; End of the program

;
; IS IT A + COMMAND
;
NotExit:        cmp     al, '+'                 ; Check for a plus
                jnz     NotPlus                 ; Not a plus
                inc     WORD [di]               ; Increase word

;
; IS IT A - COMMAND
;
NotPlus:        cmp     al, '-'                 ; Check for a minus
                jnz     NotMinus                ; Its not a minus
                dec     WORD [di]               ; Decrease the word

;
; IS IT A > COMMAND
;
NotMinus:       cmp     al, '>'                 ; Is it a greater than
                jnz     NotGreater              ; Nope
                inc     di                      ; Increase pointer (smaller to
                inc     di                      ; use inc twice than add di,2

;
; IS IT A < COMMAND
;
NotGreater:     cmp     al, '<'                 ; Is it a less than
                jnz     NotLess                 ; Nope
                dec     di                      ; Decrease pointer
                dec     di

;
; IS IT A [ COMMAND
;
NotLess:
                cmp     al, '['                 ; Is it a loop start?
                jnz     NotLoopStart            ; Nope

                xor     dx, dx                  ; Clear a nesting counter
                push    si                      ; Save the start of the loop
                cmp     WORD [di], dx           ; See if we have finished
                jnz     Interpret               ; Not zero counter
;
; FIND THE CLOSING ] FOR THIS LOOP
;
FindLoopEnd:    cmp     al, '['                 ; Compare with start loop
                jnz     NotLoop                 ; Not another loop
                inc     dx                      ; It is - increase nesting

NotLoop:        cmp     al, ']'                 ; Compare with end loop
                lodsb                           ; Read next command
                jnz     FindLoopEnd             ; Not an end loop

                dec     dx                      ; Decrease nesting level
                jnz     FindLoopEnd             ; Not the matching loop cmd
                pop     dx                      ; Tidy up the stack
                dec     si

;
; IS THIS A ] COMMAND
;
NotLoopStart:   cmp     al, ']'                 ; Compare with loop end
                jnz     NotLoopEnd              ; Not end of loop      
                pop     si                      ; Get the pointer to the loop
                dec     si                      ; Move back to the [ command

;
; IS THIS A , COMMAND
;
NotLoopEnd:     cmp     al, ','                 ; Compare with a comma
                jnz     NotComma                ; Not a comma

                pusha                           ; Store all the current regs
ReadAgain:      mov     ah, 0bh                 ; Read the input
                int     21h                     
                or      al, al                  ; Check for a 0 reply
                jz      SkipRead                ; EOF detected

                mov     ah, 08h                 ; Read the character
                int     21h
                cmp     al, 0dh                 ; Check for a 0dh
                jz      ReadAgain               ; Ignore any of them

                xor     ah, ah                  ; Clear the top of ah
                xchg    ax, cx                  ; Get the value into cx

SkipRead:       mov     WORD [di], cx           ; Store the current value
                popa                            ; Restore the regs


;
; IS THIS A . COMMAND
;
NotComma:       cmp     al, '.'                 ; Check for a .
                jnz     Interpret               ; Nop - go back to the start

                pusha                           ; Store all the regs
                mov     dx, [di]                ; Check the value
                mov     ah, 2                   ; The write command
                cmp     dl, 0ah                 ; Check for a 0a 
                jnz     PrintChar               ; if this is we need 0dh first
                pusha
                mov     dl, 0dh
                int     21h                     ; print extra 0d if necessary
                popa
PrintChar:
                int     21h                     ; print character
                popa

                jmp     Interpret

;
; THE DATA
;
                SECTION .data
                SECTION .bss

Buffer:         resb    1000h
                resb    10001h                  ; For the program

OutputBuffer:   resw    10001                   ; For the data

