; Stefan's Entry For Hugi Size Coding Competition #5 - SORT replacement
;   Version 2.0 - ``50 bytes - where's the problem'' ;-)
;
; o Handles input up to >30000 bytes, no limit in line length, at least
;   one line, may contain any character >= 0Ah, where 0Ah is the line
;   terminator, last input character must be a 0Ah
; o Sort algorithm: don't ask, somewhere around O(n^3). I let the
;   program choose the `smallest' line N times
; o Sorts TEST.TXT in <1 second on a P200, takes _veeery_ long for a
;   file with 15000 empty lines (I estimate ~1/2 day)
; o assumes CLD, BX=0 on startup, and a full 64k segment to play in;
;
; tasm /m entry
; tlink /t entry
; --> 47 bytes.
; could be 1 byte smaller under WinNT ([*] mov dx,020Ah -> mov dh,2),
; and another byte smaller on PPro ([**] jb/mov -> cmovnb)
;
; Have phun,
;   Stefan  <Streu@gmx.de>
;
; Message to Microsoft: why can't I disable case-insensitiveness in
; your SORT? I hate sorting `' between `a' and `b'.


                MODEL   TINY
                CODESEG
                ORG     100h
                P386

; set to 1 for test. This will redirect input from a file, since
; my debuggers can't do that
Debug = 0

; No user serviceable parts below.
Start:
IF Debug
                mov     ax,3D00h                ; who optimizes
                mov     dx,offset Filename      ; debugger code?
                int     21h
                mov     bx,ax
                mov     cx,0
                mov     ah,46h
                int     21h
                xor     bx,bx
                jmp     Go
Filename:       db      'test.txt',0
Go:
ENDIF

;=== pull in 30k file ===
                ; BX = 0 (STDIN_FILENO)
                mov     ah,3Fh
                mov     dx,020Ah        ; [*]   ; address somewhere after code
                mov     cx,760Ah                ; "30218 bytes ought to be
                int     21h                     ; enough for everyone"
                xchg    cx,ax
                ; CX = Length
                ; DX = Address of buffer
                ; DH = 2, DL = 10
                ; AL = 10, CF = 0
                ; If CF=1, you're in trouble anyway

OnceAgain:      mov     di,dx
                push    cx
;=== find minimum line ===
CmpLoop:        jb      FindLF          ; [**]  ; jump not taken first time
                mov     si,di                   ; SI = `minimum' line
FindLF:         repne scasb                     ; skip to EOL
                ; DI = line
                ; SI = minimum line
                pusha
                repe cmpsb                      ; CX is big enough
                popa
                inc     cx
                loop    CmpLoop
;=== print minimum line ===
                ; SI = minimum line
                mov     di,si
                pop     cx
NextChar:       lodsb
                xchg    dx,ax                   ; AH <- 2
                int     21h
                xchg    ax,dx                   ; Under DOS, this puts 10
                                                ; into DL _and_ AL :-(
                cmp     al,10
                loopne  NextChar
                ; AL = 10, DH = 2, DL = 10, CF = 0

;=== remove line from memory ===
                push    cx
                rep movsb                       ; CX is big enough
                pop     cx

;=== next line ... ===
                inc     cx
                loop    OnceAgain               ; if #bytes left != 0:
                                                ;   must have AL=10,CF=0 here
                ret

                END     Start

; don't forget to read the fine print on the back-side of this file.
