; Ŀ
;         -expression evaluator-         
;            123 byte version            
;                                        
;  compiled with tasm 3.2 and /m9 option 
;   linked with tlink 2.0 and /t option  
;                                        
;         code by Klaus & Carsten        
; 

; This is just a translation of INT-E's algorithm into assembler.
; Register usage:
;                 ebx = m
;                 edi = n
;                 ebp = a
;                  cx = d

.model   tiny
.code
.386
         org   100h

         ; assumes ax < 8000h, ecx = 0000????h
Start:
         mov   si,82h               ; si points to 1. commandline-character

;  Calc 
Entry:
         pushad

         xor   ebp,ebp
         xor   ebx,ebx
IBX:
         inc   bx
ZCX:
         xor   cx,cx
ZDI:
         xor   edi,edi

CLoop:
         lodsb                      ; load character
         cwde
         sub   al,'('
         je    Entry                ; if character = '(', call loop again

Digit:
         sub   al,8
         jl    ASMD                 ; if character not in ["0".."9"], jump
         imul  edi,10               ; n = n * 10
         add   edi,eax              ; n = n + digit
         jmp   CLoop

ASMD:
         xchg  eax,ebx              ; eax = m
         jcxz  Multiply             ; if d = 0, multiply
         cdq
         idiv  edi                  ; m = m / n
         jmp   Done
Multiply:
         imul  edi                  ; m = m * n
Done:
         xchg  ebx,eax              ; ebx = m

         add   al,6
         je    ZCX                  ; if al = '*', jump and clear d
         cmp   al,5
         loope ZDI                  ; if al = '/', jump and decrement d
         add   ebp,ebx              ; a = a + m
         dec   ax
         neg   al
         movsx ebx,al               ; if al = '+', m = 0; if al '-', m = -2
         jle   IBX                  ; if al = '+' or '-', jump and increment m

         mov   bx,sp
         mov   [bx],ebp             ; n = a
         mov   [bx+4],si
         popad

         jnp   CLoop                ; if al = ')', jump
;  Calc 

         xchg  edi,eax              ; eax = result
         mov   byte ptr [si],'$'    ; write string-termination-character
         mov   cl,10                ; ecx = 10

Looping:
         cdq
         mov   bp,dx                ; if result negativ, bp = -1
         idiv  ecx                  ; result = result / 10

         xor   dl,dh
         sub   dl,dh                ; dl = abs(dl)
         dec   si
         mov   word ptr [si-1],'0-' ; write sign + digit base
         add   [si],dl              ; add current digit
         or    eax,eax              ; all digits written ?
         jne   Looping              ; if not, jump

         lea   dx,[bp+si]
         mov   ah,9
         int   21h
         ret

end      Start
