; Hugi Size Coding Competition #4 - Calculator by Stefan
;
; Supports +,-,*,/ and parens, as many nesting levels as the stack
; will allow. The rules say that the program must accept being called
; as "entry 1+2 >file", so I assume it is called this way: the
; parameters are expected at 82h with not leading whitespace. Trailing
; whitespace, however, is OK, it terminates the input.
;
; Passes the `test.bat' self test and survived my debugging. Your DOS
; should be 32bit clean (int 21 mustn't alter the 32bit registers).
; DOS 6.xx is good, I don't know about Win90+x.
;
; Boring recursive-descent parser.
;
; tasm /m entry
; tlink /t entry
; -- should give a nice 132 byte executable with lotsa `f's inside
;    (aka operand size prefix)
;
; By Stefan <Streu@gmx.net>

; define this to 1 to get `clean' behaviour for unary operators:
; 5*-2 = -10 and enlarge this thing to 146 bytes. Letting this
; 0 still passes the test.bat self test, but evaluates 5*-2 to -2.
CLEAN_UNARY = 0

                MODEL   TINY
                CODESEG
                ORG     100h
                P386

Start:          mov     si,81h
                call    add_exp

; Print signed number in EBP
                sahf                  ; add_exp put the sign in here
                jns     print_it
                mov     dl,'-' - '0'
                neg     ebp
                call    print_char

print_it:       xchg    ebp,eax

; Print unsigned number in EAX
print_loop:     mov     bl,10         ; EBX[8..31] is still zero
                xor     edx,edx
                div     ebx
                push    dx
                or      eax,eax       ; Why can't DIV set the flags as everyone else does?
                jz      print_no_rec
                call    print_loop
 print_no_rec:  pop     dx
 print_char:    add     dl,'0'
                mov     ah,2
                int     21h
return:         ret

; Parse an <add-exp> pointed to by SI+1
; returns result in ebp
add_exp:        sub     ebp,ebp ; why always xor?
 add_loop:                      ; ZF set == "+", ZF clear == "-"

    ; Parse a <mul-exp> pointed to by SI+1
    ; returns result in eax, mustn't change ebp
    mul_exp:        setz    al   ; Start with EAX=1 or -1
                    cbw
                    add     ax,ax ; clears CF
                    dec     ax
                    cwde

     mul_loop:      inc     si   ; doesn't change CF
                    pushf        ; CF clear == "*", CF set == "/"

        ; Parse a <num-exp> pointed to by SI
        ; returns result in ecx, mustn't change eax,ebp
        num_exp:
IF CLEAN_UNARY
                        cmp     byte ptr [si],'+'
                        je      num_do_inc
                        cmp     byte ptr [si],'-'
                        jne     num_skip_inc
                        neg     eax
         num_do_inc:    inc     si
         num_skip_inc:
ENDIF
            ; Parse a <unm-exp> pointed to by SI
            ; returns result in ecx
            unm_exp:        xor     ecx,ecx
                            cmp     byte ptr [si],'('
                            jne     unm_no_paren
                            push    ebp eax
                            call    add_exp
                            mov     ecx,ebp
                            pop     eax ebp
             unm_loop:      inc     si
             unm_no_paren:
                            movzx   ebx,byte ptr [si]
                            sub     bl,'0'
                            jb      end_unm
                            imul    ecx,10
                            add     ecx,ebx
                            jmp     unm_loop
             end_unm:
            ; end <unm-exp>

        ; end <num-exp>
                    popf
                    jc      mul_divide
                    imul    ecx
                    jmp     mul_ok
     mul_divide:    cdq
                    idiv    ecx
     mul_ok:        sub     byte ptr [si],'*'
                    je      mul_loop
                    inc     bl          ; 0 == '/'
                    stc
                    je      mul_loop

    ; end <mul-exp>
 add_dont_neg:  add     ebp,eax
                lahf                           ; store sign flag for output
                dec     byte ptr [si]          ; result is 0 == '+',
                jns     add_loop               ; 2 == '-', < 0 for EOL
                ret
; end <add-exp>

                END     Start

; Yes, I know about `lodsb' & friends. But I see no place where
; they would fit in here :-(

