MY_CODE SEGMENT PARA 'CODE'
ORG     100h
ASSUME  CS:MY_CODE
START   PROC
.386

B               equ  byte ptr
W               equ  word ptr
D               equ dword ptr

MAIN:           mov si,82h              ; SI -> expression

                mov bl,10               ; ebx = 10

                call PARSE_ADD

                cdq                     ; if (eax=negative) then dl="-"
                and dl,"-"              ; else dl=0
                jz  short POS           ; skip if positive
                    push ax             ; print "-"
                    mov ah,2
                    int 21h
                    pop ax
                    neg eax             ; make it positive
            POS:
                pusha                   ; print eax (recursively)
                sub edx,edx
                div ebx
                add dl,"0"
                or  eax,eax
                jz  short ITS_OVER
                    call POS
       ITS_OVER:mov ah,2
                int 21h
                popa
                ret

;--------------------------------------------

PARSE_ADD:      call PARSE_MUL
    PA_AGAIN:   push eax
                lodsb
                cmp al,"+"
                jb  short GO_BACK
                je  short ADD_IT

        SUB_IT: call PARSE_MUL
                pop ebp
                sub eax,ebp
                neg eax
                jmp short PA_AGAIN

        ADD_IT: call PARSE_MUL
                pop ebp
                add eax,ebp
                jmp short PA_AGAIN

        GO_BACK:dec si
                pop eax
                ret

;--------------------------------------------

PARSE_MUL:      call PARSE_FAK
    PM_AGAIN:   push eax
                lodsb
                cmp al,"*"
                je  short MUL_IT
                cmp al,"/"
                jne short GO_BACK

        DIV_IT: call PARSE_FAK
                pop ebp
                xchg ebp,eax
                cdq
                idiv ebp
                jmp short PM_AGAIN

        MUL_IT: call PARSE_FAK
                pop ebp
                imul ebp
                jmp short PM_AGAIN

;--------------------------------------------

PARSE_FAK:      sub eax,eax             ; eax = 0
                cdq                     ; edx = 0

        NUMBER: lodsb                   ; read the integer
                sub al,"0"
                jc  short NUMBER_END
                imul edx,10
                add edx,eax
                jmp short NUMBER

    NUMBER_END: cmp al,"("-"0"          ; is it a paranthesis ?
                je short PARAN          ; (note that there's never
                dec si                  ; a paranthesis directly after
                xchg edx,eax            ; a number)
                ret

         PARAN: call PARSE_ADD          ; parse everything in the paranthesis
                inc si                  ; throw away the ")"
                ret                     ; give it back

START   ENDP
MY_CODE ENDS
END     START