;:::::::::::::::::::::::::::::::::::::::::::::::::::;
;::::;
;::+* The Hugi Size Coding Compo #4 entry *+::;
;::              By Richard Mitton              ::;
;::                   7/9/98                    ::;
;::                                             ::;
;:: Compile with:                               ::;
;::    tasm /m4 entry                           ::;
;::    tlink /t /x entry                        ::;
;::                                             ::;
;:: Please send all questions/complaints/etc to ::;
;::                                             ::;
;::         richard@farout.demon.co.uk          ::;
;::::;
;:::::::::::::::::::::::::::::::::::::::::::::::::::;

.model tiny
.code
.386
org 100h
start:
; Registers are:
;  AX=0000h, BX=0000h, direction flag is clear
;  CX=the size of the .COM file (0000h when in a debugger)
;  SI=0100h (0000h when in a debugger)
;  DI=FFFEh (0000h when in a debugger)
;  SP=FFFEh
;  CS=DS=ES=SS

   mov di, cx        ; point the output buffer to the end of our program
                     ; it won't matter if we corrupt the end bit because
                     ; it will already have executed by the time we come
                     ; to display the answer

   lea ebp, [bx+10]  ; set the base - BX is zero, so EBP now is 10
   mov si, 82h       ; get command-line start (after length-byte and space)

; SI=expression (CR terminated)
; result will always be in EBX
   call add_exp

; display final number in EBX
; DI still points to the output buffer
   std            ; work backwards from the end

   mov ax, (02 shl 8) + '$'    ; store string terminator
   stosb

   or ebx, ebx
   jns display_number

   neg ebx        ; AH=2 from above
   mov dl, '-'    ; print a '-' at the start
   int 21h

display_number:
   xchg eax, ebx
   xor edx, edx
   div ebp
   xchg eax, ebx

   ; DH will always be zero, and DL will always be from 0->9
   xchg ax, dx
   add ax, (9 shl 8) + '0'
   ; as AH was zero before, AH now is 9
   stosb

   or ebx, ebx
   jnz display_number

; now go back and display the output in reverse order

   ; AH is still 9
   lea dx, [di+1]
   int 21h

unm_not_digit:
   dec si         ; It doesn't matter if we do this before quitting
   ret                                      

; this is the recursive expression parser from here onwards

add_exp:
   call mul_exp
   xchg ebx, eax  ; eax=answer
add_repeat:
   push eax       ; preserve first number
   cmp byte ptr [si], '+'
   jb popebx_ret  ; the only things below '+' will be CR and ')'

   lodsb          ; skip '+/-' symbol
   pushf          ; save state of whether it's a '+' or '-'
   call mul_exp   ; get second number
   popf           ; restore state
   pop eax        ; recall first number
   je not_subtract ; if '+', skip the next bit

   neg ebx        ; if '-', then do eax=first+(-second)
not_subtract:
   add eax, ebx   ; eax=first+second
   jmp add_repeat

decsi_popebx_ret:
   dec si
popebx_ret:
   pop ebx
   ret

mul_exp:
   call num_exp
   xchg ebx, eax  ; eax=answer
mul_repeat:
   push eax       ; preserve first number
   lodsb

   cmp al, '*'
   jne mul_not_mul

   call num_exp   ; get second number
   pop eax        ; recall first number
   imul ebx       ; eax=first*second
   jmp mul_repeat

mul_not_mul:
   cmp al, '/'
   jne decsi_popebx_ret

   call num_exp   ; get second number
   pop eax        ; recall first number
   cdq
   idiv ebx       ; eax=first/second
   jmp mul_repeat

num_exp:
   lodsb
   cmp al, '+'
   je unm_exp

   cmp al, '-'
   jne decsi_unm_exp

   call unm_exp
   neg ebx        ; negate the answer
   ret

decsi_unm_exp:
   dec si         ; if there was no '+/-', then we need to go back to the
                  ; previous character.
unm_exp:
   xor eax, eax
   mov ebx, eax

unm_get_digit:
   lodsb
   cmp al, '('
   je unm_bracket

   ; this bit doesn't test for AL being higher than '9'
   ; this relies on '9' having a higher ascii value than +,-,*,/,etc

   sub al, '0'
   jb unm_not_digit

   imul ebx, ebp     ; ebx=ebx*base

   add ebx, eax
   jmp unm_get_digit

;unm_not_digit:   ; This function has been overlayed with the final RET
;;;;dec si        ; at the end of the program.
;;;;ret           

unm_bracket:
   call add_exp
   lodsb    ; skip ')'
   ret

end start
