 ;"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ;  tinyEXP for the HUGI competition :)  --  by Jibz '98                    ;
 ;                                                                          ;
 ;   - This code is inspired by iopl3's C-code, *sigh* ;)                   ;
 ;   - Uses int21h/02h in a recursive loop to print digits to stdout.       ;
 ;   - Seems to be able to parse expressions like 2-+-+2 too ;)             ;
 ;..........................................................................;

.model tiny
.486
locals
jumps
codeseg
org 100h

start:
    mov     si, 82h       ; - point to the command-line
    cld
    call    add_exp

    ; we've got the result now, so write it to stdout
    test    ebp, ebp
    jns     result_unsigned
    mov     dl, '-'
    call    write_digit   ; - write out a '-'
    neg     ebp
result_unsigned:          ; - now ebp contains the unsigned result

    xor     ebx, ebx
    mov     bl, 10
    xchg    eax, ebp

write_int:
    xor     edx, edx
    idiv    ebx
    add     dl, '0'
    test    eax, eax
    jz      write_digit
    push    dx
    call    write_int
    pop     dx
write_digit:
    mov     ah, 02h
    int     21h
    ret

add_exp:
    call    mul_exp
more_add:                 ; - since we have called mul_exp before we get
    lodsb                 ;   here, the next character is NOT (, ), *, /
    cmp     al, '+'       ;   or a digit.. (it can only be +, - or EOD)
    jb      ret_offs      ; - sort out EOD, and find out if it's + or -
    pushf
    push    ebp
    call    mul_exp
    pop     eax
    popf
    je      plus
    neg     ebp
plus:
    xadd    ebp, eax
    jmp     more_add

mul_exp:
    call    num_exp
more_mul:                 ; - since we have called num_exp before we get
    lodsb                 ;   here, the next character is NOT (, ) or a
    test    al, al        ;   digit.. (it can only be +, -, *, / or EOD)
    jpe     dec_ret_offs  ; - sort out +, - and EOD (00h)
    cmp     al, '*'
    jb      dec_ret_offs  ; - sort out EOD (0dh), and find out if it's *
    pushf                 ;   or /
    push    ebp
    call    num_exp
    pop     eax
    popf
    jne     divide
    imul    ebp, eax
    jmp     more_mul
divide:
    cdq
    idiv    ebp
    xchg    eax, ebp
    jmp     more_mul

num_exp:
    lodsb                 ; - the next character is NOT ), *, / or EOD
    cmp     al, '+'       ;   (it can only be (, +, - or a digit)
    je      num_exp       ; - I am calling and jumping back to num_exp
    cmp     al, '-'       ;   instead of forward to unm_exp in order to
    jne     not_un_minus  ;   avoid the lodsb. Funny enough, this has
    call    num_exp       ;   the added effect of being able to parse
    neg     ebp           ;   expressions like 2-+-+2 ;)
    ret
not_un_minus:
    jb      add_exp
    xor     ebp, ebp
read_digit:
    imul    ebp, 10
    and     eax, 0fh
    add     ebp, eax
    lodsb
    cmp     al, '0'
    jae     read_digit
dec_ret_offs:
    dec     si
ret_offs:
    ret

end start
