.model tiny
.586

.CODE
	ORG 100h
PROGRAM_STARTS_HERE:

  MOV   AL, 03h    ; Set video mode 3h
  INT   10h

  MOV   BP, 0202h
  XOR   SI, SI
  MOV   DI, 1800h



	; { MAIN LOOP

MAINLOOP:

    MOV   BL, 0Ah
    PUSH  OFFSET GO_QUI

  UPDATE_BARS:
    MOV   AX, 09DBh      ; Draw Bar1
    MOV   DX, SI
    MOV   CL, 10
    CALL  IO_FUNC        ; WRITE

    MOV   DX, DI         ; Draw Bar2

IO_FUNC:
    PUSHA
    MOV   AH, 2          ; Locate cursor
    INT   10h
    POPA
    INT   10h            ; read / write
    RET

  GO_QUI:

    INC   AX
    MOV   DX, BP         ; Draw Ball
    DEC   BX
    MOV   CL, 1
    CALL  IO_FUNC

  PUSHA
    MOV   CL, 0Ah
    MOV   DX, 3DAh
    DEC   BX             ; = 8
  DELAY:
    IN    AL, DX
    XOR   AL, BL
    TEST  AL, 08h
    JE    DELAY
    NOT   BL
    LOOP  DELAY
  POPA

    MOV   AL, 00         ; Remove Ball from Screen
    CALL  IO_FUNC



        XCHG  AX, DX         ; Move ball and check events

smc1:   INC   AH
smr1:   INC   AL

        CMP   AL, 50h        ; == 80d
        JB    NoXCollision
smr2:   SUB   AL, 2

        XOR   byte ptr SMR1[1], 08h
        XOR   byte ptr SMR2[0], 28h

      NoXCollision:
        XCHG  AX, DX
        MOV   AH, 8
        CALL  IO_FUNC        ; READ UNDERLYING CHAR

        CMP   AH, 0Ah
        JNE   BarNotHit
smc2:   SUB   DH, 2
        XOR   byte ptr SMC1[1], 08h
        XOR   byte ptr SMC2[1], 28h
      BarNotHit:

        CMP   DH, 24
        JNA   NothingExpecial

GameOver:
        MOV   AX, 0003h       ; Re-init mode 3h
        ADD   DH, AL
        ADC   byte ptr WINPLYR, -1
        INT   10h
        Mov   dx, offset Results
        mov   ah, 9           ; Write results
        int   21h
        RET                   ; quit

NothingExpecial:
        MOV   BP, DX

        XOR   BX, BX
        CALL  UPDATE_BARS


    MOV   AH, 01
    INT   16h         ; KeyPressed?
    JZ    NO_KEY_WAS_HIT
		SUB 	AX, AX
		INT 	16h 				; Go for it!
    MOV   DL, AH      ; Duh...

;    PUSHA

    XCHG  AX, SI
    MOV   BX, 0705h   ; '6' and '4'
		CALL	CheckThem

    MOV   BX, 4d4bh   ; '<-' and '->'
    CALL  CheckThem   ;
    XCHG  AX, SI

    XCHG  AX, DI
    MOV   BX, 201eh   ; 'd' and 'a'
    CALL  CheckThem
    XCHG  AX, DI

;    POPA


	NO_KEY_WAS_HIT:

    JMP   MAINLOOP

  ; }

CheckThem:
    CMP   DL, BL      ; Move left?
		JNE 	CheckAnother
    CMP   AL, 0
		JZ		DontMove
    SUB   AL, 5
		RET

CheckAnother:
    CMP   DL, BH      ; Move right?
		JNE 	DontMove
    CMP   AL, 70
		JE		DontMove
    ADD   AL, 5

DontMove:
		RET
 
	Results db 'Player '
	WinPlyr db '2 has won.$'

END PROGRAM_STARTS_HERE
