.model tiny
.586

.CODE
	ORG 100h
PROGRAM_STARTS_HERE:


  MOV   AL, 03h    ; Set video mode 3h
  OUT   21h, AL
  INT   10h

  MOV   BP, 0202h
  XOR   SI, SI
  MOV   DI, 1800h



	; { MAIN LOOP

MAINLOOP:

    MOV   BL, 0Ah
    PUSH  OFFSET GO_QUI

  UPDATE_BARS:
    MOV   AX, 09DBh      ; Draw Bar1
    MOV   DX, SI
    MOV   CL, 10
    CALL  IO_FUNC        ; WRITE

    MOV   DX, DI         ; Draw Bar2

IO_FUNC:
    PUSHA
    MOV   AH, 2          ; Locate cursor
    INT   10h
    POPA
    INT   10h            ; read / write
    RET

  GO_QUI:

    INC   AX
    MOV   DX, BP         ; Draw Ball
    DEC   BX
    MOV   CL, 1
    CALL  IO_FUNC

  PUSHA
    MOV   CL, 0Ah
    MOV   DX, 3DAh
    DEC   BX             ; = 8
  DELAY:
    IN    AL, DX
    XOR   AL, BL
    TEST  AL, 08h
    JE    DELAY
    NOT   BL
    LOOP  DELAY
  POPA

    MOV   AL, 00         ; Remove Ball from Screen
    CALL  IO_FUNC



        XCHG  AX, DX         ; Move ball and check events

smc1:   INC   AH
smr1:   INC   AL

        CMP   AL, 50h        ; == 80d
        JB    NoXCollision
smr2:   SUB   AL, 2

        XOR   byte ptr SMR1[1], 08h
        XOR   byte ptr SMR2[0], 28h

      NoXCollision:
        XCHG  AX, DX
        MOV   AH, 8
        CALL  IO_FUNC        ; READ UNDERLYING CHAR

        CMP   AH, 0Ah
        JNE   BarNotHit
smc2:   SUB   DH, 2
        XOR   byte ptr SMC1[1], 08h
        XOR   byte ptr SMC2[1], 28h
      BarNotHit:

        CMP   DH, 24
        JNA   NothingExpecial

GameOver:
        MOV   AX, 0003h       ; Re-init mode 3h
        ADD   DH, AL
        ADC   byte ptr WINPLYR, -1
        INT   10h
        Mov   dx, offset Results
        mov   ah, 9           ; Write results
        int   21h
        MOV   AL, 0B8h
        OUT   21h, AL
        RET                   ; quit

NothingExpecial:
        MOV   BP, DX

        XOR   BX, BX
        CALL  UPDATE_BARS


    IN    AL, 60h
    TEST  AL,0B0h
    js    no_key_was_hit

    PUSHF
    JZ    letter
    XCHG  SI, DI
  letter:
    AAM
    AND   AL, 2
    LEA   AX, [SI+5] ; Fetch register to be modified
    JNZ   moveleft

    SUB   AL, 10

  moveleft:
    CMP   AL, 70d
    JA    UNDO

  dontmove:
    XCHG  AX, SI

  UNDO:
    POPF
    JZ    undo_letter
    XCHG  SI, DI
  undo_letter:





	NO_KEY_WAS_HIT:

    JMP   MAINLOOP

  ; }

	Results db 'Player '
	WinPlyr db '2 has won.$'

END PROGRAM_STARTS_HERE
