.model tiny
.586

.CODE
	ORG 100h
PROGRAM_STARTS_HERE:

        INC   SI
        PUSH  SI

        MOV   AL, 03h    ; Set video mode 3h and mask many interrupts
        OUT   21h, AL
        INT   10h

        MOV   BP, 0202h
        XOR   SI, SI
        MOV   DI, 1800h

	; { MAIN LOOP

MAINLOOP:

        MOV   BL, 0Ah
        PUSH  OFFSET GO_QUI

    UPDATE_BARS:
        MOV   AX, 09DBh      ; Draw Bar1
        MOV   DX, SI
        MOV   CL, 10
        CALL  IO_FUNC        ; WRITE

        MOV   DX, DI         ; Draw Bar2

    IO_FUNC:
        PUSH  BX
        MOV   BH, 0
        PUSHA
        MOV   AH, 2          ; Locate cursor
        INT   10h
        POPA
        INT   10h            ; read / write
        POP   BX
        RET

    GO_QUI:

        INC   AX
        MOV   DX, BP         ; Draw Ball
        DEC   BX
        MOV   CL, 1
        CALL  IO_FUNC

        PUSHA
          MOV   CL, 0Ah
          MOV   DX, 3DAh
          DEC   BX             ; = 8
        DELAY:
          IN    AL, DX
          XOR   AL, BL
          TEST  AL, 08h
          JE    DELAY
          NOT   BL
          LOOP  DELAY
        POPA

        MOV   AL, 00         ; Remove Ball from Screen
        CALL  IO_FUNC

        POP   BX
                             ; Move ball and check events
        ADD   DL, BL

        CMP   DL, 50h        ; == 80d
        JB    NoXCollision
        SUB   DL, BL
        SUB   DL, BL
        NEG   BL

      NoXCollision:
        ADD   DH, BH
        MOV   AH, 8
        CALL  IO_FUNC        ; READ UNDERLYING CHAR

        CMP   AH, 0Ah
        JNE   BarNotHit
        SUB   DH,BH
        SUB   DH,BH
        NEG   BH
      BarNotHit:

        CMP   DH, 24
        JNA   NothingExpecial

      ;GameOver:
        MOV   AX, 0003h       ; Re-init mode 3h
        ADD   DH, AL
        ADC   byte ptr WINPLYR, AL
        INT   10h
        Mov   dx, offset Results
        MOV   AX, 09B8h       ; Write results
        OUT   21h, AL         ; Restore PIC status
        INT   21h
        RET                   ; quit

NothingExpecial:
        PUSH  BX
        MOV   BP, DX
        XOR   BX, BX
        CALL  UPDATE_BARS


        IN    AL, 60h
        TEST  AL,0B0h
        JS    no_key_was_hit

        PUSHF
        JZ    Letter
        XCHG  SI, DI
      Letter:
        AAM
        AND   AL, 2
        LEA   AX, [SI+5] ; Fetch register to be modified
        JNZ   MoveLeft
        SUB   AL, 10
      MoveLeft:
        CMP   AL, 70d
        JA    UNDO

        XCHG  AX, SI

      UNDO:
        POPF
        JZ    UNDO_Letter
        XCHG  SI, DI
      UNDO_Letter:

      NO_KEY_WAS_HIT:
        JMP   MAINLOOP

  ; }

    Results db 'Player '
    WinPlyr db '. has won.$'

END PROGRAM_STARTS_HERE
