.model tiny
.586

.CODE
	ORG 100h
PROGRAM_STARTS_HERE:

        INC   SI
        PUSH  SI

        XCHG  AX, SI
        XCHG  DX, AX

        MOV   AX, 0003h    ; Set video mode 3h and mask many interrupts
        OUT   21h, AL
        INT   10h

        MOV   DI, 1800h

  ; { MAIN LOOP

MAINLOOP:

        PUSHA
          MOV   CL, 0Ah
          MOV   DX, 3DAh
        DELAY:
          IN    AL, DX
          XOR   AL, BL
          TEST  AL, 08h
          JE    DELAY
          NOT   BL
          LOOP  DELAY
        POPA

        XOR   BX, BX
        INC   CX
        MOV   AX, 09DCh      ; Remove Ball from Screen
        CALL  IO_FUNC

        POP   CX
                             ; Move ball and check events
        ADD   DL, CL

        CMP   DL, 50h        ; == 80d
        JB    NoXCollision
        SUB   DL, CL
        SUB   DL, CL
        NEG   CL

      NoXCollision:
        ADD   DH, CH
        MOV   AH, 8
        CALL  IO_FUNC        ; READ UNDERLYING CHAR

        CMP   AH, 0Ah
        JNE   BarNotHit
        SUB   DH,CH
        SUB   DH,CH
        NEG   CH
      BarNotHit:

        CMP   DH, 24
        JNA   NothingExpecial

      ;GameOver:
        MOV   AX, 0003h       ; Re-init mode 3h
        ADD   DH, AL
        ADC   byte ptr WINPLYR, AL
        INT   10h
        Mov   dx, offset Results
        MOV   AX, 09B8h       ; Write results
        OUT   21h, AL         ; Restore PIC status
        INT   21h
        RET                   ; quit

NothingExpecial:
        PUSH  CX
        PUSH  DX
        CALL  UPDATE_BARS


        IN    AL, 60h
        TEST  AL,0B0h
        JS    SHORT NO_KEY_WAS_HIT

        PUSHF
        JZ    Letter
        XCHG  SI, DI
      Letter:
        AAM
        AND   AL, 2
        LEA   AX, [SI+5] ; Fetch register to be modified
        JNZ   MoveLeft
        SUB   AL, 10
      MoveLeft:
        CMP   AL, 46h
        JA    UNDO

        XCHG  AX, SI

      UNDO:
        POPF
        JZ    UNDO_Letter
        XCHG  SI, DI
      UNDO_Letter:

      NO_KEY_WAS_HIT:


        MOV   BL, 0Ah
        CALL  UPDATE_BARS

        INC   AX             ; Draw Ball
        POP   DX
        DEC   BX
        MOV   CL, 1
        CALL  IO_FUNC


        JMP   MAINLOOP

  ; }

    UPDATE_BARS:
        MOV   AX, 09DBh      ; Draw Bar1
        MOV   DX, SI
        MOV   CX, 10
        CALL  IO_FUNC        ; WRITE

        MOV   DX, DI         ; Draw Bar2

    IO_FUNC:
        PUSHA
        MOV   AH, 2          ; Locate cursor
        INT   10h
        POPA
        INT   10h            ; read / write
        RET


    Results db 'Player '
    WinPlyr db '. has won.$'

END PROGRAM_STARTS_HERE
