comment    ~  YuCeL's entry to Hugi size coding compo3
              by Mustafa YUCEL
              from Konya/TURKEY
              DOS/Win95
              Tasm /m2 entry.asm
           ~  Tlink entry/t

b          equ      byte ptr
w          equ      word ptr
SelfM      equ      vars - (waitVR + 3)

bar1x_old  equ     [si]
bar1x      equ     [si+1]
bar2x_old  equ     [si+2]
bar2x      equ     [si+3]

bally_old  equ     [si+4]
ballx_old  equ     [si+5]
bally      equ     [si+6]
ballx      equ     [si+7]

bally_mov  equ     [si+15]
ballx_mov  equ     [si+16]

msg        equ     [si+8]
Winner     equ     [si+15]

           .model  tiny
           .code
           org     100h
    main :
           call    SetMod
;
Play :     ; Display Bars & Ball...
           lea     si, vars+1
           lea     di, bar1x_old
           xor     ax, ax
           cwd               ; DH = 0, bar1 row
           mov     bp, sp
           mov     cl, 10
           mov     bx, cx

Disp :     ; Set cursor position
           inc     bp
           mov     dl, [bp+di]
           mov     ah, 2
           int     10h

           ; Write Character at cursor position
           mov     ah, 9
           int     10h

           cmp     bp, 2
           jge     balldisp

           ; Display Bars
           xor     al, ''
           test    bp, bp
           js      Disp
bar2 :     mov     dh, 24    ; DH = 24, bar2 row
           jmp     Disp

balldisp : ; Display Ball
           mov     cl, 1
           inc     bp
           mov     dh,[bp+di]
           xor     al, ''
           jz      disp
           inc     ax        ; '' + 1 = ''
           dec     bx
           jpe     disp      ; BX = 10, 9, 8; BX = 8d = 1000b odd parity
           ; BP = 7, BX = 8, CX = 1

;
           ; Check for valid keys
           in      al, 60h
           test    al, 128 + 1
           js      ChkXpos
           cbw               ; AH = 0

           jnz     Case1
           inc     di
           inc     di

Case1 :    ; left arrow, 75; <A>, 30; <4>, 5
           test    al, 72h
           mov     al, [di]
           jpo      Case2

           mov     ah, -5
           test    al, al
           jnz     UpdBar

Case2 :    ; rigt arrow, 77; <D>, 32; <6>, 7
           cmp     al, 70
           je      ChkXpos
           add     ah, 5
UpdBar :   add     ah, al
           dec     di
           stosw

;
ChkXpos :  ; Clear Keyboard Buffer
           mov     ax, 0C00h
           int     21h
           lea     si, bally  ; si = ballx
           lodsb              ; si = msg
           test    al, al
           jz      RotX
           cmp     al, 79
           jne     ChkYpos
RotX :     neg     b [si+bx]  ; ballx_mov

;
ChkYpos :  mov     ah, al         ; AL = ballx
           mov     al, [si-2]     ; bally

           mov     dh, [si-7]     ; bar1x
           cmp     al, 1
           je      UpdYpos

           mov     dh, [si-7+2]   ; bar2x
           cmp     al, 23
           jne     UpdBall

UpdYpos :  cmp     ah, dh
           jb      UpdBall
           add     dh, 9
           cmp     ah, dh
           ja      UpdBall
           neg     b [si+bp]      ; bally_mov

UpdBall :  ; AH = ballx, AL = bally
           mov     w [si-4], ax   ; bally_old
           mov     dx, [si+bp]    ; bally_mov
           add     [si-2], dl     ; bally
           add     [si-1], dh     ; ballx

           ; Check if game is over
           inc     bx             ; BX = 9
           cmp     al, 24
           je      Quit

           inc     bx             ; BX = 10
           test    al, al
           jz      Quit

           ; Wait vertical retrace
           xchg    cx, bx
           ; Loop for 10 times = (1 with JNE + 1 with JE)x5
           mov     dx, 3DAh
waitVR :   in      al, dx
           test    al, 8
           jne     waitVR
           ; Convert below JNE opcode to JE
           xor     b [si-SelfM-8], bl
           loop    waitVR

           jmp     Play

;
Quit :     lea     ax, [bx+'2'-10]
           mov     [si+bp], ax

SetMod :
           mov     al, 3
           int     10h

           mov     ah, 9
           lea     dx, [si]
           int     21h

           ret
;
vars       db      0         ; bar1x_old
           db      0         ; bar1x
           db      0         ; bar2x_old
           db      0         ; bar2x

           db      2         ; Old position values of BALL isn't
           db      2         ; important at starting.
           db      2         ; bally
           db      2         ; ballx

           db      "Player "
           db      1         ; ballx_mov
           db      1         ; bally_mov
           db      "has won.$"
end main