; Stefan's entry for Hugi Size Coding Competition #3
;
; `Pong' in 190 bytes.
; build with:   tasm /m entry
;               tlink /t entry
;
; requires a Pentium. Not that I use 32-bit instructions, but
; self-modifying code doesn't work on earlier processors without
; explicitly flushing the prefetch queue - which would cost an
; extra 2 bytes.
; Required registers at startup: ah = 0, ch = 0, sp = FFFEh
;
; Have phun,
;              Stefan <Streu@gmx.net>

                MODEL   TINY
                CODESEG
                ORG     100h
                P386
                JUMPS
                SMART

DEBUG = 0       ; if this is 1, one can abort the game with ESC
NO_P5 = 0       ; if this is 1, the entry grows larger, but works
                ; on non-Pentii

FLUSH MACRO     ; flush prefetch queue
        IF NO_P5
                jmp $+2
        ENDIF
ENDM

; Variables:
; - BH = ball line
; - BL = ball column * 2
; - paddle coords are memory variables
; - BP = -2 if ball moves right, +2 else
; - vertical ball movement through self-modifying code
Start:          mov     ah,0B8h
                mov     es,ax
                call    Init
                mov     bx,204h         ; ball position = (2,2)
                mov     bp,sp           ; bp = -2

Restart:        mov     si,offset Value ; set logical line length to 128 characters
                mov     dx,3D4h         ; -> no need for address calculations
                outsw                   ; this does not affect the visual appearance
                                        ; of the text mode (still 80 chars/line)

                mov     cl,5            ; wait for retrace
Delay_L0:       mov     dl,0DAh         ; DH is still 3
		db	0B4h		; 'mov ah,XX'
Delay_Loop:	lahf
		in	al,dx
		and	ax,0408h
		jnz	Delay_Loop

; Keyboard check. Intermixing this with the Retrace loop guarantees that
; at least one _full_ keystroke per iteration is evaluated (arrows generate
; 2 characters). You won't manage to press more than one key in 5 frames
; anyway - 0.07 seconds is not that much ;-)
                mov     ah,6            ; the One True DOS Function(tm)
                mov     dl,-1           ; like Turbo Pascal's ReadKey
                int     21h
IF DEBUG
                cmp     al,27
                je      Ende
ENDIF
                aam     17
                jz      NoKey           ; AL = 0 == extended code or no key
                mov     di,offset Paddle1X
                cmp     al,10
                jb      MovePaddle
                mov     di,offset Paddle2X
MovePaddle:     mov     al,[di]
                jpo     MoveLeft        ; parity odd = "4", "a" or left-arrow
                add     al,20           ; move 10 chars right
                cmp     al,150
                ja      NoKey
MoveLeft:       sub     al,10           ; move 5 chars left
                jb      NoKey
                mov     [di],al
NoKey:
                loop    Delay_L0        ; end retrace

; now display stuff. SI already points to the right address (from the
; lonely outsw _far_ above), DX = 3FFh, CH = 0
ShowPaddle:     lodsw
                mov     di,ax           ; AL = 0
                mov     cl,160
                rep stosb
                lodsb
                xchg    di,ax
                mov     ax,219 + 256*10
                mov     cl,10
                rep stosw
                inc     dx              ; 1st INC: dx=400h, Parity even
                jpe     ShowPaddle      ; 2nd INC: dx=401h, Parity odd

; here: DX = 401h, AX = paddle character, CX = 0
                xchg    cx,ax                   ; ax = 0
                mov     di,100h                 ; clear lines 1 to 23 to erase old ball
                mov     ch,22                   ; 22 full lines + 219 chars
                rep stosb
                mov     word ptr es:[bx],220 + 9*256   ; show current ball

                mov     al,bl                   ; ball at left or right border?
                aam     2*79
                jnz     NoFlipX
                neg     bp                      ; yes -> reflect ball
NoFlipX:        sub     bx,bp

                dec     si                      ; SI -> Paddle2X
                cmp     bh,23
                je      Paddle2Reflex           ; =23 -> reflect at paddle 2
                ja      Ende			; >23 -> exit at bottom of screen
                cmp     bh,dl                   ; DL = 1
                jb      Ende                    ; <1 -> exit at top of screen
                ja      Okay                    ; >1 -> inside playing field
Paddle1Reflex:  sub     si,Paddle2X-Paddle1X
Paddle2Reflex:  lodsb                           ; paddle X
                sub     al,bl                   ; paddle right from ball
                ja      Okay
                cmp     al,-20                  ; paddle left from ball
                jbe     Okay
                xor     byte ptr [Okay+1],8     ; change the INC BH into DEC BH
                FLUSH                           ; flush queue on non-P5
Okay:           inc     bh
                jmp     Restart

Ende:           adc     byte ptr [PlayerNr],dl
Init:           mov     ax,3
                int     10h
                mov     ah,9
                mov     dx,offset Text
                int     21h
                ret

Text            db      'Player '
PlayerNr        db      '0 has won.$'

Value           dw      4013h           ; reg.13 (row offset) = 40
Paddle1         db      0,0
 Paddle1X       db      0
Paddle2         db      0,24
 Paddle2X       db      0

; Hmm. How does it come that I never used AAM or the Parity Flag
; before those competitions...

                END     Start
