; 248 Byte Pong game by Andrew Nicolle (aka raven/tektonic)
; coded 9 August 1998 for hugi size coding compo #3

; USAGE: Control the bats using A and D keys for player 1 and
;        4 and 6 keys on the keypad for player 2.

; ===< Contact Info >===
; Email: andrewn@cobweb.com.au
; Web:   http://www.cobweb.com.au/~andrewn

; History: 18/7/98 - 330 bytes
;           5/8/98 - 260 bytes
;           7/8/98 - 241 bytes
;           9/8/98 - 248 bytes (modified to fit the rules)


Ideal
model tiny
p286


CODESEG
ORG 100h

BAR_COLOUR=10
BAR_WIDTH=10
BAR_CHAR=219
BALL_COLOUR=9
BALL_CHAR=220
BALL_POS=(2*160+2*2)  ; Initial ball position
BALLDX=2              ; Initial ball x-increment
BALLDY=160            ; Initial ball y-increment


START:

       mov     al,3
       push    ax
       int     10h                     ; set text mode
       push    0b800h
       pop     es
       mov     bp,BALL_POS
       mov     bl,BALLDX
       mov     si,BALLDY

pong_loop:                             ; main loop

       mov     di,[oldpos1]
       mov     ax,BAR_COLOUR*256+' '
       mov     cl,BAR_WIDTH
       rep     stosw                   ; clear bar 1
       mov     di,[oldpos2]
       mov     cl,BAR_WIDTH
       rep     stosw                   ; clear bar 2
       mov     di,[oldbpos]
       stosw                           ; clear ball
       mov     di,[pos1]
       mov     al,BAR_CHAR
       mov     cl,BAR_WIDTH
       rep     stosw                   ; draw bar 1
       mov     di,[pos2]
       mov     cl,BAR_WIDTH
       rep     stosw                   ; draw bar 2
       mov     di,bp
       mov     ax,BALL_COLOUR*256+BALL_CHAR
       stosw                           ; draw ball

; collision detection

       mov     ax,bp                   ; get ball position
       mov     cl,'1'
       cmp     ax,160                  ; see if ball at top line (p2 won)
       jb      p2_won
       cmp     ax,(24*160)             ; see if ball at bottom (p1 won)
       jb      check_bar1
       jmp     player_num

p2_won:

       inc     cl                      ; player 2 has won

player_num:

       mov     di,offset message2
       mov     [di],cl                 ; Set player number

; Game Over - print winning player and quit

       pop     ax
       int     10h                     ; set text mode

       mov     ah,9
       mov     dx,offset message
       int     21h                     ; display message
       ret

check_bar1:

       mov     cl,160
       mov     di,cx
       cmp     ax,320                  ; see if ball on line 2
       jae     check_bar2
       neg     di                      ; look above instead of below
       jmp     check_bars

check_bar2:

       cmp     ax,160*23               ; see if ball on line 23
       jb      check_edges

check_bars:

; check for bar collision
       add     di,ax
       mov     dx,[es:di]              ; read above/below ball
       cmp     dl,BAR_CHAR             ; Is a bar there?
       jne     check_edges             ; nope
       neg     si                      ; change ball y-direction

check_edges:

       div     cl
       or      ah,ah                   ; Has the ball hit left edge?
       jz      edge_collision          ; yes
       cmp     ah,158                  ; Has the ball hit right edge?
       jne     read_keyboard           ; no

edge_collision:

       neg     bx                      ; change ball x-direction

; keyboard handling

read_keyboard:

       mov     ah,1
       int     16h                     ; check for keypress
       jz      no_key_pressed
       xor     ah,ah
       int     16h                     ; clear keyboard buffer
       mov     di,offset pos1
       test    ah,1                    ; player 1 keys hit?
       jnz     chk_num                 ; yes
       add     di,4                    ; move to player 2 data

chk_num:

       cmp     ah,7                    ; check for number keys (4,6)
       ja      chk_dir
       not     ah                      ; invert bits (required for next test)

chk_dir:

       mov     dl,10
       test    ah,2                    ; left or right key pressed?
       jz      right                   ; move right
       neg     dl                      ; move left

right:

       mov     ax,[di]                 ; read bar position
       mov     [di+2],ax               ; save old bar position
       add     al,dl                   ; Try moving left or right
       cmp     al,95h                  ; see if wrapped around edge of screen
       jae     no_key_pressed          ; if so, don't move bar
       mov     [di],ax                 ; update bar position

no_key_pressed:

       mov     [oldbpos],bp            ; save old position of ball
       add     bp,bx                   ; update ball x-position
       add     bp,si                   ; update ball y-position
       mov     cl,5

delay_loop:                            ; Add delay to make game playable

       mov     dx,3dah

delay_l1:

       in      al,dx
       test    al,8
       jne     delay_l1

delay_l2:

       in      al,dx
       test    al,8
       je      delay_l2
       loop    delay_loop
       jmp     pong_loop

; End of game message
message  db 'Player '
message2 db 'x has won.$'

; Variables - important! Must be in this order for code to work
pos1    dw 0                           ; Position of player 1 bar
oldpos1 dw 0                           ; Old position of player 1 bar
pos2    dw 24*160                      ; Position of player 2 bar
oldpos2 dw 0                           ; Old position of player 2 bar
oldbpos dw (2*160+2*2)                 ; Old ball position

END START
