;PONG by Bubulle,Krick,st0ne from France & Sweden
;
;assemble with tasm /m entry
;link with     tlink /t entry

.model tiny
.486
.code
        org 100h

;--------------------------------------
;INIT

;It looks like there are a lot of zeros here but it saves one byte
;Too bad we have to write a mov ax,0003h instead of mov al,03h

start:  db 0A0h,00h,00h              ;3 mov al,[0000h]
        mov ax,0003h                 ;3
        les bp,[si]                  ;2 bp = ball.y increment (00A0)
                                     ;  es = screen segment (B800)
        
        push ax                      ;1
        int 10h                      ;2

        mov cl,78                    ;2 cx = distance to the border
        mov dx,03DAh                 ;3
        mov di,0144h                 ;3 di = ball position
        mov si,0180h                 ;3 si = lower bar position (0F00/0A)
                                     ;  bx = upper bar position (0000)

;--------------------------------------
;DRAW BAR

;For the jump we use the opcode of the segment override es:

main:   mov ax,0ADBh                 ;3
        pusha                        ;1
        db 0EBh                      ;1 jmp putbar
after:  
        
;--------------------------------------
;REFLECT BALL

        cmp es:[di+bp],ax            ;3
        jne nobar                    ;2
        neg bp                       ;2 changes the ball y increment
        xor player,dh                ;4 switches between '1' and '2'
nobar:

        loop nowall                  ;2
        mov cl,79                    ;2
        neg byte ptr[offset move+2]  ;4 SMC to change the ball x increment
nowall: 

        cli                          ;1 to 'clear' the keyboard buffer

;--------------------------------------
;DRAW BALL + WAIT + CLEAR BALL

;This vret routine doesn't modify cx
;It begins with ah=0Ah and ends with ah=00h
;on its way to 0, ah switches parity 10 times

        mov word ptr es:[di],09DCh   ;5

delay:  in al,dx                     ;1
        and al,08h                   ;2
        xor al,ah                    ;2
        jpo delay                    ;2
        add ah,27h                   ;3
        jne delay                    ;2

        pusha                        ;1
        stosw                        ;1

;--------------------------------------
;SUBROUTINE TO DRAW/CLEAR BAR

;At the begin of this routine, bp = A0h or -A0h
;9F and -9F are even numbers, and 9E and -9E are not

;aaa sets the carry when drawing (ax=0ADBh) 
;and clears it otherwise (ax=0008h)
;It saves two 'call' and a 'ret'

putbar: push si                      ;1
        push bx                      ;1
st10:   pop di                       ;1
        mov cl,0Ah                   ;2
        imul di,cx                   ;3
        rep stosw                    ;2
        dec bp                       ;1
        jp st10                      ;2
        aaa                          ;1
        popa                         ;1
        jc after                     ;2

;--------------------------------------
;KEYBOARD + MOVE BAR

key:    in al,60h                    ;2
        test al,80h                  ;2
        js nokey                     ;2
                           
        aam 05h                      ;2 al = 0 for left and 2 for right
        add ah,bh                    ;2 ah is even if player 2 moves
        sahf                         ;1 bh is even if bx is player 1's bar
        jc noxchg                    ;2
        xchg bx,si                   ;2
noxchg: add al,bl                    ;2
        test al,0Fh                  ;2 the middle of the bar must be within
        jz nomove                    ;2 [1..15] Otherwise don't move it
        dec ax                       ;1
        mov bl,al                    ;2
nomove:
nokey:  

;--------------------------------------
;MOVE BALL + CHECK EXIT
        
;The displacement is modified (+2/-2) when the ball bounces on the borders

move:   lea di,[di+bp+2]             ;3 

;Test if the ball is on line -1 or 25
        
        cmp di,0FA0h                 ;4 
        jb main                      ;2

;--------------------------------------
;EXIT

        pop ax                       ;1
        int 10h                      ;2
        mov ah,09h                   ;2
        lea dx,string                ;3
        int 21h                      ;2
        ret                          ;1

string  db 'Player '                 ;18
player  db '1 has won.$'

        end start
