;  TEMPLATE
;  Developed by Boo Khan Ming (Malaysia)
;
;
;  The algorithm used here is 4-bit compression with extended supplementary
;  code (BIT4E), which involves primary and extended compression.
;
;  In primary compression, up to 14 different bytes with most occurrence
;  able to be compressed into 4-bit (8-bit to 4-bit compression).
;  The remaining 2 bytes are reserved for identifier string.
;
;  Whilst in extended compression, there is no compression, in fact, the
;  code with the least occurrence is translated to local code and stored,
;  and prefixed with an extended identifer (8-bit to 5-bit truncation).
;
;  This bit compression is far more efficient than 5-bit or 6-bit compression.
;  However, this compression algorithm is only applicable to the predefined
;  text file only.
;
;
;  E-mail:  bookm@tm.net.my
;  URL   :  http://www.geocities.com/SiliconValley/Horizon/3409/

        .MODEL tiny
        .286

        .CODE
        .STARTUP

        clc
        mov     si, OFFSET TextBlock+1
Redo:
        lodsb                   ; Convert nibbles into bytes
        mov     ah, al
        pushf
        shr     ah, 4
        and     al, 0fh
        popf
        push    ax              ; Perform decompression for each nibble
        mov     al, ah
        call    Decompress
        pop     ax
        call    Decompress
        jmp     SHORT Redo

Decompress      PROC    NEAR
        jc      Process                         ; Perform extended decompression
        cmp     al, 1                           ; Check for extended identifier
        jbe     Preprocess                      ; Prepare for extended decompression
        mov     bx, OFFSET PrimaryTable         ; Use primary table
        xlat                                    ; Recover ASCII code
        call    Output
        ret
Preprocess:
        stc                             ; Set extended identifier
        mov     bh, al                  ; Set extended start bit
        ret
Process:
        shl     bh, 4                           ; Concate with extended start bit
        or      al, bh
        cmp     al, 1fh                         ; Check for exit identifier
        jz      SHORT Exit
        mov     bx, OFFSET ExtendedTable        ; Use extended table
        xlat                                    ; Recover ASCII code
        call    Output
        clc                                     ; Return to primary decompression state
        ret
Exit:
        mov     ah, 4ch                 ; Proper DOS exit
        int     21h
Decompress      ENDP

Output  PROC    NEAR                    ; Procedure to output character
        mov     dl, al
        mov     ah, 02h                 
        int     21h
        cmp     al, 13                  ; Check if CR encountered
        jz      Expand
        ret
Expand:
        mov     dl, 10                  ; Expand CR with LF
        int     21h
        ret
Output  ENDP

        ; Code table for translation of compressed code
        PrimaryTable    DB      "X","X",32,13,"f","l","a","n"
                        DB      "t","s","r","e","h","o","i","p"
        ExtendedTable   DB      "P","T","N","?","O","Y","I"
                        DB      "q","B","-",",","v","g","c","u"
                        DB      "d",".","k","w","S","m","y"

        ; Starting offset of compressed text block to load
        TextBlock       DB      ?

        END
