; Print a funny text to stdout
;
; by Stefan <Streu@gmx.net> for Hugi Size Coding Competition #2
; see readme for build instructions & basic ideas

                MODEL   TINY
                CODESEG
                ORG     100h
                P386

; Assumptions:
; - AX = 0 (guaranteed by compo)
; - RET ends program, CS=DS=ES=SS (guaranteed by DOS)
; - BX != 1 (guaranteed by compo)

; Variables:
; - DH = # of "active" characters in translation
; - SI = pointer to active character translation table
; - CX = current length of number in bytes

Start:          mov     dx,200h			; divisor 2, 1st character code = 0
                mov     si,offset TransTab + TransLen - 2
                mov     cx,HugeNumLen
NoLiteral:
                dec     bx                      ; BX = 1 means
                jnz     Print                   ; extend character set
                inc     dh                      ; - increase base of number
                dec     si                      ; - and add one character to translation table

Print:          mov     ah,2                    ; now print DL
                or      dl,dl                   ; DL = 0 means 2 consecutive spaces
                jnz     NoDblS
                mov     dl,32                   ; so output two of them
                int     21h
NoDblS:         int     21h
                cmp     al,13   ; undocumented, but works in DOS 2 .. 7. replace
                                ; "al" with "dl" to get the same but documented
                                ; behaviour and waste one byte.
                mov     dl,10                   ; CR means CR+LF in reality
                je      NoDblS

              ;-- extract one character (aka digit)
Mainloop:       push    cx
                mov     di,offset HugeNum
                cbw                             ; sets AH to 0
DivLoop:        mov     al,[di]                 ; divide the number by DH
                div     dh
                stosb
                loop    DivLoop
                pop     cx                      ; remainder is in AH,
                                                ; last byte of number in AL
              ;-- process character
                xor     bx,bx                   ; load BX with character code
                or      bl,ah                   ;   and set ZF if zero
                mov     dl,[si+bx]              ; translate character code
                jnz     NoLiteral               ; 0 == literal saved as base-256
                mov     dl,al                   ;   take literal
                dec     cx                      ;   cut off last digit = divide by 256
                dec	ax                      ; a literal 0 ends the text
                jns     NoLiteral		;   sign bit == AX was 0 before
                ret

                INCLUDE hugenum.out

                END     Start
