{ͻ
 Program      : 5BITPACK.PAS                                                
 Author       : Sebastian Schuberth                                         
 Description  : Packs "TEXT.TXT" by using only 5 bits per char              
Ķ
 Created on   : 27.06.1998                                                  
 Last revised : 27.06.1998                                                  
}

Program FiveBitPacking;

Procedure Text5BitPack(FileName:String);
Var
  HandleSrc:Text;
  HandleDst:File Of Byte;
  TextLine:String;
  BitsRead,BitBuffer:Word;

  Procedure TextConvert(Var TextLine:String);
  Var
    i:Word;
  Begin
    For i:=1 To Length(TextLine) Do Begin
      Case TextLine[i] Of
        ' ': TextLine[i]:='@';
        ',': TextLine[i]:='\';
        '-': TextLine[i]:=']';
        '.': TextLine[i]:='^';
        '?': TextLine[i]:='_';
        Else TextLine[i]:=UpCase(TextLine[i]);
      End;
    End;
  End;

  Procedure Text5BitWrite(TextLine:String);
  Var
    i:Word;
  Begin
    For i:=1 To Length(TextLine) Do Begin
      BitBuffer:=BitBuffer OR ((Ord(TextLine[i])-64) SHL BitsRead);
      Inc(BitsRead,5);
      If BitsRead>7 Then Begin
        Write(HandleDst,Byte(BitBuffer));
        BitBuffer:=BitBuffer SHR 8;
        Dec(BitsRead,8);
      End;
    End;
  End;

  Procedure Text5BitFlush;
  Begin
    If BitsRead=0 Then Exit;

    BitBuffer:=BitBuffer AND ((1 SHL BitsRead)-1);
    Write(HandleDst,Byte(BitBuffer));
  End;

Begin
  BitsRead:=0;
  BitBuffer:=0;

  Assign(HandleSrc,'TEXT.TXT');
  Reset(HandleSrc);

  Assign(HandleDst,FileName);
  Reset(HandleDst);
  Seek(HandleDst,FileSize(HandleDst));

  While Not EOF(HandleSrc) Do Begin
    ReadLn(HandleSrc,TextLine);
    TextLine:=TextLine+'[';
    TextConvert(TextLine);
    Text5BitWrite(TextLine);
  End;
  Text5BitFlush;

  Close(HandleDst);
  Close(HandleSrc);
End;

Begin
  Text5BitPack('5BITSHOW.COM');
End.