// Text Compressor by Andrew Nicolle (aka raven/tektonic)
// coded 1 July 1998 for hugi size coding compo #2
// Tested using Turbo C++ v3.0 and DJGPP v2
//
// ===< Contact Info >===
// Email: andrewn@cobweb.com.au
// Web:   http://www.cobweb.com.au/~andrewn

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TEXTNAME "text.txt"     // Name of text file
#define COMNAME  "crunch.com"   // Name of com file

// Compression parameters
#define LEN_BITS 3              // no. of length bits
#define OFS_BITS 9              // no. of offset bits
#define WIN_SIZE (1<<OFS_BITS)  // window size
#define LK_SIZE  (1<<LEN_BITS)  // look ahead size

// Globals used for writing bit-stream
unsigned char bitmask=0x80,bitpos=7;
unsigned char cur_char=0;


inline void write_bit(FILE *output,int bit)
// Outputs a single bit

{
  cur_char|=(bitmask&(bit<<bitpos));
  bitpos--;
  bitmask>>=1;
  if (!bitmask)
  {
    fputc(cur_char,output);
    cur_char=0;
    bitmask=0x80;
    bitpos=7;
  }
}

void write_bits(FILE *output,long value, int num_bits )
// Output several bits

{
  int i;
  long mask=(1 << (num_bits-1));

  for (i=0;i<num_bits;i++)
  {
      write_bit(output,(value&mask) >> (num_bits-i-1));
      mask>>=1;
  }
}

void flush_bits(FILE *output)
// Flush remaining bits to file
{
  if (bitpos!=7)
     fputc(cur_char,output);
}

int search_win(char *window,int lksize,int start,int win_pos)
// Search window for a match

{
  int matched=0;

  while (lksize)
  {
    if (window[start++]==window[win_pos++])
       matched++;
    else
      break;
    start&=(WIN_SIZE-1);
    win_pos&=(WIN_SIZE-1);
    lksize--;
  }
  return matched;
}


int main(int argc,char *argv[])

{
  FILE *input,*output;
  unsigned char cmpbuffer[1000];
  int filelen;

  // Check for parameters & open files
  if (argc<2)
  {
    cout << "Usage: packdata output.com" << endl;
    exit(1);
  }
  if ((input=fopen(COMNAME,"rb"))==NULL)
  {
    cout << "Error opening .com file" << endl;
    exit(2);
  }
  if ((output=fopen(argv[1],"wb"))==NULL)
  {
    cout << "Error opening file for output" << endl;
    exit(2);
  }

  // Write com file data to output file
  filelen=fread(cmpbuffer,1,1000,input);
  fwrite(cmpbuffer,filelen,1,output);
  fflush(output);
  fclose(input);

  // Open text file
  if ((input=fopen(TEXTNAME,"rb"))==NULL)
  {
    cout << "Error opening text file" << endl;
    exit(2);
  }

  // Compression variables
  char window[WIN_SIZE];
  int i,c,match_len=0,match_pos=0,lk_chars=0,
      win_pos=0,win_start=0,len,countpos=0,win_size=0;

  // Initialize look-ahead window
  memset(window,0,WIN_SIZE);
  for (i=0;i<LK_SIZE;i++)
  {
    c=fgetc(input);
    if (c==EOF)
       break;
    window[i]=c;
    lk_chars++;
  }

  // Main compression loop
  while (lk_chars)
  {
    // Clamp match length
    if (match_len>lk_chars)
       match_len=lk_chars;

    // Output either length/offset or single character
    if (match_len>=2)
    {
      // Output length/offset pair
      write_bit(output,0);                  // 0 = a length/offset follows
      write_bits(output,match_len-1,LEN_BITS);
      write_bits(output,match_pos,OFS_BITS);
    } else
    {
      // Write a single character
      write_bit(output,1);                  // 1 = a single char follows
      write_bits(output,window[win_pos],7); // Using 7-bits per char
      match_len=1;
    }

    // Read more characters into window
    for (i=0;i<match_len;i++)
    {
      c=fgetc(input);
      if (c==EOF)
	 lk_chars--;                          // Reduce look-ahead size
      else
	window[(win_pos+lk_chars+i)&(WIN_SIZE-1)]=c;
    }
    win_size+=match_len;                      // Increase data window size
    win_pos=(win_pos+match_len)&(WIN_SIZE-1); // Move look-ahead pointer

    // Clamp data window size and wrap start data pointer if necessary
    if (win_size>WIN_SIZE-lk_chars)
    {
      win_size=WIN_SIZE-lk_chars;
      win_start=(win_start+match_len)&(WIN_SIZE-1);
    }

    // Search through window for a match
    match_len=match_pos=0;
    i=win_size;
    countpos=win_start;
    while (i-->0)
    {
      len=search_win(window,lk_chars,countpos,win_pos);
      if (len>match_len)
      {
	match_len=len;
	match_pos=countpos&(WIN_SIZE-1);
      }
      countpos=(countpos+1)&(WIN_SIZE-1);
    }
  }

  // Output remaining bits
  flush_bits(output);
  fclose(input);
  fclose(output);
  return 0;
}
