#include <stdio.h>
#include <io.h>
#include <malloc.h>
#include <string.h>
#include <fcntl.h>
#include <dos.h>
#include <ctype.h>
#include <sys/stat.h>

typedef unsigned char byte;
typedef unsigned int  word;

#define TRUE 1
#define FALSE 0

#define MAX_BYTE 4096
#define MAX_TYPE 4

/*----------------------------------------------------------*/

char output[MAX_BYTE];
int  outcount;
int  outpos;
int  outbit;

void putbit(int i) {
  outcount++;
  outbit += outbit;
  if (outbit == 256) {
    outbit = 1;
    outpos++;
    output[outpos] = 0;
  }
  if (i) output[outpos] |= outbit;
}

int putbits(long val,int count) {
  while (count--) {
    putbit( val & 1 );
    val >>= 1;
  }
  if (val) printf("ERROR: putbits failed!\n");
  return val != 0;
}

/*----------------------------------------------------------*/

typedef struct {
  word Type;		/* token type */
  word Size;		/* token's bit size */
  word Pos;		/* token parameter */
  word Count;		/* decoded chars with token */
} tToken;

typedef struct {
 int MinCount;		/* minimal chars to move */
 int OfsBit;		/* bitcount for offset parameter */
 int Suffix;		/* predefined bits for token */
} tMoveSpec;

tMoveSpec Move[2];
tMoveSpec BestMove[2];
int     BestSize;

tToken 	Token[MAX_BYTE];
byte 	Data[MAX_BYTE];
int 	LastFound[MAX_BYTE];
int 	Size,OrigSize;

/*               00000000001111111111222222222233 	*/
/*               01234567890123456789012345678901 	*/
char* CharSet = "abcdefghijklmnopqrstuvwxy|,$- .?";


/* if new code's better, set the Token[i] structure */
void SetBest(int i,int Size,int Type,int Count,int Pos) {
  tToken* p = &Token[i];
  if (p->Size > p[Count].Size + Size) {
    p->Type = Type;
    p->Count = Count;
    p->Pos = Pos;
    p->Size = p[Count].Size + Size;
  }
}

void CheckMove(int Type,int i,int Count,int Pos) {
  if (Count>=Move[Type].MinCount && Pos < (1 << Move[Type].OfsBit))
    SetBest(i,Move[Type].Suffix+Move[Type].OfsBit+
      (Count-Move[Type].MinCount)+1,Type,Count,Pos);
}

/* search best coding token as if were at Pos */
void Search(int Pos) {
  int i,Count,Ofs;
  SetBest(Pos,1+5,2,1,Data[Pos]);
  i=LastFound[Pos];
  while (i>=0) {
    Count = 1;
    Ofs = Pos-i;
    while (Pos+Count < Size && Data[i+Count] == Data[Pos+Count]) {
      Count++;
      CheckMove(0,Pos,Count,Ofs);
      CheckMove(1,Pos,Count,Ofs);
    }
    i=LastFound[i];
  }
}

void Calc( void ) {
  int i;
  Move[0].Suffix = 1+(Move[1].OfsBit?1:0);
  Move[1].Suffix = 1+(Move[0].OfsBit?1:0);
  memset(&Token,0xFF,sizeof(Token));
  Token[Size].Size = 0;
  for (i=Size-1;i>=0;i--)
    Search(i);
  if (Token[0].Size < BestSize) {
    BestSize = Token[0].Size;
    memcpy(BestMove,Move,sizeof(Move));
  }
}

int Stage2( void ) {
  char s[32];
  int BestDeep;
  int BestType[3][MAX_TYPE];
  int i,j,k,q;
  BestSize = (word)-1;
  Move[0].MinCount = 2;
  Move[1].MinCount = 3;
  Move[0].OfsBit = 6;
  Move[1].OfsBit = 9;
  Calc();

/* search best settings, must sync unpack.asm too !!! */
/*
  k = 10;
  printf("[%*c]\r[",k,' ');
  for (Move[0].OfsBit=0;Move[0].OfsBit<k;Move[0].OfsBit++) {
    for (Move[1].OfsBit=0;Move[1].OfsBit<k;Move[1].OfsBit++) {
      Calc();
    }
    printf(".");
  }
  printf("\n");
*/

/* recalc with best settings */
  memcpy(Move,BestMove,sizeof(Move));
  Calc();
  j = 0;
  BestDeep = 0;
  memset(BestType,0,sizeof(BestType));
  while (j < Size) {
    BestType[0][Token[j].Type]++;
    BestType[1][Token[j].Type]+=Token[j].Size - Token[j+Token[j].Count].Size;
    BestType[2][Token[j].Type]+=Token[j].Count;
    j += Token[j].Count;
    BestDeep++;
  };
  printf("Compression in bytes: %i/%i (%li%%)\n"
	 "Tokens: %i\n",(Token[0].Size+7)>>3,OrigSize,
	 (long)((Token[0].Size+7)>>3)*100/OrigSize,BestDeep);
  printf(" type  format                         in(byte)  count out(bit)\n");
  for (j=0;j<MAX_TYPE;j++) {
    if (BestType[0][j]) {
      if (j==2) {
	sprintf(s,"0,<Data>:5");
      }
      else {
	sprintf(s,"1,%i,<Offset>:%i,1:<Length-%i>,0",j,
	  Move[j].OfsBit,Move[j].MinCount);
      }
      printf(" %3i   %-30s %4i     %4i    %4i\n",j,s,
       BestType[2][j],BestType[0][j],BestType[1 ][j]);
    }
  }
  outpos = -1;
  outbit = 128;
  outcount = 0;
  j = 0;
  while (j < Size) {
    switch (Token[j].Type) {
      case 2:
	putbit(0);
	if (putbits(Token[j].Pos,5)) return 1;
	break;
      case 0:
	putbit(1);
	putbit(0);
	if (putbits(Token[j].Pos,Move[0].OfsBit)) return 1;
	for (k=Move[0].MinCount;k<Token[j].Count;k++) putbit(1);
	putbit(0);
	break;
      case 1:
	putbit(1);
	putbit(1);
	if (putbits(Token[j].Pos,Move[1].OfsBit)) return 1;
	for (k=Move[1].MinCount;k<Token[j].Count;k++) putbit(1);
	putbit(0);
	break;
    }
    if (Token[0].Size - Token[j+Token[j].Count].Size != outcount) {
      printf("ERRORL: Write sync failed at %i!\n",j);
      return 1;
    }
    j += Token[j].Count;
  }
  return 0;
}

int Stage1( void ) {
  int i,j;
  char* c = Data;
  char* p = Data;

/* Convert to lowercase and skip newline chars */
  j = 0;
  while (Size--) {
    if (*c != 13 && *c != 10) {
      *(p++) = tolower(*c);
      j++;
    }
    else {
      if (*c == 10) {
/* if line is smaller than 44, insert a special newline char */
	if (j < 44)
	  *(p++) = '|';
	if (j > 44) {
	  printf("ERROR: Row longer than 44 chars found!\n");
	  return 1;
	}
	j = 0;
      }
    }
    c++;
  }
  *(p++) = '$';

/* Convert to 5bit */
  Size = p - Data;
  for (i=0;i<Size;i++) {
    if ((c = strchr(CharSet,Data[i])) != NULL)
      Data[i] = c - CharSet;
    else {
      printf("ERROR: '%c' out of charset!\n",Data[i]);
      return 1;
    }
  }

/* fill out LastFound[] array */
  for (i=0;i<Size;i++) {
    LastFound[i] = -1;
    for (j=i-1;j>=0;j--) {
      if (Data[i] == Data[j] && Data[i+1] == Data[j+1]) {
	LastFound[i] = j;
	break;
      }
    }
  }

  return 0;
}

/*----------------------------------------------------------*/

int main() {
  int f;
  printf("Text Packer v2.1\n"
    "Copyright (c) 1998 by Picard / Hydrogen (mailto:picard@telnet.hu)\n\n");

/* read input file */
  f = open("text.txt",O_BINARY | O_RDONLY);
  if (f == -1) {
    printf("Can't open text.txt!\n");
    return 1;
  }
  OrigSize = Size = read(f,Data,sizeof(Data));
  close(f);

/* compress */
  if (Stage1()) return 1;
  if (Stage2()) return 1;

/* read unpacker */
  f = open("unpack.com",O_BINARY | O_RDONLY);
  if (f == -1) {
    printf("Can't open unpack.com!\n");
    return 1;
  }
  Size = read(f,Data,sizeof(Data));
  close(f);

/* write out COM file, unpacker + compressed data */
  f = open("text.com",O_RDWR | O_BINARY | O_TRUNC | O_CREAT,S_IREAD | S_IWRITE);
  if (f == -1) {
    printf("Can't create text.com!\n");
    return 1;
  }
  write(f,Data,Size);
  write(f,output,(outcount+7)>>3);
  close(f);

  return 0;
}
