    ; Simple decoder for Fano-coded data
    ; Written by Roland Neul
    ; Assemble with: nasm -f bin -o decode.com decode.asm

    ; Last changed: 28.06.98

    org 0100h

    ; Initialize second part of codetable (31 bytes)
    ; Assumes CH=0
    mov di,endcodetab             ; 3
    mov ax,2322h                  ; 3
    mov cl,7                      ; 2
iloop1:
    stosw                         ; 1
    xor ax,2020h                  ; 3
    loop iloop1                   ; 2
    mov ax,0124h                  ; 3
    mov cl,6                      ; 2
    rep stosw                     ; 2
    mov ax,24DDh                  ; 3
    stosw                         ; 1
    xchg al,cl                    ; 2
iloop:
    dec ax                        ; 1
    stosb                         ; 1
    loop iloop                    ; 2

    ; Decode and display data (51)
    ; Assumes CH=0, BX=0
    mov si,buffer                 ; 3
    mov di,codetab                ; 3
    mov ah,02h                    ; 2
cloop:
    lodsb                         ; 1
    mov cl,8                      ; 2
.loop:
    jcxz cloop                    ; 2
    dec cx                        ; 1
    shl al,1                      ; 2
    adc di,bx                     ; 2
    xor bx,bx                     ; 2
    or bl,[di]                    ; 2
    jns .loop                     ; 2
.found:
    not bl                        ; 2
    mov di,codetab                ; 3
    mov dl,[BYTE bx+di+charrel]   ; 3
    or dl,dl                      ; 2
    jnz .loop2                    ; 2
    ret                           ; 1
.loop2:
    xor bx,bx                     ; 2
    push ax                       ; 1
    int 21h                       ; 2
    xor al,13                     ; 2
    pop ax                        ; 1
    jnz .loop                     ; 2
    mov dl,10                     ; 2
    jmp SHORT .loop2              ; 2

; Include encoded text
buffer
    INCBIN 'text.enc'
    ; 473 bytes

; Alphabet
chartab
    db ' eaoltnrish',13,'pfmydcu.wvg,kS?PT-BINOYq',0
    ; 37 bytes

; Translation table
codetab
    db   2,  5 ; *
    db  -1,  1 ; 0*
    db  -2, 35 ; 01*
    db   2,  5 ; 1*
    db  34,  1 ; 10*
endcodetab
    ; 10 bytes

    ; Constants
charrel  EQU (chartab-codetab)
