{ COMPRESS.PAS:
        Compressor; takes the input file "TEXT.TXT" and generates
        the file "EXPAND.INC" which is a include file for the
        decompressor. }
const
  MaxNodes=1024;
  MaxBits=32;
  MaxAlpha=128;
  MaxBuffer=2048;
  MaxAlias=256;
type
  tNodePtr=^tNode;
  tNode=record
    Code:Integer;
    Weight:Longint;
    Left,Right:tNodePtr;
    end;
  tAlpha=record
    Weight:Longint;
    Size:Integer;
    Bits:array[0..MaxBits-1]of Byte;
    end;
var
  OutFile:Text;
  Root:tNodePtr;
  NodesCount,InternalNodes:Integer;
  Nodes:array[0..MaxNodes-1]of tNode;
  Alpha:array[0..MaxAlpha-1]of tAlpha;
  SizeInBuffer:Integer;
  InBuffer:array[0..MaxBuffer-1]of Byte;
  SizeBuffer:Integer;
  Buffer:array[0..MaxBuffer-1]of Byte;
  NodeSize:Integer;
  NodeBits:array[0..MaxBits-1]of Byte;
  AliasCount:Integer;
  Alias:array[0..MaxAlias-1]of Byte;

{$i COMPRESS.INC}

procedure VisitNode(Node:tNodePtr;Value:Byte);
begin
if Node=nil then Exit;
NodeBits[NodeSize]:=Value;
Inc(NodeSize);
if Node^.Code<$80 then with Alpha[Node^.Code] do
  begin
  Size:=NodeSize;
  Move(NodeBits,Bits,SizeOf(Bits));
  end;
VisitNode(Node^.Left,0);
VisitNode(Node^.Right,1);
Dec(NodeSize);
end;

procedure MakeThree;
var
  i,MinIndex:Integer;
  MinWeight:Longint;
begin
FillChar(Alpha,SizeOf(Alpha),0);
for i:=0 to SizeBuffer-1 do
  Inc(Alpha[Buffer[i]].Weight);
NodesCount:=0;
for i:=0 to MaxAlpha-1 do
  if Alpha[i].Weight>0 then
    begin
    with Nodes[NodesCount] do
      begin
      Code:=i;
      Weight:=Alpha[i].Weight;
      Left:=nil;
      Right:=nil;
      end;
    Inc(NodesCount);
    end;
InternalNodes:=0;
repeat
  MinWeight:=MaxLongint;
  MinIndex:=-1;
  for i:=0 to NodesCount-1 do with Nodes[i] do
    begin
    if (Weight<=0)or(Weight>=MinWeight) then Continue;
    MinWeight:=Weight;
    MinIndex:=i;
    end;
  with Nodes[NodesCount] do
    begin
    Weight:=MinWeight;
    Left:=@Nodes[MinIndex];
    end;
  Nodes[MinIndex].Weight:=0;
  MinWeight:=MaxLongint;
  MinIndex:=-1;
  for i:=0 to NodesCount-1 do with Nodes[i] do
    begin
    if (Weight<=0)or(Weight>=MinWeight) then Continue;
    MinWeight:=Weight;
    MinIndex:=i;
    end;
  if MinIndex<0 then Break;
  with Nodes[NodesCount] do
    begin
    Code:=$80+((InternalNodes+1)*2);
    Inc(InternalNodes);
    Inc(Weight,MinWeight);
    Right:=@Nodes[MinIndex];
    end;
  Nodes[MinIndex].Weight:=0;
  Inc(NodesCount);
until False;
Root:=@Nodes[NodesCount-1];
Root^.Code:=$80;
NodeSize:=0;
VisitNode(Root^.Left,0);
VisitNode(Root^.Right,1);
end;

procedure ReplaceWords;
label
  NextWord,NextPos;
var
  i,j,k,n:Integer;
  x:Longint;
  s:string;
  LastPos:array[0..MaxWords-1]of Integer;
begin
for i:=0 to MaxWords-1 do
  LastPos[i]:=-MaxInt;
AliasCount:=0;
SizeBuffer:=0;
i:=0;
while i<SizeInBuffer do
  begin
  for j:=0 to MaxWords-1 do
    begin
    s:=Words[j];
    n:=Length(s);
    for k:=0 to n-1 do
      if InBuffer[i+k]<>Ord(s[k+1]) then goto NextWord;
    if Chr(InBuffer[i+n])in['a'..'z'] then goto NextWord;
    x:=i;
    x:=x-LastPos[j];
    LastPos[j]:=i;
    if (x>0)and(x<=255) then
      begin
      Buffer[SizeBuffer]:=0;
      Inc(SizeBuffer);
      Inc(i,n);
      Alias[AliasCount]:=x;
      Inc(AliasCount);
      goto NextPos;
      end;
    NextWord:
    end;
  Buffer[SizeBuffer]:=InBuffer[i];
  Inc(SizeBuffer);
  Inc(i);
  NextPos:
  end;
Alias[AliasCount]:=0;
Inc(AliasCount);
end;

procedure WriteAlias;
var
  i:Integer;
  v:Boolean;
begin
Write(OutFile,'Alias label byte');
for i:=0 to AliasCount-1 do
  begin
  if i mod 8=0 then
    begin
    Writeln(OutFile);
    Write(OutFile,'db ');
    v:=False;
    end;
  if v then Write(OutFile,',');
  Write(OutFile,Alias[i]);
  v:=True;
  end;
Writeln(OutFile);
end;

procedure WriteThree;
var
  v:Boolean;
  i,j:Integer;
begin
Write(OutFile,'Three label byte');
for i:=0 to InternalNodes-1 do
  begin
  if i mod 8=0 then
    begin
    Writeln(OutFile);
    Write(OutFile,'db ');
    v:=False;
    end;
  for j:=0 to NodesCount-1 do with Nodes[j] do
    if Code=$80+(i*2) then
      begin
      if v then Write(OutFile,',');
      Write(OutFile,Left^.Code,',',Right^.Code);
      v:=True;
      Break;
      end;
  end;
Writeln(OutFile);
end;

procedure WriteStream;
var
  v:Boolean;
  i,j,k,n,x:Integer;
begin
Write(OutFile,'Stream label byte');
k:=0; n:=0; x:=0;
for i:=0 to SizeBuffer-1 do with Alpha[Buffer[i]] do
  begin
  if Weight=0 then Continue;
  for j:=0 to Size-1 do
    begin
    x:=x shr 1;
    if Bits[j]<>0 then x:=x or 128;
    Inc(n);
    if n>=8 then
      begin
      if k mod 16=0 then
	begin
	Writeln(OutFile);
	Write(OutFile,'db ');
	v:=False;
	end;
      Inc(k);
      if v then Write(OutFile,',');
      Write(OutFile,x);
      v:=True; n:=0; x:=0;
      end;
    end;
  end;
if n>0 then
  begin
  while n<8 do
    begin
    x:=x shr 1;
    Inc(n);
    end;
  if v then Write(OutFile,',');
  Write(OutFile,x);
  end;
end;

var
  c:Char;
  i:Integer;
  f:file;
begin
Write('Compressing input file (TEXT.TXT)... ');
Assign(f,'TEXT.TXT');
Reset(f,1);
if IOResult<>0 then Exit;
FillChar(InBuffer,SizeOf(InBuffer),0);
BlockRead(f,InBuffer,MaxBuffer,SizeInBuffer);
Close(f);
InBuffer[SizeInBuffer]:=0;
Inc(SizeInBuffer);
Assign(OutFile,'EXPAND.INC');
Rewrite(OutFile);
if IOResult<>0 then Exit;
for i:=0 to SizeInBuffer-1 do
  begin
  c:=Chr(InBuffer[i]);
  if c in['A'..'Z'] then
    c:=Chr(Ord(c)or 32);
  InBuffer[i]:=Ord(c);
  end;
ReplaceWords;
MakeThree;
WriteAlias;
WriteThree;
WriteStream;
Close(OutFile);
Writeln('Ok!');
end.
