{ Hugi compo #2 by Geza - the compressor, ThFP and Musztafa	 02-07-98  }
{									   }
{ Compile it with tp7.0 						   }

type
  PWord = ^Word;

const
  DS = 108;

var
  T: array[ 0..902 ] of Byte;
  R: array[ 0..902 ] of Byte;
  F: file;
  WPos, WBit: Byte;
  I: Integer;
  Pos: Integer;
  MaxPos, MaxLen: Integer;
  Bits: Integer;
  Nr: Integer;
  Chunk: array[ 0..1000 ] of Byte;
  CPos: Integer;

function Equal( TPos, RPos: Integer ): Integer;
  var
    Eq: Boolean;
    Len: Integer;
  begin
    Eq := True;
    Len := 0;
    while Eq and ( TPos < 903 ) do
      if T[ TPos ] = R[ RPos ]
	then
	  begin
	    Inc( Len );
	    Inc( TPos );
	    Inc( RPos );
	  end
	else
	  Eq := False;
    Equal := Len;
  end;

procedure Search( Pos: Integer; var MaxPos, MaxLen: Integer );
  var
    P, L: Integer;
    P2: Integer;
  begin
    MaxLen := 0;
    MaxPos := -1;
    P2 := Pos - 512;
    if P2 < 0 then P2 := 0;

    for P := Pos downto P2 do
      begin
	L := Equal( Pos, P );
	if L > MaxLen
	  then
	    begin
	      MaxPos := P;
	      MaxLen := L;
	    end;
      end;
  end;

procedure Flush;
  begin
    if WPos > 0 then
      begin
	Chunk[ CPos ] := WBit;
	Inc( CPos );
	WBit := 0;
	WPos := 0;
      end;
  end;

procedure PutBit( X: Byte );
  begin
    WBit := WBit or ( X shl WPos );
    Inc( WPos );
    if WPos = 8 then Flush;
  end;

procedure PutBits( X, Y: Integer );
  var
    I: Integer;
    M: Integer;
  begin
    M := 1 shl ( Y - 1 );
    for I := 1 to Y do
      begin
	PutBit( ( X and M ) div M );
	M := M shr 1;
      end;
  end;

begin
  Assign( F, 'TEXT.TXT' );
  Reset( F, 1 );
  BlockRead( F, T, 903 );
  Close( F );

  Assign( F, 'CHUNK.COM' );
  Reset( F, 1 );
  BlockRead( F, Chunk, DS );
  Close( F );
  CPos := DS;

  FillChar( R, 903, 255 );
  for I := 0 to 902 do if T[ I ] in [ 65..90 ] then T[ I ] := T[ I ] + 32;
  Pos := 0;
  Bits := 0;
  Nr := 0;

  while Pos < 903 do
    begin
      Search( Pos, MaxPos, MaxLen );
      if MaxLen <= 2
	then
	  begin
	    R[ Pos ] := T[ Pos ];

	    PutBit( 0 );

	    case Char( T[ Pos ] ) of
	      Char( 10 ): PutBits( 0, 5 );
	      Char( 13 ): PutBits( 1, 5 );
	      ' ':	  PutBits( 2, 5 );
	      ',':	  PutBits( 3, 5 );
	      '-':	  PutBits( 4, 5 );
	      '?':	  PutBits( 5, 5 );
	      '.':	  PutBits( 6, 5 );
	      'a'..'y':   PutBits( T[ Pos ] - 97 + 7, 5 );
	    end;

	    Bits := Bits + 6;
	    Pos := Pos + 1;
	    Inc( Nr );
	  end
	else
	  begin
	    if MaxLen > 10 then MaxLen := 10;
	    for I := 0 to MaxLen - 1 do R[ Pos + I ] := T[ Pos + I ];

	    PutBit( 1 );
	    PutBits( Pos - MaxPos, 9 );
	    PutBits( MaxLen - 3, 3 );
	    Bits := Bits + 13;
	    Pos := Pos + MaxLen;
	    Inc( Nr );
	  end;
    end;
  Flush;
  ( PWord( Longint( @Chunk ) + 1 ) )^ := CPos + 256;
  ( PWord( Longint( @Chunk ) + 7 ) )^ := Nr + 1;

  Assign( F, 'DTEXT.COM' );
  ReWrite( F, 1 );
  BlockWrite( F, Chunk, CPos );
  Close( F );
end.