{============================================================================}

uses

   crt,
   dos,
   grabag;

{============================================================================}

const

   removetemp = true;               { Set to true to delete temporary files. }

   maxlen     = 903;

   maxdict    = 100;

   version    = '3.55';

   textfile   = 'text.txt';

   compressed = 'compresd.txt';
   mooted     = 'mooted.txt';

   outfile    = 'ctext.inc';

   dictfile   = 'dict.txt';

{============================================================================}

type

   dictrec = record

                w  : string;
                c  : byte;

             end;

{============================================================================}

var

   data     : array[1..maxlen] of char;

   dict     : array[1..32] of string;

   dictsize : integer;

   tempdict : array[1..maxdict] of dictrec;

   tempsize : integer;

   f        : text;


{============================================================================}
(*
function string2moot(s : string) : string;

var

   i,
   tmp,
   mshift,
   mch,
   mlen       : byte;

   ch         : char;

   m          : string;

begin

   mlen   := ((length(s) * 5) div 8)+1;
   mshift := 0;
   mch    := 1;

   for i := 1 to mlen do begin

      m[i] := #0;

   end;

   m[0]   := chr(mlen);

   for i := 1 to length(s) do begin

      m[mch] := chr(ord(m[mch]) or ( (ord(s[i])-96) shl mshift));

      if mshift > 3 then begin

         mshift := 8 - mshift;

         mch := mch + 1;

         m[mch] := chr(ord(m[mch]) or ( (ord(s[i])-96) shr mshift));

         mshift := 5 - mshift;

      end

      else begin

         mshift := mshift + 5;

      end;

   end;

   string2moot := m;

end;

*)
{============================================================================}

function string2moot(s : string) : string;

var

   i,
   tmp,
   mshift,
   mch,
   mlen       : byte;

   ch         : char;

   m          : string;

begin

   mlen   := ((length(s) * 5) div 8)+1;
   mshift := 0;
   mch    := 1;

   for i := 1 to mlen do begin

      m[i] := #0;

   end;

   m[0]   := chr(mlen);

   for i := 1 to length(s) do begin

      m[mch] := chr(ord(m[mch]) or ( ((ord(s[i])-96) shl 3) shr mshift));

      if mshift > 3 then begin

         mshift := 8 - mshift;

         mch := mch + 1;

         m[mch] := chr(ord(m[mch]) or ( (ord(s[i])-96) shl (3 + mshift)));

         mshift := 5 - mshift;

      end

      else begin

         mshift := mshift + 5;

      end;

   end;

   string2moot := m;

end;


{============================================================================}

function readword(var f : text) : string;

var

   c    : char;

   w    : string;

begin


   w := '';

   read(f, c);

   while (c in [' ', #10, #13, '?', '-', '.', ',', #26]) and (not eof(f)) do begin

      read(f, c);

   end;


   while (not (c in [' ', #10, #13, '?', '-', '.', ',', #26]) ) and (not eof(f)) do begin

      w := w + c;

      read(f, c);

   end;

   readword := w;


end;

{============================================================================}

procedure sortdict;

var

   i,
   j      : integer;

   tmp    : dictrec;

begin


   for j := (tempsize-1) downto 1 do begin

      for i := 1 to j do begin

         if tempdict[i].c < tempdict[i+1].c then begin

            tmp := tempdict[i];
            tempdict[i] := tempdict[i+1];
            tempdict[i+1] := tmp;

         end;

      end;

   end;

   dictsize := 0;


   for i := 1 to 32 do begin

      if tempdict[i].c > 1 then begin

         inc(dictsize);

         dict[dictsize] := tempdict[i].w;

      end;

   end;

end;

{============================================================================}

procedure makedict(var f : text);

var

   w          : string;

   i          : integer;

   newword    : boolean;

begin

   writeln(' Creating dictionary for TEXT.TXT...');

   for i := 1 to maxdict do begin

      tempdict[i].w := '';
      tempdict[i].c := 0;

   end;


   repeat

      newword := true;

      w := lowercase(readword(f));


      for i := 1 to tempsize do begin

         if tempdict[i].w = w then begin

            newword := false;

            inc(tempdict[i].c);

         end;

      end;


      if newword then begin

         inc(tempsize);

         tempdict[tempsize].w := w;
         tempdict[tempsize].c := 1;

      end;

   until eof(f);

   writeln(' Sorting dictionary...');
   sortdict;

   writeln;

end;

{============================================================================}

procedure showdict;

var

   lines,
   i       : integer;

begin

   writeln('index |             word | occurances');
   writeln('------+------------------+------------------------------------------');

   lines := wherey;

   i := 1;

   while (i <= tempsize) and (tempdict[i].c > 1) do begin

      write(inttostr(i):5, ' | ');
      write(tempdict[i].w:16, ' | ');
      writeln(inttostr(tempdict[i].c));

      if i = 32 then writeln('               ^----- This is the 32nd entry. Optimal dictionary ends here.');

      if lines mod 23 = 0 then begin
         write('Press any key...');
         readkey;
         writeln;
      end;

      inc(lines);
      inc(i);

   end;

   write('Press any key...');
   readkey;
   writeln;
   writeln;

end;

{============================================================================}
(*
procedure mootit;

var

   m        : string;

   total,
   textsize,
   i,
   n        : integer;

   newline,
   wrotevar : boolean;

   c        : char;

   f, o     : text;

begin

   writeln(' Mooting Compressed Text...');

   assign(f, compressed);
   reset(f);

   assign(o, mooted);
   append(o);

   m     := '';
   n     := 0;
   total := 0;

   wrotevar := false;
   textsize := 0;

   while not eof(f) do begin

      newline := true;
      read(f, c);

      inc(textsize);
      inc(n);
      m := m + c;

      if (n = 40) or (eof(f)) then begin

         m := string2moot(m);

         total := total + length(m);

         for i := 1 to length(m) do begin

            if newline then begin

               if not wrotevar then begin

                  write(o, 'text     db ');
                  wrotevar := true;

               end else

                  write(o, '         db ');
                  newline := false;

            end;

            { write(o, byte2hex(ord(m[i]))); }

            write(o, inttostr(ord(m[i])):3);  { Write the value! }

            if (i = 13) or (i = length(m)) then newline := true;

            if newline then

               writeln(o, '')

            else

               write(o, ', ');

         end;

         m := '';
         n := 0;

      end;

   end;

   writeln(o, '');
   writeln(o, 'textsize equ ', textsize, '   ; Size in number of moots!');

   writeln('   Compressed text size: ', textsize, ' moots, ', total, ' bytes.');
   writeln;

   close(o);
   close(f);

end;
*)
{============================================================================}

function mootfile(var i, o : text) : integer;

var

   tmp,
   mshift,
   mlen       : byte;

   size       : integer;

   ich,
   och        : char;

begin

   mlen   := 0;
   mshift := 0;
   size   := 0;

   och    := #0;

   while not eof(i) do begin

      read(i, ich);

      { Exclude dictionary referenecs from count. }
      if not (ich in [#126, #127]) then
         inc(size);


      och := chr(ord(och) or ( ((ord(ich)-96) shl 3) shr mshift));

      if mshift > 3 then begin

         mshift := 8 - mshift;

         write(o, och);
         och := #0;

         och := chr(ord(och) or ( (ord(ich)-96) shl (3 + mshift)));

         mshift := 5 - mshift;

      end

      else begin

         mshift := mshift + 5;

      end;

   end;

   mootfile := size;

end;

{============================================================================}

procedure mootit;

var

   m        : string;

   total,
   textsize,
   i,
   n        : integer;

   c        : char;

   f, o     : text;

   b        : file of byte;

   tmp      : byte;

begin

   writeln(' Mooting Compressed Text...');

   m     := '';
   n     := 0;
   total := 0;

   textsize := 0;

   assign(o, mooted);
   rewrite(o);
   assign(f, compressed);
   reset(f);

   textsize := mootfile(f, o);

   close(o);
   close(f);

   assign(b, mooted);
   reset(b);

   assign(o, outfile);
   append(o);


   write(o, 'text     db ');

   while not eof(b) do begin

      read(b, tmp);
      c := chr(tmp);

      inc(n);
      inc(total);

      write(o, inttostr(ord(c)):3);  { Write the value! }

      if (n mod 13 = 0) then begin

         writeln(o, '');
         write(o, '         db ');

      end else if not eof(b) then

         write(o, ', ');

   end;

   { Remove null moot from beginning of file from the count. }
   dec(textsize);

   writeln(o, ', 96');
   writeln(o, '');
   writeln(o, 'textsize equ ', textsize, '   ; Size in number of moots!');

   writeln('   Compressed text size: ', textsize, ' moots, ', total, ' bytes.');
   writeln;

   close(o);
   close(b);

   if removetemp then
      del(mooted);

end;

{============================================================================}

procedure writedict;

var

   o         : text;

   m,
   out       : string;

   i         : integer;

   wrotevar,
   newline   : boolean;

begin

   writeln(' Writing Mooted Dictionary...');

   assign(o, outfile);
   rewrite(o);

   out := '';

   for i := 1 to dictsize do begin

      out := out + dict[i];

      if i < dictsize then out := out + '`';

   end;

   wrotevar := false;
   newline := true;

   m := string2moot(out);

   for i := 1 to length(m) do begin

      if newline then begin

         if not wrotevar then begin

            write(o, 'dict     db ');
            wrotevar := true;

         end else

            write(o, '         db ');
            newline := false;

      end;

      { write(o, byte2hex(ord(m[i]))); }

      write(o, inttostr(ord(m[i])):3);  { Write the value! }

      if (i mod 13 = 0) or (i = length(m)) then newline := true;

      if newline then

         writeln(o, '')

      else

         write(o, ', ');

   end;

   writeln(o, '');
   writeln(o, 'dictsize equ ', length(out), '   ; Size in number of moots!');
   writeln(o, '');

   writeln('   Dictionary size: ', length(out), ' moots, ', length(m), ' bytes.');
   writeln;

   close(o);

end;

{============================================================================}

function lookup(s : string) : byte;

var

   i : integer;

   result : byte;

begin

   result := 0;

   i := 1;

   while (i <= dictsize) and (result = 0) do begin

      if dict[i] = trimleft(lowercase(s)) then result := i;

      inc(i);

   end;

   lookup := result;

end;

{============================================================================}

function translate(s : String) : string;

var

   n : string;
   i : integer;

begin

   n := '';

   for i := 1 to length(s) do begin

      case s[i] of

         '.'  : n := n + #123;
         ' '  : n := n + #124;
         '?'  : n := n + #125 + #123;
         '-'  : n := n + #125 + #124;
         ','  : n := n + #125 + #125;


      else
            n := n + s[i];

      end;

   end;

   n := n + #96;  { cr/lf at end of line }

   translate := n;

end;

{============================================================================}

procedure compressit;

var

   tmp,
   c    : char;

   i    : integer;

   comp,
   s,
   w    : string;

   o    : text;

   leadspace,
   cap        : boolean;


begin

   writeln(' Compressing Text...');

   reset(f);

   comp := '';

   assign(o, compressed);
   rewrite(o);

   { First moot is a nul. :P }
   write(o, #0);

   while not eof(f) do begin

      readln(f, s);

      i := 1;

      while i <= length(s) do begin

         leadspace := false;
         cap       := false;

         w := '';

         while (s[i] = ' ') and (i <= length(s)) do begin { get spaces }

            comp := comp + s[i];
            inc(i);

         end;

         if (i > 1) and (s[i-1] = ' ') then begin

            comp[0] := chr(ord(comp[0])-1);
            leadspace := true;

         end;


         while (not (s[i] in [' ', '.', '?', '-', ','])) and (i <= length(s)) do begin { get word }

            w := w + s[i];
            inc(i);

         end;

         if w[1] in ['A'..'Z'] then

            cap := true;


         if lookup(w) <> 0 then begin

            w := chr(lookup(w)+96);

            if leadspace then
               w := #127 + w

            else
               w := #126 + w;

            if cap then
               w := #125 + lowercase(w);

         end

         else begin

            if cap then
               w := #125 + lowercase(w);

            if leadspace then
               w := ' ' + w;

         end;

         comp := comp + w;

         if s[i] in ['.', '?', '-', ','] then begin

            comp := comp + s[i];
            inc(i);

         end;

      end;

      write(o, translate(comp));

      comp := '';

   end;

   close(o);

end;

{============================================================================}

begin

   writeln;
   writeln('Moot-o-Matic v' + version + ' by Chris Gahan');
   writeln('(run with /d to display the dictionary)');
   writeln;

   tempsize := 0;

   assign(f, textfile);
   reset(f);

   makedict(f);

   sortdict;

   if caps(paramstr(1)) = '/D' then showdict;

   writedict;

   compressit;

   close(f);

   mootit;

   writeln(' Done! Results in '''+caps(outfile)+'''.');

   if removetemp then
      del(compressed);

end.

{============================================================================}
