PROGRAM MakeCom;

USES CRT,DOS;

CONST inname1   : String = 'Compo.ASM';
      inname2   : String = 'TEXT.ORG';
      outname   : String = 'BluE''s.ASM';
      CharTab   : ARRAY[0..31] OF CHAR = ('a','*','c','d','e','f','g','h',
                                          'i','j','k','l','m','n','o','p',
                                          'q','r','s','t','u','v','w','x',
                                          'y','b',' ','.',',','-','?','$');

VAR output        : ARRAY[0..5000] OF CHAR;
    save          : ARRAY[0..5000] OF CHAR;
    outpos        : WORD;
    savepos       : WORD;
    i,j           : integer;
    aktend,total  : word;
    fin,fout      : text;

    WordTab       : ARRAY[0..50] OF String;
    WordAnz       : BYTE;
    TempLine      : String;

{----------------------------------------------------------------------------}
PROCEDURE OpenReadFile(Name:String);

BEGIN
 assign(fin,name);
 {$I-}
 reset(fin);
 {$I+}
 IF ioresult <> 0 THEN
 BEGIN
  WriteLn('ERROR: InputFile ''',name,''' not found !');
  Halt(1);
 END;
END;

{----------------------------------------------------------------------------}
PROCEDURE OpenWriteFile(Name:String);

VAR pressedkey : char;

BEGIN
 ASSIGN(fout,Name);
 {$I-}
 RESET(fout);
 {$I-}
 IF IORESULT = 0 THEN
 BEGIN
  Write('WARNING: Outputfile ''',name,''' already exists ! OverWrite (Y/N) ? ');
  REPEAT
   pressedkey:=UPCASE(readkey);
  UNTIL (pressedkey = 'Y') OR (pressedkey = 'N');
  WriteLn(PressedKey);
  IF PressedKey = 'N' THEN HALT(2)
 END;
 ReWrite(fout);
END;

{----------------------------------------------------------------------------}
PROCEDURE CodeNumber(Number,BitAnz : BYTE);

BEGIN
 WHILE BitAnz > 0 DO
 BEGIN
  CASE ((Number SHR (BitAnz-1)) AND 1) OF
   0:  OutPut[OutPos]:='0';
   1:  OutPut[OutPos]:='1';
  END;
  INC(OutPos);
  DEC(BitAnz);
 END;
END;

{----------------------------------------------------------------------------}
PROCEDURE CodeString(WorkStr:String);

VAR n,m : WORD;

BEGIN
 FOR m:= 1 TO Length(WorkStr) DO
 BEGIN
  n:=0;
  WHILE WorkStr[m] <> CharTab[n] DO INC(n);
  CodeNumber(n,5);
 END;
END;

{----------------------------------------------------------------------------}
PROCEDURE MakeCode;

VAR i,j          : Integer;
    SpaceCount   : WORD;
    CharCount    : WORD;
    AktString    : String;
    AktPos       : WORD;
    CodeType     : Char;


BEGIN
 WordAnz:=0;
 OutPos:=0;
 FOR i:= 0 to 50 DO WordTab[i]:='';
 FOR i:= 0 to 10000 DO OutPut[i]:=' ';

 WHILE NOT(EOF(fin)) DO
 BEGIN
  AktPos:=1;                                            { set StartPos       }
  ReadLn(fin,TempLine);
  IF TempLine <> '' THEN
  IF (TempLine[1]='W') OR (TempLine[1]='C') THEN
  BEGIN
   CodeType:=TempLine[1];
   Delete(TempLine,1,2);
   SpaceCount:=0;
   CharCount:=0;
   AktString:='';
   {--- search wordstart ---}
   WHILE TempLine[AktPos] = ' ' DO
   BEGIN
    INC(AktPos);
    INC(SpaceCount);
   END;
   {--- get simple word ---}
   Delete(TempLine,1,SpaceCount);
   CharCount:=Length(TempLine);
   {--- code word or chars ---}
   {OutPut[OutPos]:=#13;OutPut[OutPos+1]:=#10;OutPos:=OutPos+2;}
   IF CodeType='W' THEN
   BEGIN
    i:=0;
    WHILE TempLine <> WordTab[i] DO
    BEGIN
     IF WordTab[i]='' THEN BEGIN
                            WordTab[i]:=TempLine;
                            Inc(WordAnz);
                            Dec(i);
                           END;
     INC(i);
    END;
    CodeNumber(SpaceCount,2);
    CodeNumber(1,1);                                     { flag word follows }
    CodeNumber(i,5);                                     { write wordnr.     }
   END
   ELSE BEGIN
    CodeNumber(SpaceCount,2);
    CodeNumber(0,1);                                     { flag chars follow }
    CodeNumber(Length(TempLine)-1,3);
    CodeString(TempLine);
   END;
  END;
  {--- Done ---}
 END;
 WriteLn(OutPos,' Bits used for text encoding ...');
END;

{----------------------------------------------------------------------------}
Function MakeByte(WorkStr:String):Byte;

VAR WorkByte : Byte;
    loop     : Integer;
    Dummy    : Integer;
    DummyStr : String[1];
    DummyByte: Byte;

BEGIN
 WorkByte:=0;
 FOR loop := 0 to (7 - Length(WorkStr)) DO WorkStr:=WorkStr+'0';
 FOR loop := 1 to 8 DO
 BEGIN
  DummyStr:=WorkStr[1];
  Delete(WorkStr,1,1);
  Val(DummyStr,DummyByte,Dummy);
  IF Dummy <> 0 THEN BEGIN WriteLn('Error in ',WorkStr,' !');Halt(2);END;
  WorkByte:=(WorkByte SHL 1)+(DummyByte AND 1);
 END;
 MakeByte:=WorkByte;
END;

{----------------------------------------------------------------------------}
PROCEDURE WriteData;

VAR a,b,c   : INTEGER;
    workstr : String;
    workpos : Word;
    workbyte: BYTE;
    count   : word;

BEGIN
 count:=0;
 WorkPos:=0;
 c:=8;
 WHILE WorkPos < OutPos DO
 BEGIN
  IF (OutPos-WorkPos) > 8 THEN b:=8
                          ELSE b:=OutPos-WorkPos;
  WorkStr:='';
  For a:= 1 to b DO
  BEGIN
   WorkStr:=WorkStr+OutPut[WorkPos];
   INC(WorkPos);
  END;
  WorkByte:=MakeByte(WorkStr);
  IF c < 8 THEN Write(fout,', ',WorkByte:3)
           ELSE BEGIN
                 c:=0;
                 WriteLn(fout);
                 Write(fout,'  db ',WorkByte:3);
                END;
  INC(c);
  INC(Count);
 END;
 Write(Count,' Bytes needed');
END;

{----------------------------------------------------------------------------}
PROCEDURE WriteWords;

VAR loop : Integer;

BEGIN
 WriteLn(WordAnz,' words used ...');
 OutPos:=0;
 FOR loop:= 0 TO WordAnz-1 DO
 BEGIN
  CodeNumber(Length(WordTab[loop])-1,3);
  CodeString(WordTab[loop]);
 END;
 WriteLn(OutPos,' Bits used for word encoding ...');

 WriteLn(fout);
 Write(fout,' LABEL WordData');
 WriteData;
 WriteLn(fout);
 WriteLn(' for word encoding ...');
END;

{----------------------------------------------------------------------------}
PROCEDURE WriteTextData;

BEGIN
 WriteLn(fout);
 Write(fout,' LABEL TextData');
 WriteData;
 WriteLn(fout);
 WriteLn(' for text encoding ...');
END;

{----------------------------------------------------------------------------}
BEGIN
 IF ParamCount > 0 THEN inname1:=ParamStr(1);
 IF ParamCount > 1 THEN inname2:=ParamStr(2);
 IF ParamCount > 2 THEN outname:=ParamStr(3);
 WriteLn;
 Write('Writing Blue''s contribution to HUGI size coding compo #2 to ');
 WriteLn('''',outname,''' ...');

 OpenReadFile(inname1);
 OpenWriteFile(outname);
 WHILE NOT(EOF(fin)) DO
 BEGIN
  ReadLn(fin,TempLine);
  WriteLn(fout,TempLine);
 END;
 Close(fin);

 OpenReadFile(inname2);
 MakeCode;
 move(output,save,5000);
 savepos:=outpos;
 WriteWords;
 move(save,output,5000);
 outpos:=savepos;
 WriteTextData;

 WriteLn(fout);
 WriteLn(fout,'LABEL TextEnd');
 WriteLn(fout);
 WriteLn(fout,'ENDS CompoCode');
 WriteLn(fout,';-----------------------------------------------------------------------------');
 WriteLn(fout,'END Main');
 WriteLn(fout,';-----------------------------------------------------------------------------');

 close(fin);
 close(fout);

 assign(fout,'usedword.txt');
 rewrite(fout);
 FOR i:=0 TO wordanz-1 DO
  WriteLn(fout,WordTab[i]);
 close(fout);
END.