{$G+}
PROGRAM PACK;
CONST
  MAXDATA=1000;
  ENDOFDATA=0;
TYPE
  DATA=ARRAY[1..MAXDATA] OF BYTE;

PROCEDURE BITSCOMPRESSION(DATA2CMP:ARRAY OF BYTE;VAR COMPRESSED_DATA:ARRAY OF BYTE);
VAR
  NEWDATA:ARRAY[0..6] OF BYTE;
  DTASEG,DTAOFS:WORD;
  NDTASEG,NDTAOFS:WORD;
BEGIN
  DTASEG:=SEG(DATA2CMP);DTAOFS:=OFS(DATA2CMP);
  NDTASEG:=SEG(NEWDATA);NDTAOFS:=OFS(NEWDATA);
  ASM
     MOV DI,DTAOFS
     MOV SI,NDTAOFS
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,5
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,3
     MOV BYTE PTR ES:[SI],AH;INC SI
     SHL AX,2
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,5
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,1
     MOV BYTE PTR ES:[SI],AH;INC SI
     SHL AX,4
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,4
     MOV BYTE PTR ES:[SI],AH;INC SI
     SHL AX,1
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,5
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,2
     MOV BYTE PTR ES:[SI],AH;INC SI
     SHL AX,3
     MOV AL,BYTE PTR ES:[DI];INC DI;SHL AL,3
     SHL AX,5
     MOV BYTE PTR ES:[SI],AH;INC SI
  END;
  MOVE(NEWDATA,COMPRESSED_DATA,7);
END;

PROCEDURE COMPRESSBITS(DTA2CMP:DATA;VAR CMPDTA:DATA;SIZEOF_DATA2CMP:WORD;VAR SIZEOF_CMPDTA:WORD);
VAR
   DATAIN,DATAOUT:ARRAY[0..7] OF BYTE;
   DTA2CMP_POS,CMPDTA_POS,A:WORD;
BEGIN
   DTA2CMP_POS:=1;CMPDTA_POS:=1;
   SIZEOF_CMPDTA:=0;
   REPEAT
     FOR A:=0 TO 7 DO DATAIN[A]:=DTA2CMP[DTA2CMP_POS+A];
     IF SIZEOF_DATA2CMP-DTA2CMP_POS<7
     THEN BEGIN
          WRITELN;
          WRITELN(#7,'DATA IS NOT COMPATIBLE WITH COMPRESSOR!!');
          WRITELN;
          HALT;
          END
     ELSE SIZEOF_CMPDTA:=SIZEOF_CMPDTA+5;
     DTA2CMP_POS:=DTA2CMP_POS+8;
     BITSCOMPRESSION(DATAIN,DATAOUT);
     FOR A:=0 TO 4 DO CMPDTA[CMPDTA_POS+A]:=DATAOUT[A];
     CMPDTA_POS:=CMPDTA_POS+5;
   UNTIL DTA2CMP_POS >= SIZEOF_DATA2CMP;
END;

PROCEDURE SPECIAL_COMPRESSION(DTA2CMP:DATA;VAR CMPDTA:DATA;SIZEOF_DATA2CMP:WORD;VAR SIZEOF_CMPDTA:WORD);
CONST
   CMPTBL1BYTE:ARRAY[0..23] OF CHAR = ('a','c','d','e','f','g','h','i','k','l',
                                       'm','n','o','p','r','s','t','u','w',
                                       'y','S','.',',',' ');
   STARTCMP2BYTE=24;
   CMPTBL2BYTE:ARRAY[1..11] OF CHAR = ('B','I','N','O','P','T','Y','q','?','-','v');
   STRCMPTBL:ARRAY[25..31] OF ARRAY[1..2] OF CHAR = (
             (' ',' '),(#$D,#$A),('t','h'),('i','n'),('r','e'),('a','n'),('p','l'));
VAR
   A,B:INTEGER;
   COMPRESSED:BOOLEAN;
   CMPDTA_POS:WORD;
BEGIN
   CMPDTA_POS:=1;
   FOR A:=1 TO SIZEOF_DATA2CMP DO
   BEGIN
      COMPRESSED:=FALSE;
      FOR B:=25 TO 31 DO
      BEGIN
         IF (DTA2CMP[A]=BYTE(STRCMPTBL[B,1])) AND (DTA2CMP[A+1]=BYTE(STRCMPTBL[B,2])) THEN
         BEGIN
            CMPDTA[CMPDTA_POS]:=B;
            INC(CMPDTA_POS);
            A:=A+1;
            COMPRESSED:=TRUE;
         END;
      END;
      IF NOT(COMPRESSED) THEN
      FOR B:=1 TO 11 DO
      BEGIN
         IF DTA2CMP[A]=BYTE(CMPTBL2BYTE[B]) THEN
         BEGIN
            CMPDTA[CMPDTA_POS]:=STARTCMP2BYTE;
            INC(CMPDTA_POS);
            CMPDTA[CMPDTA_POS]:=B;
            INC(CMPDTA_POS);
            COMPRESSED:=TRUE;
         END;
      END;
      IF NOT(COMPRESSED) THEN
      FOR B:=0 TO 23 DO
      BEGIN
         IF DTA2CMP[A]=BYTE(CMPTBL1BYTE[B]) THEN
         BEGIN
            CMPDTA[CMPDTA_POS]:=B;
            INC(CMPDTA_POS);
            COMPRESSED:=TRUE;
         END;
      END;
      IF NOT(COMPRESSED) THEN
      BEGIN
          WRITELN;
          WRITELN(#7,'DATA IS NOT COMPATIBLE WITH COMPRESSOR!');
          WRITELN;
          HALT;
      END;
   END;
   SIZEOF_CMPDTA:=CMPDTA_POS-1;
END;

VAR
   SOURCE_FILE,CODE_FILE,DESTINATION_FILE:FILE;
   DATABUF1,DATABUF2:DATA;
   NOT_COMPRESS_SIZE,COMPRESSED_SIZE,SWAP:WORD;
BEGIN
   WRITELN;
   WRITELN('CREATED BY ANG CHIN KEONG (chinkeog@tm.net.my)');
   WRITELN('FOR HUGI COMPO #2 AT http://home.pages.de/~hugi-compo');
   WRITELN;
   ASSIGN(SOURCE_FILE,'TEXT.TXT');
   RESET(SOURCE_FILE,1);
   ASSIGN(CODE_FILE,'UNPACK.COM');
   RESET(CODE_FILE,1);
   ASSIGN(DESTINATION_FILE,'TEXT.COM');
   REWRITE(DESTINATION_FILE,1);
   IF FILESIZE(SOURCE_FILE) > MAXDATA THEN HALT;
   IF FILESIZE(CODE_FILE) > MAXDATA THEN HALT;
   NOT_COMPRESS_SIZE:=FILESIZE(SOURCE_FILE);
   BLOCKREAD(CODE_FILE,DATABUF1,FILESIZE(CODE_FILE));
   BLOCKWRITE(DESTINATION_FILE,DATABUF1,FILESIZE(CODE_FILE));
   BLOCKREAD(SOURCE_FILE,DATABUF1,NOT_COMPRESS_SIZE);
   WRITELN('TEXT TO COMPRESS : ',NOT_COMPRESS_SIZE,' bytes.');
   WRITELN;
   WRITE('1ST COMPRESSION  : COMPRESSING......');
   SPECIAL_COMPRESSION(DATABUF1,DATABUF2,NOT_COMPRESS_SIZE,COMPRESSED_SIZE);
   WRITE('DONE.   ');
   WRITELN(NOT_COMPRESS_SIZE,' bytes =>',COMPRESSED_SIZE,' bytes.');
   NOT_COMPRESS_SIZE:=COMPRESSED_SIZE;
   COMPRESSBITS(DATABUF2,DATABUF1,NOT_COMPRESS_SIZE,COMPRESSED_SIZE);
   WRITE('2ND COMPRESSION  : COMPRESSING......');
   WRITE('DONE.   ');
   WRITELN(NOT_COMPRESS_SIZE,' bytes =>',COMPRESSED_SIZE,' bytes.');
   BLOCKWRITE(DESTINATION_FILE,DATABUF1,COMPRESSED_SIZE);
   WRITELN;
   WRITELN('COMPRESSED DATA  : ',COMPRESSED_SIZE,' bytes');
   WRITELN('DECOMPRESSOR SIZE: ',FILESIZE(CODE_FILE),' bytes');
   WRITELN('COM FILE SIZE    : ',FILESIZE(CODE_FILE)+COMPRESSED_SIZE,' bytes');
   WRITELN;
   CLOSE(CODE_FILE);
   CLOSE(DESTINATION_FILE);
   CLOSE(SOURCE_FILE);
END.