; Hugi Size Coding Competition #29 - Source code by schnaader

Cols	equ 27			;dimensions of maze (cells)
Rows	equ 12
Cell	equ 666h		;our cell connected status is stored at the home of the hex-beast
Seed    equ 4E35h		;magic RNG number, also used as the position of itself in memory
				;DI is set to this value at the beginning so it can be used to access the seed
Output  equ 7CCDh		;text output buffer, its address is magical, see the house draw routine

	org	100h

start:	

; Initialize 27*12 cells with FFh and the inner 25*10 cells with 0
	dec	ax
	mov	di, Cell
	push	di		;Push the number of the hex-beast - we need it later
	rep	stosw		;CX = 00FF at the beginning, so this will fill up 27*12 cells and some more
	mov	di, Cell + Cols-1
	inc	ax
	mov	cl, Rows-2
initl: 	push	cx
	inc	di
	inc	di
	mov	cl, Cols-2
	rep	stosb
	pop	cx
	loop 	initl

; Initialize output buffer
	mov	di, Output
	push	di		;put adress of Output on stack, we'll need it later

	; Fill every even line with a loop of '+--', every odd line with a loop of '|  '
	mov	cl, 11
ceil1:  push 	cx

	mov	ax, '+-'
	call	FillLine
	mov	ax, '| '
	call	FillLine

	pop	cx
	loop	ceil1

	; Draw ghost and house
	mov	di, Output + 78
	mov	al, 02h
	stosb
	not	di              ;The address of Output is chosen so that this will be the same
				;result as for add di, 78*18+75 (saves 1 byte :)
	dec	di
	mov	al, 7Fh
	stosb

;get starting seed from the command line

	mov	si, 81h		;point to info on command line
	xor	dx, dx		;zero accumulator

ni10:	lodsb
	cmp	al, 0Dh		;carriage return?
	je	ni20		;exit if so
	sub	al, '0'		;is it a digit?
	js	ni10		;loop if not (signed bit is set for CR and space)
	imul	dx, 10
	add	dl, al
	jmp	ni10		;loop until 0Dh is found

ni20:
	mov	di, Seed
        mov	[di], dx

;Randomly pick a starting cell

	mov	al, Cols-2	;ConnectFrom(Ran(Cols-2), Ran(Rows-2))
	call	Ran
	mov	cl, bl		;CH = 0 from before
	mov	al, Rows-2
	call	Ran
	mov	dl, bl		;DH = 0 from before
	call	ConFrom

;Display the maze output buffer

	pop	si		;Get adress of Output from stack
	pop	cx		;Pop the number of the hex-beast which is the size of our output buffer (21*78) :)
l1:	lodsb
	call	ConOut
	loop	l1

	;No ret here, one more ConFrom won't hurt :)

;-------------------------------------------------------------------------------
;Connect cells starting from cell X=cx, Y=dx
;
ConFrom:
	
	pusha

;Mark current cell as connected

	call	CalcCellSi
	inc	byte [si]	;set the connected flag. This works because we only cross non-connected fields

	mov	al, 4		;randomly choose a direction
	call	Ran		;BL = direction
	mov	bh, 4		;BH stores a countdown from 4

;Try to connect to a cell at direction Dir

con50:	pusha

	mov	al, bl
	inc	cx
	cmp	al, 0
	je	con51		; 0 => X + 1, Y
	dec	cx
	inc	dx
	cmp	al, 1
	je	con51		; 1 => X, Y + 1
	dec	cx
	dec	dx
	cmp	al, 2
	je	con51		; 2 => X - 1, Y
	inc	cx
	dec	dx
				; 3 => X, Y - 1

con51:  call	CalcCellSi
	lodsb
	and     al, 1

	jne	con59		;jump if next cell is already connected

	; Dir = 2 => inc cx
	; Dir = 3 => inc dx

	pusha
	cmp 	bl, 2
	je	con52
	jl	con53		;Dir < 2? -> change nothing
	inc	dx
	dec	cx

	;remove a wall in the output buffer

con52:  inc	cx
con53:	
	imul	cx, 3
	imul	di, dx, 78*2
	add	di, Output+1
	add 	di, cx
	test	bl, 1			;Dir left/right or up/down? -> Left wall or ceiling?
	jnz	RemoveH
	add	di, 77
RemoveH:
	mov	ax, 2020h		;two space characters
	stosw

	popa

	call	ConFrom

con59:	popa

;Next direction

	inc	bx
	and	bl, 3h

	dec	bh			;loop 4 times
	jnz	con50

con99:	popa

	;No ret here. SI is overwritten after ConFrom calls, so this won't change anything.

;Get adress of cell connected status (cx=X, dx=Y)
CalcCellSi:
	imul	si, dx, Cols
	add	si, cx
	add	si, Cell+Cols+1		;We start at X=1, Y=1 here
	ret

;-------------------------------------------------------------------------------
;Return random number between 0 and ax-1
; return remainder(Random/N)
;
Ran:	push	cx
	push	dx

	mov	cl, al

	mov	dx, [di]	;Get seed
	mov	ax, di
	imul	dx
	inc	ax
	mov	[di], ax	
	shr	ax, 8		;Random number = Seed >> 8

	xor	dx, dx
	idiv	cx
	mov	bl, dl		;return remainder in bl

	pop	dx
	pop	cx
	ret

;-------------------------------------------------------------------------------
;Display the character in al on the console (using a method that can be
; redirected to a file)
ConOut:
	
	pusha

	mov	dl, al		;get character
	mov	ah, 02h		;set function for character output
	int	21h		;DOS call

	popa
	ret

FillLine:

	mov	cl, 25
flloop: stosw
	xchg	al, ah
	stosb
	xchg	al, ah
	loop	flloop
	stosb
	mov	ax, 0A0Dh
	stosw

	ret