;Espineter from Spain 120 bytes official hc29 compo (nasm entry.asm -o entry.com)
org     256
        db      -52+1              ;2nd table value, 1st at 00FF is -1+1=0
        db      1+1                ;3rd table value, 4th is 52+1 (xor ax,imm opcode)
        xor     ax,'-+'            ;init AX to '+' and '-' chars
        db      0B5h               ;mov ch,68h
main0   push    0D0Ah              ;reset some memory (with CRLF) before and after the maze
        loop    main0
        push    cx                 ;return address is 0000 (int 20h) after final ret
        db      0bfh               ;mov di, 04335h & push di (4x1), init pointer to maze
main1   xor     ax,'-+'^7C6Eh      ;change '-+' by 'x|' and viceversa (x is FD)
        mov     cl,25              ;number 3bytes secuence per line
        mov     [di],ah            ;print the column 0 char '+' or '|'
        cmpsb                      ;increment di
main2   stosb                      ;print the first of 2 char '-' or FD
        stosw                      ;print the second '-' or FD and then '+' or '|'
        loop    main2              ;repeat 3bytes 25 times
        cmpsw                      ;put CR+LF and finds end of lines marker 09EB<0A0D
        jnb     main1              ;21 times (10*2+1)
        movsb                      ;put '$', end of string mark for ah=09 int 21h
        xchg    ax,di              ;low byte of DI is 9Ch (2*78), I will need it later
        xchg    ax,cx              ;reset ax, ah*10+al will be the init value for dx
        mov     di,04335h+78       ;point to ghost position, last byte has "inc bx" opcode
main3   aad                        ;ah=ah*10+al
        xchg    ax,dx              ;dl=seed
        mov     ah,dl              ;ah=dl=seed
        mov     al,05Dh            ;point al to FCB1
        xlat                       ;read byte from 5D+bx
        sub     al,'0'             ;convert '0' to 0, '1' to 1, etc.
        jnc     main3-1            ;if number decode and add to Seed (-1 is for hidden inc bx)
        movsb                      ;paint ghost and point to cell (0,0) 
        lodsw                      ;skip pop dx, int 21h (1st byte). SI point rnd routine
        call    si                 ;generate 16bit random value
        aam     25                 ;extract remainder in AL
        mul     bl                 ;multiply by 3 (column offset of random X coordinate)
        add     di,ax              ;Add offset to cell. Now DI points to (randomX, 0)
        call    si                 ;generate next random, for Y coordinate
        aam     10                 ;remainder in AL
        call    main4              ;init recursion, last byte is 00 (marker for 21 lines)
        db      '$',2              ;end of string and ghost (and al,2 do nothing when returns)
        pop     dx                 ;restore pointer (from hidden push di) to maze in DX
        db      0CDh  ; == int 21h ;print the generated maze and exit (via ret of rnd routine)
rnd     and     [di+bp],cx         ;ANDing the wall
        imul    dx,4E35h           ;random number generator routine as example.asm
        inc     dx                 ;+1 for avoid zero cycle
        mov     al,dh              ;high byte of Seed in AL
        mov     bl,3               ;init BL to 3
        ret
main4   mul     cl                 ;multiply by 2*78 (offset for Y)
        add     di,ax              ;add offset. Now DI points to (randomX, randomY)
        xchg    ax,cx              ;AX=499C, CX=2*78*RND(10)
conf    xchg    ax,bp              ;first time AH=9, BP=499C. Then BP=AX=offset for wall
        or      [bp-82],bl         ;converts 7C into 7F (home char) the first time
        mov     cx,2020h           ;Prepare CX for ANDing (convert cell/wall to spaces)
        and     [di],cx            ;ANDing the next cell
        call    si                 ;generates 16bit random, 8bit in AL, 2bit needed in lower AL
conf1   push    ax                 ;save current direction
        push    di                 ;save current position
        or      al,0FCh            ;delete every except 2 LSB, [BX+AL]= table value
        xlat                       ;AL= offset/3+1
        dec     ax                 ;AL= offset/3
        imul    bl                 ;AX= offset
        sub     di,ax              ;point to the next random neighbor cell
        cmp     di,[di]            ;test if the next cell is visited
        jnb     conf2              ;if so, go to conf2
        sar     ax,1               ;calculate the position of the wall
        call    conf               ;do recursion
conf2   pop     di                 ;restores position
        pop     ax                 ;restores direction
        inc     ax                 ;next direction
        loop    conf1              ;repeat 4 times (not exactly 4 times but we're saving bytes)
        ret