;Hugi Size Coding Competition 29
;submitted by DevFred <fredsose07@gmx.de> on October 16th
;compile with "nasm -o entry.com entry.asm"

%define WIDTH  25
%define HEIGHT 10
%define LINES (2 * (HEIGHT + 1))

%define DX 3
%define W ((WIDTH + 1) * DX)
%define DY (2 * W)

%define maze 0a0dh              ;place maze at a convenient address ;)

org 100h

;------------------------------------------------------------------------------

    mov si, 5dh                 ;many thanks to claw for this hint!
load_symbol:
    mov ah, bl                  ;al = current digit       ah = seed
    aad                         ;al = seed * 10 + digit   ah = 0
    xchg ax, bx                 ;bx = seed

    lodsb
    sub al, '0'                 ;any symbol below 30h
    jnb load_symbol             ; is a terminator

    mov fs, bx                  ;fs = seed

;------------------------------------------------------------------------------

    mov cl, WIDTH
    call random
    imul bp, dx, byte DX        ;bp = random(WIDTH) * DX

    mov cl, HEIGHT
    call random
    imul bx, dx, word DY        ;bx = random(HEIGHT) * DY
    add bx, bp                  ;   + random(WIDTH)  * DX

;------------------------------------------------------------------------------

crlf_minus_one:
    mov di, maze
    mov ax, (LINES << 8) | '|'  ;ah = loop counter

generate_line:
    mov cl, WIDTH

generate_three_symbols:
    stosb                       ;| or +
    xchg ax, bp
    stosw                       ;dummy on first iteration, '--' after that
    xchg ax, bp
    loop generate_three_symbols

    stosb                       ;| or +
    mov si, crlf_minus_one + 1
    movsw                       ;CRLF

    xor al, '|' ^ '+'           ;switch between | and +
    mov bp, '--'
    dec ah
    jnz generate_line

;------------------------------------------------------------------------------

    mov cl, 7fh
    mov [di - W - DX], cl       ;place the house at the exit
    mov al, '$'                 ;string terminator for output via DOS
    rep stosb                   ;fill bottom dummy line (plus 49 bytes)

    mov di, maze + DY
    mov ax, 0902h               ;ah = 09h for output via int 21h later
    stosb                       ;place the smiley at the entry

    call visit                  ;start the recursive algorithm

    mov dx, maze + W
    int 21h                     ;print the maze

   ;ret                         ;falling through doesn't hurt

;------------------------------------------------------------------------------

random_direction:
    mov cl, 4
random:
    mov ax, fs
    imul ax, ax, word 4e35h     ;seed = seed * 0x4e35
    inc ax                      ;     + 1
    mov fs, ax

    shr ax, 8                   ;result = (seed >> 8)
    cwd
    div cx                      ;       % bound
    ret

;------------------------------------------------------------------------------

visit:
    pusha
    add di, bx                  ;enter cell

    call random_direction
    mov si, directions
    add si, dx                  ;choose random starting direction

    mov dx, '  '
    mov [di], dx                ;mark current cell as visited

visit_loop:
    lodsb
    cbw
    imul bx, ax, byte 3         ;bx = position delta of next cell

    cmp [di + bx], bp           ;only unvisited real cells contain --
    jne visited

    call visit                  ;recurse

    sar bx, 1                   ;wall is halfway to the next cell
    mov [di + bx], dx           ;tear down the wall

visited:
    loop visit_loop
    popa
    ret

;------------------------------------------------------------------------------

directions:
    db 1, 52, -1, -52
    db 1, 52, -1
