;Event:   29th Hugi Size Coding Compo
;Author:  Akos Fekete (alias: Chut)
;Country: Hungary
;E-mail:  fekete.akos@freemail.hu
;Compiler:Flat Assembler 1.69
;Comment: This code is only a modification of the example.

B		EQU	BYTE

		ORG	0100h		;

		;Init board

		MOV	BP,Print3	;BP->Print3
		MOV	DI,Cell2	;DI->Cell2
		MOV	BH,1Fh		;
ma20:		DEC	BX		;
		MOV	B[Cell0+BX],1	;
		MOV	B[DI+BX],0	;
		JNZ	ma20		;

		;Get number

		MOV	SI,0082h	;
		CMP	AL,[SI-02h]	;
		JE	NumOK		;
NumIn:		IMUL	BX,BX,10	;
		ADD	BX,AX		;
		LODSB			;
		SUB	AL,30h		;
		JAE	NumIn		;
NumOK:		MOV	[DI+BP],BX	;

		;Make board

		MOV	CL,25		;start X = RND(0..24)
		CALL	Ran		;
		XCHG	AX,BX		;
		MOV	CL,10		;start Y = RND(0..9)
		CALL	Ran		;
		MOV	BH,AL		;BH=Y BL=X
		CALL	ConFrom 	;

		;Display board

		MOV	BH,0		;Y pointer

		;Display horizontal wall line

ma50:		MOV	BL,0		;X pointer

		MOV	CL,25		;
ma60:		CMP	[Cell1+BX],CH	;
		MOV	AL,StrPSS-256	;"+  "
		JE	ma65		;
		MOV	AL,StrPMM-256	;"+--"
ma65:		CALL	BP		;
		INC	BX		;next X
		LOOP	ma60		;
		MOV	AL,StrPCL-256	;
		CALL	BP		;
		CMP	BH,10		;
		JAE	EXIT		;

		;Display vertical wall line with its complications

		MOV	CL,25		;
		MOV	AL,StrGSS-256	;Ghost or wall?
		AND	BX,0F00h	;
		JZ	ma69a		;
ma68:		MOV	AL,StrWSS-256	;
ma69a:		CALL	BP		;
		INC	BX		;next X
ma70:		DEC	CX		;
		JCXZ	ma75		;
		CMP	B[Cell0+BX],CH	;
		MOV	AL,StrSSS-256	;"   "
		JNE	ma68		;
		JMP	ma69a		;

ma75:		MOV	AL,StrWCL-256	;House or wall?
		CMP	BH,9		;
		JNE	ma80		;
		MOV	AL,StrHCL-256	;
ma80:		CALL	BP		;

		INC	BH		;
		JMP	ma50		;
;-------------------------------------------------------------------------------
Print3: 	MOV	AH,01h		;
		XCHG	AX,SI		;
		LODSB			;
		CALL	ConOut		;
		LODSB			;
		CALL	ConOut		;
		LODSB			;
ConOut: 	MOV	DL,AL		;get character
		MOV	AH,02h		;set function for character output
		INT	21h		;DOS call
		RET			;

StrPMM: 	DB	'+','-','-'	;ceiling
StrPSS: 	DB	'+',' ',' '	;no ceiling
StrWSS: 	DB	'|',' ',' '	;left wall
StrGSS: 	DB	002		;ghost + spaces
StrSSS: 	DB	' ',' ',' '	;no wall
StrPCL: 	DB	'+',013,010	;
StrWCL: 	DB	'|',013,010	;
StrHCL: 	DB	127,013,010	;
;-------------------------------------------------------------------------------
Ran:		IMUL	AX,[DI+BP],4E35h;
		INC	AX		;Seed:= Seed * Multiplier + 1
		MOV	[DI+BP],AX	;Random number = Seed >> 8
		SHR	AX,8		;
		CWD			;
		IDIV	CX		;
		XCHG	AX,DX		;return remainder in AX
EXIT:		RET			;
;-------------------------------------------------------------------------------
ConFrom:	PUSH	AX		;save variables

		MOV	CL,4		;randomly choose a direction
		CALL	Ran		;AX=RND(0..3)

		MOV	B[DI+BX],1	;This cell is connected.

con05:		PUSH	BX		;

con10:		CMP	AL,0		;right field?
		JNE	con20		;
		INC	BX		;X+1
		CMP	BL,25		;check end of this side
		JAE	con90		;
		CMP	[DI+BX],DH	;is already connected?
		JNE	con90		;
		MOV	[Cell0+BX],DH	;reset left wall
		JMP	con80		;

con20:		CMP	AL,1		;bottom field?
		JNE	con30		;
		INC	BH		;Y+1
		CMP	BH,10		;
		JAE	con90		;
		CMP	[DI+BX],DH	;is already connected?
		JNE	con90		;
		MOV	[Cell1+BX],DH	;reset ceiling
		JMP	con80		;

con30:		CMP	AL,2		;left field?
		JNE	con40		;
		DEC	BL		;X-1
		JS	con90		;
		CMP	[DI+BX],DH	;is already connected?
		JNE	con90		;
		MOV	[Cell0+BX+1],DH ;reset left wall
		JMP	con80		;

con40:		CMP	AL,3		;upper field?
		JNE	con90		;
		DEC	BH		;Y-1
		JS	con90		;
		CMP	[DI+BX],DH	;is already connected?
		JNE	con90		;
		MOV	[Cell1+BX+256],DH;reset ceiling

con80:		CALL	ConFrom 	;connect rest of cells starting from here

con90:		POP	BX		;
		INC	AX		;
		JNS	con05		;
		POP	AX		;restore variables
		RET			;

;-------------------------------------------------------------------------------
Cell0:		DB	4096 dup(?)	;arrays of cells describing the maze
Cell1:		DB	4096 dup(?)	;
Cell2:		DB	8192 dup(?)	;