	page	240, 132
;EXAMPLE.ASM	7-Dec-2005	Boreal		loren_blaney@idcomm.com
;Sudoku Puzzle Solver for Hugi Compo 25
;Usage: example <1.puz
;Assemble with:
; tasm
; tlink /t

	.386
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h		;this is a COM program so skip its PSP
;Load Puzzle from stdin

main:	mov	bx, 0		;for J:= 0, 81-1 do...
main10:	mov	ah, 08h		;read digit from stdin
	int	21h
	sub	al, '.'		;convert '.' to 0
	je	main15
	add	al, '.'		;restore character in al
	sub	al, '0'		;convert ASCII digit to binary
	jb	main20		;skip space characters, cr's and lf's
main15:	mov	[bx+puzzle], al	;store digit into puzzle array
	inc	bx		;next puzzle cell
main20:	cmp	bx, 81		;loop until puzzle array is filled
	jne	main10

	mov	bx, 0		;start search from the first cell
	call	solve		;go solve it
	call	show		;show the result
	mov	ax, 4C00h	;exit program
	int	21h

;-------------------------------------------------------------------------------
;Solve the puzzle using backtracking (recursive tree search)

solve:	push	bx		;save index (I) into puzzle array (0..81)
	push	dx		;save Digit

	cmp	bx, 81		;if I >= 81 then
	jl	solve10		; (jump if not)
	call	show		; show solution
	mov	ax, 4C00h	; exit program
	int	21h
solve10:
	cmp	[bx+puzzle], 0	;is cell empty?; if Puzzle(I) = 0 then...
	jne	solve30		;(jump if not)

	mov	dl, 1		;try all 9 digits...; for Digit:= 1, 9 do...
solve20:call	okay		;if Okay then...
	jc	solve25		;(jump if not)
	mov	[bx+puzzle], dl	;make trial entry with digit; Puzzle(I):= Digit
	inc	bx		;pursue solution from here (recurse); Solve(I+1)
	call	solve
	dec	bx		;undo trial entry; Puzzle(I):= 0
	mov	[bx+puzzle], 0
solve25:
	inc	dl		;next digit
	cmp	dl, 9		;loop for digits 1..9
	jle	solve20
	jmp	solve40
solve30:
	inc	bx		;pursue solution from cell with value provided
	call	solve		;else	Solve(I+1)
solve40:
	pop	dx		;restore Digit
	pop	bx		;restore index (I)
	ret

;-------------------------------------------------------------------------------
;Returns carry flag set if the digit in dl is already used

;Check if a row already contains the digit:

okay:	mov	ax, bx		;get index (I) into puzzle array
	mov	cl, 9
	div	cl		;al:= ax/cl
	mov	y0, al		;get coordinates of I'th cell; Y0:= I/9
	mov	x0, ah		;X0:= remainder
	mul	cl		;ax:= al*cl

	mov	di, ax		;index to start of a row
	add	ax, 8		;index to end of the row
okay10:	cmp	[di+puzzle], dl	;check cell for digit
	jne	okay15
	stc			;indicate digit is already used
	ret			; and return
okay15:
	inc	di		;next cell across
	cmp	di, ax		;loop for 9 cells
	jle	okay10

;Check if a column already contains the digit:

	mov	di, word ptr x0	;index at top of column
okay20:	cmp	[di+puzzle], dl	;check cell for digit
	jne	okay25
	stc			;indicate digit is already used
	ret			; and return
okay25:
	add	di, 9		;next cell down
	cmp	di, 80		;loop for 9 cells
	jle	okay20

;Check if a 3x3 region already contains the digit:
;Find coordinates (X0,Y0) of upper-left cell in the 3x3 region

	mov	al, x0		;X0:= X0/3*3;		
	mov	ah, 0
	mov	cx, 3
	div	cl		;al:= ax/cl
	mul	cl		;ax:= al*cl
	mov	x0, al

	mov	al, y0		;Y0:= Y0/3*3
	mov	ah, 0
	div	cl		;al:= ax/cl
	mul	cl		;ax:= al*cl
	mov	y0, al

	imul	di, ax, 9	;di:= index of upper-left cell in region
	add	di, word ptr x0
okay30:	cmp	[di+puzzle], dl	;if Puzzle(di) = Digit then return false
	jne	okay32
	stc			;indicate digit is already used
	ret			; and return
okay32:
	cmp	[di+puzzle+1], dl ;if Puzzle(di+1) = Digit then return false
	jne	okay34
	stc			;indicate digit is already used
	ret			; and return
okay34:
	cmp	[di+puzzle+2], dl ;if Puzzle(di+2) = Digit then return false
	jne	okay36
	stc			;indicate digit is already used
	ret			; and return
okay36:
	add	di, 9		;next row down
	loop	okay30		;loop for 3 rows
	clc			;indicate that digit in dl is not already used
	ret

x0	db	0		;column coordinate of 1st cell to test
	db	0		;zero (needed for access by word registers)
y0	db	0		;row coordinate

;-------------------------------------------------------------------------------
;Output the solution

show:	mov	bx, 0		;for bx:= 0, 81-1 do...
show10:	mov	dl, [bx+puzzle]	; ChOut(0, Puz(bx)+^0);
	add	dl, '0'		; convert binary digit to ASCII
	mov	ah, 02h		; send it to stdout
	int	21h

	mov	ax, bx		; if rem(bx/9) = 8
	mov	cl, 9
	div	cl		; ah:= rem(ax/cl)
	cmp	ah, 8
	jne	show20		; (jump if not)

	mov	dl, 0Dh		; then output new line; CrLf(0)
	mov	ah, 02h
	int	21h
	mov	dl, 0Ah		; lf
	int	21h
	jmp	show30
show20:	
	mov	dl, ' '		; else output separating space character
	mov	ah, 02h		;  ChOut(0, ^ );
	int	21h
show30:
	inc	bx		;next bx
	cmp	bx, 81-1	;loop for all cells in the puzzle
	jle	show10
	ret


puzzle	db	81 dup (0)	;9x9 array of cells

cseg	ends
	end	main
