;Hugi Compo 25
;Sudoku Puzzle Solver by Beeblebrox/TMA
;Usage: entry <1.puz
; tasm /m9 entry.asm
; tlink /t/x entry.obj

.model tiny
.486
.code
                org     100h
start:
                mov     cl,19*9         ;cells total
                mov     si,cx           ;si points to the last cell
                mov     di,bp           ;offset puzzle_array
read_digit:     mov     ah,8
                int     21h
                stosb
                loop    read_digit
                mov     byte ptr [di],'$'
;Solve the puzzle using backtracking (recursive tree search)
solve:          pusha
not_empty:      dec     si
                js      print           ;stop when si<0
                cmp     byte ptr [bp+si],'.'
                jne     not_empty
                mov     dl,'9'          ;try all 9 digits...
DigitsLoop:
;Check if a row already contains the digit:
                mov     ax,si           ;get puzzle_array index (i=0...170)
                mov     cl,19
                div     cl              
                mov     bx,ax           ;bh=x0=i%19; bl=y0=i/19
                mul     cl              ;ah=0
                mov     di,ax           ;start of a row index
                add     di,bp
                mov     al,dl
                repne   scasb           ;find digit in a row
                je      bad_digit
;Check if a column already contains the digit:
                movzx   di,bh           ;x0=top of column index
                add     di,bp
                mov     cl,9
check_column:   scasb                   ;find digit in a column
                je      bad_digit
                add     di,18           ;next cell down
                loop    check_column
;Check if a 3x3 region already contains the digit:
;Find coordinates (x3,y3) of 3x3 region upper-left cell
                ; bl = y0, bh = x0, ah = 0
                mov     al,bl           ;y0
                mov     dh,3
                div     dh
                mul     dh              ;al=y3=y0/3*3
                xchg    bh,al           ;bh=y3, al=x0, ah=0
                mov     cl,6
                div     cl
                mul     cl              ;al=x3=x0/6*6
                mov     ah,bh           ;ah=y3
                aad     19              ;al=y3*19+x3; ah=0
                xchg    di,ax           ;di=index of 3x3 region upper-left cell
                add     di,bp
                mov     al,dl
row_loop:       mov     cl,6
                repne   scasb
                je      bad_digit
                add     di,19-6         ;next row down
                dec     dh
                jnz     row_loop        ;loop for 3 rows
; so digit dl is a candidate
                xchg    [bp+si],al      ;trial entry: Puzzle[i] = Digit
                call    solve           ;recurse solution
                xchg    [bp+si],al      ;undo trial entry: Puzzle[i] = '.'
bad_digit:      dec     dx              ;next digit
                cmp     dl,'0'
                jnz     DigitsLoop
                popa
                retn

print:          mov     dx,bp           ;offset puzzle_array
                xchg    ax,bp           ;ah = 9: print ASCII$
                int     21h
                int     20h

                end     start
