;;;
;;;  Stefan's Entry to Hugi Size Coding Competition 25 -- Sudoku Solver
;;;
;;;  First try again since compo 12. Assemble with tasm. Passes both
;;;  test suites nicely. Does not handle unsolvable puzzles.
;;;
;;;  Assumptions:
;;;    cld
;;;    cx >= 171
;;;  This assumes that input files are *exactly* 171 bytes. Otherwise,
;;;  it will overwrite its own code and/or print garbage.
;;;
;;;  111 bytes.
;;;
;;;  By Stefan <streu@gmx.de>
;;;
;;;  25/Jan/2006  started with 147 bytes; down to 121
;;;  26/Jan/2006  116 bytes (implicit termination, loop backwards, optimize loads)
;;;  28/Jan/2006  111 bytes (integrated Test3 subroutine)
;;;  30/Jan/2006  109 bytes (shuffled jumps around, removed recursion)
;;;

                MODEL   TINY
                CODESEG
                P386
                ORG     100h

; Set to 1 to debug this with a debugger that cannot redirect stdin
DEBUG = 0

; We store the puzzle at 0x0056 in 'raw' format (171 bytes from
; the input text file). This overwrites the default FCBs and the
; command line. Benefits: we can place the terminating '$' there
; without the need for code, and since the addresses never cross
; a 256-byte boundary, we can perform address arithmetics in 8 bit.
PUZZLE_LEN = 171
PUZZLE_ADR = 256 - PUZZLE_LEN + 1

Start:          mov     ax, 3F24h       ; the 24h in the opcode serves as terminator for output
                ;mov     cx, PUZZLE_LEN ; not needed according to general.txt
                pop     bx              ; zero
        IF DEBUG
                pusha
                mov     si, offset Puzzle
                mov     di, PUZZLE_ADR
                mov     cx, PUZZLE_LEN
                rep movsb
                popa
        ELSE
                call    Sys
        ENDIF

                ;cld                    ; not needed according to general.txt
                mov     si, dx
                ;; -- look for digit to fill in --
                pusha
Test4Done:      popa
                pusha
        
SolveLoop:      lodsb
                cmp     al, '$'
                je      Print
                cmp     al, '.'
                jne     SolveLoop
                ;; -- have to fill in this digit --
                dec     si
                mov     byte ptr [si], '9'
TryNextDigit:   pusha

                ;; -- validate puzzle --
                mov     si, offset Data
                mov     ah, 0Dh
Test4Loop:      lodsb
                xchg    cx, ax
                jcxz    Test4Done

                ;;; Validate puzzle part
                ;;; Input: [si-4][si-7] = minor scan (from one symbol of a group to the next one)
                ;;;        cx           = major scan (from one group to the next one)
Test3:          mov     bl, PUZZLE_ADR
                mov     ah, 0011011011b
Test3It:        mov     dl, 0011011011b
                mov     di, 0FF8h       ; '1' bits correspond to valid digits
Test3Loop:      mov     al, [bx]
                add     bl, cl

                sub     al, '.'
                jbe     Test3Next

                btc     di, ax
                jnc     Invalid

Test3Next:      shr     dl, 1
                jc      Test3Loop
                jz      Test3OK
                add     bl, ch
                jmp     Test3Loop
Test3OK:
                add     bl, [si-4]
                shr     ah, 1
                jc      Test3It
                jz      Test4Loop
                add     bl, [si-7]
                jmp     Test3It

                ;; -- solution is contradictory; backtrack --
Invalid:        popa

                dec     byte ptr [si]
                cmp     byte ptr [si], al
                ja      TryNextDigit
                jmp     Invalid

Print:          ;; -- found solution, print it --
                push    bx      ; always zero; forces return to DOS
                mov     ah, 9
Sys:            mov     dx, PUZZLE_ADR
                int     21h
                ret

                ;; Scan table
                ;; row 1:   additional step after each 3rd group
                ;; row 2:   step after each group
                ;; row 3:   step after each symbol
                ;;          additional step after each 3rd symbol is implicit
                ;; col 1:   3x3 squares
                ;; col 2:   lines
                ;; col 3:   columns
                db      (2*19+1),      0,    0
                db      -(3*19-6-13),  1,    -(9*19-2)
Data:           db      02h,           02h,  13h,       0

IF DEBUG
Puzzle:         db      "4 3 . . . . . 8 .",13,10
                db      "9 7 8 . . . . 6 5",13,10
                db      ". . . 8 6 9 . . 3",13,10
                db      ". . 5 . . 4 6 . .",13,10
                db      ". . 1 9 5 8 3 . .",13,10
                db      ". . 3 2 . . 9 . .",13,10
                db      "5 . . 1 7 3 . . .",13,10
                db      "8 6 . . . . 5 3 1",13,10
                db      ". 1 . . . . . 4 2",13,10
ENDIF

                END     Start
