
; Entry for Hugi Compo 25 - Sudoku Puzzle Solver by Digimind <digimind@aha.ru>
; Version 0.4    67 magic bytes    1 Feb 2006
; Compiled with "tasm /m9"


; The basic idea is to try all digits and backtrack when collision is found.
; Simple implementation in C++ looks like this:
;
;	int main()
;	{
;		input();
;		solve(0);
;		return 0;
;	}
;
;	void solve(int i)
;	{
;		if(i == sizeof(puzzle)) output(), exit(0);
;
;		if(puzzle[i] != '.') solve(i + 1);
;		else for(char digit = '9'; digit != '0'; digit--) {
;			if(!check(i, digit)) continue;
;			puzzle[i] = digit;
;			solve(i + 1);
;			puzzle[i] = '.';
;		}
;	}
;
; In asm version recursive calls are replaced with iteration.
;
; Function to check for collisions for a given digit at position pos1:
;
;	int check(int pos1, char digit)
;	{
;		for(int pos2 = 0; pos2 < sizeof(puzzle); pos2++) {
;			if(puzzle[pos2] != digit) continue;
;	
;			int row1 = pos1 / 19, column1 = pos1 % 19;
;			int row2 = pos2 / 19, column2 = pos2 % 19;
;			int region1 = row1 / 3 * 3 + column1 / 6;
;			int region2 = row2 / 3 * 3 + column2 / 6;
;	
;			if(row1 == row2) return 0;
;			if(column1 == column2) return 0;
;			if(region1 == region2) return 0;
;		}
;		return 1;
;	}
;
; Row and column calculation for position pos would be quite compact in asm:
;
;	mov ax, pos
;	aam 19		; ah <- row, al <- column
;
; So region calculation should be optimized now. Since both row and column
; numbers are already in ax, then it'd be pretty cool if some SIMD-like tricks
; could be used to avoid those multiple divisions. First, they are replaced:
;
;	row / 3      ->   row * 11 / 32      ->   row * 11 >> 5
;	column / 6   ->   column * 11 / 64   ->   column * 11 >> 6
;
; To detect collisions, region numbers don't have to be in 0..8 range,
; they just have to be same in each region and not same for different regions:
;
;	region = (row * 11 >> 5) * 256 + (column * 11 >> 6)
;
; Now replacing shifting with masking:
;
;	region = (row * 11 & 0xe0) * 256 + (column * 11 & 0xc0);
;
; And combining components:
;
;	region = (row * 256 + column) * 11 & 0xe0c0;
;
; So row, column and region calculation finally looks like this:
;
;	mov ax, pos
;	aam 19		; ah <- row, al <- column
;	imul ax, 11
;	and ax, 0e0c0h	; ax <- region
;
; For comparing values for pos1 and pos2, further tricks are used:
;
;	'xor' to detect same values,
;	delayed 'test' instead of 'and' to compare regions with zero flag,
;	'imul ah' to compare both rows and columns with overflow flag.


.386
cseg segment dword public use16 'code'
assume cs:cseg, ds:cseg, es:cseg, ss:cseg
org 100h

start:	mov ah, 3fh				; DOS Fn 3fH Read from File
	mov dh, '.'				; dx <- 2exxh, puzzle buffer
	int 21h					; returns 9 * 19, size of puzzle
	xchg bp, ax				; bp <- 9 * 19, ax <- 09xxh
	mov si, dx				; si <- 2exxh, puzzle buffer
	mov byte ptr [si + bp], '$'		; store end marker

pos_loop:	cmp [si + bp], dh		; look for '.'
		jne next_pos

		mov al, '9' + 1

digit_loop:		mov [si + bp], dh	; store/restore '.' at current position
			dec ax			; try next digit
			cmp al, '0'		; OF <- 0
			je restore_state

			mov bx, 9 * 19 - 1	; start checking from last position

check_loop:		cmp [si + bx], al	; look for current digit
			jne next_check

			pusha			; store regs
			xchg ax, bp

both:				aam 19		; ah <- row, al <- column
				imul ax, 11
				xchg ax, bx
				inc cx		; cl = 0ffh <- 00h <- 01h
				jp both		; loop twice

			xor ax, bx		; test for equality
			test ax, 0e0c0h		; ZF <- 1 if same region, OF <- 0
			jz restore_regs

			imul ah			; OF <- 0 if same row or column

restore_state:
restore_regs:		popa
			jno digit_loop

next_check:		dec bx			; try next checking position
			jns check_loop

		pusha				; store state
		mov [si + bp], al		; store digit at current position

next_pos:	dec bp				; try next position
		jns pos_loop

	int 21h					; ah = 09h, DOS Fn 09H Display String
	ret					; top of stack contains di from previous pusha
						; so this returns to cs:0fffeh, which contains:
						; add [si + bx], al
						; int 20h
cseg ends
end start
